;(function($, window, document, undefined) {
	$(function() {
		qpSwitchTopLevelMenuLinkURL($('.toplevel_page_my-brindle'), $('#toplevel_page_my-brindle > .wp-submenu > .wp-first-item + li > a'));
		qpUpdatePopupTitle();
		qpSnoozeUpsell();
		qpAddCustomClassToPopupLibraryItem();
		qpHandleShortcodeField();
		qpAddPreviewBtn();
		qpTriggerPreviewPopup();

		function qpSwitchTopLevelMenuLinkURL($item, $switch) {
			const newUrl = $switch.attr('href');

			$item.attr('href', newUrl);
		}

		function qpUpdatePopupTitle() {
			var $crbPopupTitleField = $('[name="carbon_fields_compact_input[_qp_form_title]"]');

			if ($crbPopupTitleField.length < 1) {
				return;
			}

			$(window).on('load', function() {
				$('#title').val($crbPopupTitleField.val());
			});

			$crbPopupTitleField.on('input', function() {
				$('#title').val($(this).val());
			});
		}

		function qp_dashboardSetCookie(cookieName, cookieValue, expirationDays) {
			const date = new Date();
			date.setTime(date.getTime() + (expirationDays * 24 * 60 * 60 * 1000));
			const expires = "expires="+ date.toUTCString();
			document.cookie = cookieName + "=" + cookieValue + ";" + expires + ";path=/";
		}

		function qpSnoozeUpsell() {
			$('.js-upsell-snooze').on('click', function(event) {
				event.preventDefault();

				$(this).closest('#carbon_fields_container_qp_sidebar').remove();
				$(this).closest('.qp-upsell-ad').remove();

				qp_dashboardSetCookie('qp_library_upsell_hidden', true, 15);
			});
		}

		function qpAddCustomClassToPopupLibraryItem() {
			$('#toplevel_page_my-brindle .wp-submenu > li').each(function() {
				var $this = $(this);

				if ($this.children('a').text() === 'Popups Library') {
					$this.addClass('qp-with-arrow');
				}
			})
		}

		function qpHandleShortcodeField() {
			$(window).on('load', function() {
				var $field = $('[name="carbon_fields_compact_input[_qp_event_btn_shortcode]"]');

				$(document).on('click', '[name="carbon_fields_compact_input[_qp_event_btn_shortcode]"]', function(event) {
					var $this = $(this);
					var $parent = $this.parent();
					
					$this.val($this.attr('placeholder'));

					$this.select();
					document.execCommand('copy');

					$parent.find('.qp-helper-popup').remove();
					$parent.append('<div class="qp-helper-popup">Copied to clipboard.</div>');

					var $popup = $parent.find('.qp-helper-popup');

					$popup.css({
						'top': event.clientY + 'px',
						'left': event.clientX + 'px',
					});

					setTimeout(function() {
						$popup.fadeOut();
					}, 1000);
				});
			});
		}

		function qpAddPreviewBtn() {
			$(window).on('load', function() {
				var $container = $('.cf-container-carbon_fields_container_quickpop_by_brindle');

				if (! $container.length) {
					return;
				}

				$container.find('.cf-container__tabs').append('<a href="#" class="js-qp-preview qp-btn-preview"><i class="qp-ico-preview"></i></a>');
			});
		}

		function qpTriggerPreviewPopup() {
			$(document).on('click', '.js-qp-preview', function(event) {
				event.preventDefault();

				var windowSearch = window.location.search;
				var windowSearchSplit = windowSearch.split('&');
				var id = '';

				windowSearchSplit.forEach(function(elem, index) {
					var split = elem.split('=');

					if (split[0].replace('?', '') === 'post') {
						id = split[1];
					}
				});

				$.ajax({
					url: qp_site_ajax.ajaxurl,
					method: 'POST',
					data: {
						action: 'qp_get_popup_preview',
						popup_id: id
					},
					beforeSend: function() {
						$('body').append('<div class="qp-preview-container"><a href="#" class="js-qp-preview-close qp-preview-close"></a><i class="qp-preview-loading"></i><div class="qp-preview-container-inner"></div></div>');
					},
					success: function( response ) {
						if( response.status === 'error' ) {
							$('.qp-preview-container').remove();
						} else {
							$('.qp-preview-container .qp-preview-loading').remove();
							$('.qp-preview-container .qp-preview-container-inner').html(response.popup);
							
							setTimeout(function() {
								$('.qp-popup').addClass('is-visible');
							}, 400);
						}
					},
					error: function() {
						alert('Something went wrong. Please reload the page and try again.');
					}
				});
			});
		}


		$(window).on('load', function() {
			if (! $('body').is('.post-type-qp_popup')) {
				return;
			}

			setTimeout(function() {
				$('body').css({
					'overflow' : 'visible',
				});

				$(window).scrollTop(0)
			}, 1000);
		});
	});
})(jQuery, window, document);