<?php

add_action( 'wp_ajax_qp_ajax_form_submission', 'qp_ajax_form_submission' );
add_action( 'wp_ajax_nopriv_qp_ajax_form_submission', 'qp_ajax_form_submission' );

function qp_ajax_form_submission() {
	$new_post = array(
		'post_type' => 'qp_submissions',
		'post_title' => sanitize_email( $_POST['email'] ),
		'post_date' => Date('Y-m-d H:i:s'),
		'post_status' => 'publish',
	);

	$post_id = wp_insert_post( $new_post );

	if ( isset( $_POST['name'] ) ) {
		carbon_set_post_meta( $post_id, 'qp_submission_name', sanitize_text_field( $_POST['name'] ) );
	}

	if ( isset( $_POST['phone'] ) ) {
		carbon_set_post_meta( $post_id, 'qp_submission_phone', mbqp_filter_phone_number( $_POST['phone'] ) );
	}

	if ( isset( $_POST['id'] ) ) {
		$post = get_post( intval( sanitize_text_field( $_POST['id'] ) ) );

		if ( ! empty( $post ) ) {
			carbon_set_post_meta( $post_id, 'qp_submission_popup_title', $post->post_title );
		}
	}

	wp_die();
}

add_action( 'wp_ajax_qp_ajax_form_submission_hubspot', 'qp_ajax_form_submission_hubspot' );
add_action( 'wp_ajax_nopriv_qp_ajax_form_submission_hubspot', 'qp_ajax_form_submission_hubspot' );

function qp_ajax_form_submission_hubspot() {
	$form_data = isset( $_POST['form_data'] ) ? $_POST['form_data'] : '';

	$return = [
		'submission' => 'unsuccessful',
	];

	if ( empty( $form_data ) ) {
		wp_send_json( $return );
	}

	$post_title = wp_date( 'Y-m-d H:i:s' );

	foreach ( $form_data as $item ) {
		if ( $item['name'] === 'email' && ! empty( $item['value'] ) ) {
			$post_title = esc_sql( $item['value'] );

			break;
		}
	}

	$new_post = [
		'post_type' => 'qp_submissions',
		'post_title' => $post_title,
		'post_date' => Date( 'Y-m-d H:i:s' ),
		'post_status' => 'publish',
	];

	$post_id = wp_insert_post( $new_post );

	carbon_set_post_meta( $post_id, 'qp_submission_form', 'Hubspot Form' );

	$submission_data = '';

	foreach ( $form_data as $item ) {
		if ( ! array_key_exists( 'name', $item ) || ! array_key_exists( 'value', $item ) ) {
			continue;
		}

		if ( $item->name === 'hs_context' ) {
			continue;		}

		$submission_data .= $item['name'] . ': ' . $item['value'] . "\n";
	}

	carbon_set_post_meta( $post_id, 'qp_submission_hubspot_form_data', $submission_data );

	$return['submission'] = 'successful';
	$return['data'] = $form_data;

	wp_send_json( $return );

	wp_die();
}

add_action( 'wp_ajax_qp_ajax_form_submission_mailchimp', 'qp_ajax_form_submission_mailchimp' );
add_action( 'wp_ajax_nopriv_qp_ajax_form_submission_mailchimp', 'qp_ajax_form_submission_mailchimp' );

function qp_ajax_form_submission_mailchimp() {
	$form_data = isset( $_POST['form_data'] ) ? $_POST['form_data'] : '';

	$return = [
		'submission' => 'unsuccessful',
	];

	if ( empty( $form_data ) ) {
		wp_send_json( $return );
	}

	$post_title = wp_date( 'Y-m-d H:i:s' );

	foreach ( $form_data as $item ) {
		if ( $item['name'] === 'EMAIL' && ! empty( $item['value'] ) ) {
			$post_title = esc_sql( $item['value'] );

			break;
		}
	}

	$new_post = [
		'post_type' => 'qp_submissions',
		'post_title' => $post_title,
		'post_date' => Date( 'Y-m-d H:i:s' ),
		'post_status' => 'publish',
	];

	$post_id = wp_insert_post( $new_post );

	carbon_set_post_meta( $post_id, 'qp_submission_form', 'MailChimp Form' );

	$submission_data = '';

	foreach ( $form_data as $item ) {
		if ( ! array_key_exists( 'name', $item ) || ! array_key_exists( 'value', $item ) ) {
			continue;
		}

		if ( $item->name === 'hs_context' ) {
			continue;		}

		$submission_data .= $item['name'] . ': ' . $item['value'] . "\n";
	}

	carbon_set_post_meta( $post_id, 'qp_submission_mailchimp_form_data', $submission_data );

	$return['submission'] = 'successful';
	$return['data'] = $form_data;

	wp_send_json( $return );

	wp_die();
}

add_action( 'wp_ajax_qp_duplicate_popup', 'qp_duplicate_popup' );
add_action( 'wp_ajax_nopriv_qp_duplicate_popup', 'qp_duplicate_popup' );

function qp_duplicate_popup() {
	$id = isset( $_POST['id'] ) ? strip_tags( $_POST['id'] ) : '';

	$status = 'fail';
	$new_popup_html = '';

	if ( ! empty( $id ) ) {
		$popup = get_post( intval( $id ) );

		$new_post = array(
			'post_type' => 'qp_popup',
			'post_title' => get_the_title( $id ) . ' - ' . Date('Y-m-d H:i:s'),
			'post_date' => Date( 'Y-m-d H:i:s' ),
			'post_status' => 'publish',
		);

		$post_id = wp_insert_post( $new_post );

		mbqp_duplicate_popup_custom_fields($id, $post_id);

		$status = 'success';
	}

	if ( ! empty( $post_id ) ) {
		ob_start();

		$post = get_post( $post_id );

		$post_status = $post->post_status;

		if ( $post_status === 'publish' ) {
			$post_status = 'live';
		} else {
			$post_status = 'draft';
		}

		$post_disabled = carbon_get_post_meta( $post->ID, 'qp_status' );

		if ( $post_disabled === 'qp_disabled' ) {
			$post_status = 'disabled';
		}

		include QP_PLUGIN_DIR . 'templates/parts/popup-list-item.php';

		$new_popup_html = ob_get_contents();

		ob_end_clean();
	}

	wp_send_json( [
		'status' => $status,
		'new_popup_html' => $new_popup_html,
	] );

	wp_die();
}

add_action( 'wp_ajax_qp_update_popup_status', 'qp_update_popup_status' );
add_action( 'wp_ajax_nopriv_qp_update_popup_status', 'qp_update_popup_status' );

function qp_update_popup_status() {
	$id = isset( $_POST['id'] ) ? strip_tags( $_POST['id'] ) : '';
	$new_status = isset( $_POST['status'] ) ? strip_tags( $_POST['status'] ) : '';

	$request_status = 'fail';

	if ( ! empty( $id ) || ! empty( $new_status ) ) {
		$post = get_post( $id );

		if ( ! empty( $post ) ) {
			if ( $new_status === 'live' ) {
				wp_update_post([
					'ID' => $post->ID,
					'post_status' => 'publish'
				]);

				carbon_set_post_meta( $post->ID, 'qp_status', 'qp_enabled' );
			} else {
				carbon_set_post_meta( $post->ID, 'qp_status', 'qp_disabled' );
			}

			$request_status = 'success';
		}
	}

	wp_send_json( [
		'status' => $request_status,
	] );

	wp_die();
}