<?php

add_shortcode( 'qp_popup_trigger_btn', 'qp_popup_trigger_btn' );

function qp_popup_trigger_btn( $atts ) {
	if ( empty( $atts['content'] ) ) {
		$atts['content'] = 'Book Our Service';
	}

	if ( empty( $atts['popup-id'] ) ) {
		$atts['popup-id'] = 'null';
	}

	$data_attributes = [];
	foreach ( $atts as $key => $value ) {
		if ( strpos( $key, 'data-' ) === 0 ) { // if the $key starts with "data-"
			$data_attributes[ $key ] = $value;
		}
	}

	ob_start();

	?>

	<a
	class="qp-js-trigger-popup-<?php echo $atts['popup-id']; ?> <?php echo $atts['class'] ?>"
	<?php if ( ! empty( $atts['id'] ) ) : ?>
		id="<?php echo $atts['id']; ?>"
	<?php endif; ?>
	href="#"
	<?php foreach ( $data_attributes as $key => $value ) : ?>
		<?php printf( '%s="%s"', esc_attr( $key ), esc_attr( $value ) )?>
	<?php endforeach; ?>
	>
		<?php echo $atts['content'] ?>
	</a>

	<?php

	$html = ob_get_clean();

	return $html;
}