<?php

# Enqueue JS and CSS assets on the front-end
add_action('wp_enqueue_scripts', 'qp_wp_enqueue_scripts');
function qp_wp_enqueue_scripts() {

	$functions_js_dir = QP_PLUGIN_DIR . 'js/functions.js';
	$functions_js_url = QP_PLUGIN_URL . 'js/functions.js';

	# Enqueue Custom JS files
	wp_enqueue_script('qp-functions', $functions_js_url, array('jquery'), filemtime( $functions_js_dir ) );
	wp_localize_script('qp-functions', 'qp_options', array(
		'ajax_url' => admin_url('admin-ajax.php')
	));

	$style_css_dir = QP_PLUGIN_DIR . 'css/style.css';
	$style_css_url = QP_PLUGIN_URL . 'css/style.css';

	# Enqueue Custom CSS files
	# @crb_enqueue_style attributes -- id, location, dependencies, media = all
	wp_enqueue_style('qp-styles', $style_css_url, array(), filemtime( $style_css_dir ) );
	wp_enqueue_style('qp-font-styles', 'https://use.typekit.net/eip0gix.css', array());
}