<?php

add_action( 'wp_ajax_qp_get_popup_preview', 'qp_get_popup_preview' );
add_action( 'wp_ajax_nopriv_qp_get_popup_preview', 'qp_get_popup_preview' );

function qp_get_popup_preview() {
	$post_id = isset( $_POST['popup_id'] ) ? absint( strip_tags( $_POST['popup_id'] ) ) : '';

	if ( empty( $post_id ) ) {
		wp_send_json( [
			'status' => 'error',
			'status_message' => 'Incorrect or missing popup ID.'
		] );

		wp_die();
	}

	$admin_preview = true;

	ob_start();

	include(QP_PLUGIN_DIR . 'fragments/quickpop.php');

	$popup = ob_get_contents();

	ob_end_clean();

	wp_send_json( [
		'status' => 'success',
		'popup' => $popup,
	] );

	wp_die();
}