<?php

add_action('admin_enqueue_scripts', 'qp_wp_enqueue_scripts_popup_preview');
function qp_wp_enqueue_scripts_popup_preview() {
	if ( empty( $_GET['post'] ) ) {
		return;
	}

	$post = get_post( esc_html( $_GET['post'] ) );

	if ( empty( $post ) ) {
		return;
	}

	if ( $post->post_type !== 'qp_popup' ) {
		return;
	}

	$functions_js_dir = QP_PLUGIN_DIR . 'js/functions.js';
	$functions_js_url = QP_PLUGIN_URL . 'js/functions.js';

	# Enqueue Custom JS files
	wp_enqueue_script('qp-functions', $functions_js_url, array('jquery'), filemtime( $functions_js_dir ) );
	wp_localize_script('qp-functions', 'qp_options', array(
		'ajax_url' => admin_url('admin-ajax.php')
	));

	$style_css_dir = QP_PLUGIN_DIR . 'css/style.css';
	$style_css_url = QP_PLUGIN_URL . 'css/style.css';

	# Enqueue Custom CSS files
	# @crb_enqueue_style attributes -- id, location, dependencies, media = all
	wp_enqueue_style('qp-styles', $style_css_url, array(), filemtime( $style_css_dir ) );
	wp_enqueue_style('qp-font-styles', 'https://use.typekit.net/eip0gix.css', array());
}

add_action( 'admin_enqueue_scripts', 'qp_enqueue_files_admin' );

function qp_enqueue_files_admin() {
	$admin_js_dir = QP_PLUGIN_DIR . 'js/utils/admin.js';
	$admin_css_dir = QP_PLUGIN_DIR . 'css/utils/admin.css';
	$duplicate_js_dir = QP_PLUGIN_DIR . 'js/utils/duplicate-popup.js';
	$update_status_js_dir = QP_PLUGIN_DIR . 'js/utils/update-popup-status.js';

	$admin_js_url = QP_PLUGIN_URL . 'js/utils/admin.js';
	$duplicate_js_url = QP_PLUGIN_URL . 'js/utils/duplicate-popup.js';
	$update_status_js_url = QP_PLUGIN_URL . 'js/utils/update-popup-status.js';
	$admin_css_url = QP_PLUGIN_URL . 'css/utils/admin.css';

	wp_enqueue_script('qp-admin-js', $admin_js_url, [ 'jquery' ], filemtime( $admin_js_dir ) );
	wp_enqueue_script('qp-admin-duplicate-popup-js', $duplicate_js_url, [ 'jquery', 'qp-admin-js' ], filemtime( $duplicate_js_dir ) );
	wp_enqueue_script('qp-admin-update-popup-status-js', $update_status_js_url, [ 'jquery', 'qp-admin-js' ], filemtime( $update_status_js_dir ) );
	wp_enqueue_style('qp-admin-styles', $admin_css_url, [], filemtime( $admin_css_dir ) );
	wp_enqueue_style('qp-admin-font-styles', 'https://use.typekit.net/eip0gix.css', []);

	wp_localize_script( 'qp-admin-js', 'qp_site_ajax', [
		'ajaxurl' => admin_url( 'admin-ajax.php'),
	] );
}