<?php

add_action('wp_footer', 'qp_popup_html');

function qp_popup_html() {
	$current_page_id  = get_the_ID();

	$query = new WP_Query( array(
		'post_type' => 'qp_popup',
		'post_status' => 'publish',
		'posts_per_page' => -1
	) );

	$posts = $query->posts;

	$admin_preview = false;

	foreach ( $posts as $post ) {
		$post_id = $post->ID;

		$event_type   = carbon_get_post_meta( $post_id, 'qp_event_type' );
		$snooze_popup = carbon_get_post_meta( $post_id, 'qp_snooze_popup' );

		if ( ! empty( $snooze_popup ) ) {
			if ( isset( $_COOKIE['hide-popup-' . $post_id] ) && $event_type !== 'on_click' ) {
				continue;
			}
		}

		$visibility = carbon_get_post_meta( $post_id, 'qp_settings_display_pages' );

		if ( $visibility === 'qp_all' ) {
			include(QP_PLUGIN_DIR . 'fragments' . DIRECTORY_SEPARATOR . 'quickpop.php');
		} else {
			$visible_pages    = carbon_get_post_meta( $post_id, 'qp_popup_visible_pages' );
			$visible_page_ids = [];

			foreach ( $visible_pages as $page ) {
				$visible_page_ids[] = $page['id'];
			}

			if ( in_array( $current_page_id, $visible_page_ids ) ) {
				include(QP_PLUGIN_DIR . 'fragments' . DIRECTORY_SEPARATOR . 'quickpop.php');
			}
		}
	}
}

function mbqp_filter_phone_number( $phone ) {
	return preg_replace('/[^0-9\-\_\+]*/', '', $phone );
}

function mbqp_get_popup_carbon_fields() {
	$fields = [
		'qp_title',
		'qp_body',
		'qp_embed_forms',
		'qp_mailchimp_form',
		'qp_hubspot_form_id',
		'qp_hubspot_form_region',
		'qp_hubspot_form_portal',
		'qp_button_text',
		'qp_button_link',
		'qp_button_new_tab',
		'qp_acknoledgement_title',
		'qp_acknoledgement_include',
		'qp_acknoledgement_required',
		'qp_acknoledgement_checked',
		'qp_acknoledgement',
		'qp_email_include',
		'qp_email_required',
		'qp_email_placeholder',
		'qp_name_include',
		'qp_name_required',
		'qp_field_name_placeholder',
		'qp_phone_include',
		'qp_phone_required',
		'qp_field_phone_placeholder',
		'qp_field_form_button_text',
		'qp_field_form_message',
		'qp_popup_close_link_include',
		'qp_popup_close_link_message',
		'qp_popup_close_link_message_alignment',
		'qp_include_button',
		'qp_include_form',
		'qp_text_color',
		'qp_fields_color',
		'qp_popup_width_type',
		'qp_popup_width',
		'qp_popup_container_radius',
		'qp_popup_bg_type',
		'qp_popup_bg',
		'qp_popup_exit_button_styling',
		'qp_popup_gradient_color_1',
		'qp_popup_gradient_color_2',
		'qp_popup_gradient_direction',
		'qp_popup_border_width',
		'qp_popup_border_color',
		'qp_popup_overlay_bg',
		'qp_popup_overlay_gradient_color_1',
		'qp_popup_overlay_gradient_color_2',
		'qp_popup_overlay_gradient_direction',
		'qp_overlay_opacity',
		'qp_btn_radius',
		'qp_standard_button_color',
		'qp_standard_button_alignment',
		'qp_form_button_color',
		'qp_form_field_background',
		'qp_form_field_border',
		'qp_custom_css_code',
		'qp_status',
		'qp_settings_form_title',
		'qp_form_title',
		'qp_settings_display_pages',
		'qp_popup_visible_pages',
		'qp_position',
		'qp_event_type',
		'qp_settings_delay',
		'qp_snooze_popup',
		'qp_number_of_days_snooze',
		'qp_animation_type',
		'qp_animation_speed',
	];

	return $fields;
}

function mbqp_duplicate_popup_custom_fields($original_popup_id, $new_popup_id) {
	$meta_keys = mbqp_get_popup_carbon_fields();

	foreach ( $meta_keys as $meta_key ) {
		$original_meta_value = carbon_get_post_meta( $original_popup_id, $meta_key );

		carbon_set_post_meta( $new_popup_id, $meta_key, $original_meta_value );
	}

	return true;
}

add_filter( 'body_class', 'mbqp_browser_classes' );
function mbqp_browser_classes( $classes ) {
    global $is_IE; // Internet Explorer

    if (  $is_IE ) {
        $classes[] = 'qp-browser-ie';
    }

    return $classes;
}

/**
 * Escape User input from WYSIWYG editors.
 *
 * Calls all filters usually executed on `the_content`.
 *
 * @param  string $content The content that needs to be escaped.
 * @return string The escaped content.
 */
function crb_content( $content ) {
	return apply_filters( 'crb_content', $content );
}

/**
 * Attach all Hooks from `the_content` on `crb_content`.
 */
add_filter( 'crb_content', 'wptexturize'                          );
add_filter( 'crb_content', 'wpautop'                              );
add_filter( 'crb_content', 'shortcode_unautop'                    );
add_filter( 'crb_content', 'prepend_attachment'                   );
add_filter( 'crb_content', 'wp_filter_content_tags'               );
add_filter( 'crb_content', 'do_shortcode',                     12 );
add_filter( 'crb_content', 'convert_smilies',                  20 );

add_filter('manage_qp_submissions_posts_columns', function( $columns ) {
	$orderby = esc_html( $_GET['orderby'] );
	$order = esc_html( $_GET['order'] );
	$new_order = 'desc';
	$class = '';

	if ( ! empty( $order ) && $order === 'desc' && $orderby === 'popup_title' ) {
		$new_order = 'asc';
	}

	if ( $orderby === 'popup_title' && ! empty( $order ) ) {
		$class = $order;
	}

	$new_column = [ 'popup_title' => sprintf( '<a class="%s" href="%sedit.php?post_type=qp_submissions&amp;orderby=popup_title&amp;order=%s"><span>%s</span> <span class="sorting-indicator"></span></a>', $class, admin_url(), $new_order, __( 'Popup Title', 'mb-qp' ) ) ];

	$first_part = array_splice( $columns, 0, 2 );

	$final_columns = array_merge( $first_part, $new_column, $columns );

	return $final_columns;
});

add_action( 'manage_qp_submissions_posts_custom_column', function( $column_key, $post_id ) {
	if ( $column_key === 'popup_title' ) {
		$title = carbon_get_post_meta( $post_id, 'qp_submission_popup_title' );

		echo ! empty( $title ) ? $title : '';
	}
}, 10, 2 );

add_action( 'pre_get_posts', 'mbqp_add_custom_order_submissions', 10, 1 );

function mbqp_add_custom_order_submissions( $query ) {
	if ( ! is_admin() || empty( $_GET['post_type'] ) || $_GET['post_type'] !== 'qp_submissions' ) {
		return;
	}

	if ( $query->get( 'post_type' ) !== 'qp_submissions' ) {
		return;
	}

	$order = isset( $_GET['order'] ) ? esc_html( $_GET['order'] ) : '';
	$orderby = isset( $_GET['orderby'] ) ? esc_html( $_GET['orderby'] ) : '';

	if ( empty( $orderby ) || empty( $order ) || $orderby !== 'popup_title' ) {
		return;
	}

	$query->set( 'orderby', 'meta_value' );
	$query->set( 'meta_key', '_qp_submission_popup_title' );
	$query->set( 'order', strtoupper( $order ) );
}

