<?php

$overlay_opacity = carbon_get_post_meta( $post_id, 'qp_overlay_opacity' );
$overlay_opacity = str_replace( '%', '', $overlay_opacity );
$overlay_opacity = ! empty( $overlay_opacity ) && is_numeric( $overlay_opacity ) ? strval( intval( $overlay_opacity ) / 100 ) : '84';

$overlay_bg_type = carbon_get_post_meta(  $post_id, 'qp_popup_overlay_bg_type' );

if ( $overlay_bg_type === 'regular' ) {
	$overlay_bg_color = carbon_get_post_meta(  $post_id, 'qp_popup_overlay_bg' );
	$overlay_bg_color = ! empty( $overlay_bg_color ) ? $overlay_bg_color : '#333333';

	$color_processed = str_replace( '#', '', $overlay_bg_color );
	$color_processed = str_split( $color_processed, 2 );

	$r = hexdec( $color_processed[0] );
	$g = hexdec( $color_processed[1] );
	$b = hexdec( $color_processed[2] );

	$overlay_style = sprintf( 'background: rgba(%s,%s,%s,%s)', $r, $g, $b, $overlay_opacity );
} else {
	$overlay_bg_color_1 = carbon_get_post_meta( $post_id, 'qp_popup_overlay_gradient_color_1' );
	$overlay_bg_color_1 = ! empty( $overlay_bg_color_1 ) ? $overlay_bg_color_1 : '#333333';

	$color_processed_1 = str_replace( '#', '', $overlay_bg_color_1 );
	$color_processed_1 = str_split( $color_processed_1, 2 );

	$r_1 = hexdec( $color_processed_1[0] );
	$g_1 = hexdec( $color_processed_1[1] );
	$b_1 = hexdec( $color_processed_1[2] );

	$overlay_bg_color_2 = carbon_get_post_meta( $post_id, 'qp_popup_overlay_gradient_color_2' );
	$overlay_bg_color_2 = ! empty( $overlay_bg_color_2 ) ? $overlay_bg_color_2 : '#333333';

	$color_processed_2 = str_replace( '#', '', $overlay_bg_color_2 );
	$color_processed_2 = str_split( $color_processed_2, 2 );

	$r_2 = hexdec( $color_processed_2[0] );
	$g_2 = hexdec( $color_processed_2[1] );
	$b_2 = hexdec( $color_processed_2[2] );

	$direction = carbon_get_post_meta( $post_id, 'qp_popup_overlay_gradient_direction' );

	$rgba_1 = sprintf( 'rgba(%s,%s,%s,%s)', $r_1, $g_1, $b_1, $overlay_opacity );
	$rgba_2 = sprintf( 'rgba(%s,%s,%s,%s)', $r_2, $g_2, $b_2, $overlay_opacity );

	$overlay_style = sprintf( 'background-image: linear-gradient(%s, %s, %s);', str_replace( '_', ' ', $direction ), $rgba_1, $rgba_2 );
}