<?php

$animation_type  = carbon_get_post_meta( $post_id, 'qp_animation_type' );
$animation_speed = carbon_get_post_meta( $post_id, 'qp_animation_speed' );

if ( empty( $animation_speed ) || ! is_numeric( $animation_speed ) ) {
	$animation_speed = '4';
}

$animation_speed = intval( $animation_speed ) / 1000;

$animation_class = 'qp-popup--' . str_replace( '_', '-', $animation_type );

?>

<style type="text/css" media="screen">
	<?php echo '#qp-popup-' . $post_id; ?> .qp-popup__body:not(.qp-popup__body--success) { transition-duration: <?php echo $animation_speed ?>s; }

	.qp-popup.is-submitted .qp-popup__body:not(.qp-popup__body--success) { opacity: 0; visibility: hidden; }
</style>