<?php

if ( empty( $include_form ) ) {
	return;
}

$form_acknoledgement_include = carbon_get_post_meta( $post_id, 'qp_acknoledgement_include' );
$form_email_include          = carbon_get_post_meta( $post_id, 'qp_email_include' );
$form_name_include           = carbon_get_post_meta( $post_id, 'qp_name_include' );
$form_phone_include          = carbon_get_post_meta( $post_id, 'qp_phone_include' );

$acknoledgement          = carbon_get_post_meta( $post_id, 'qp_acknoledgement' );
$acknoledgement_checked  = carbon_get_post_meta( $post_id, 'qp_acknoledgement_checked' );
$acknoledgement_required = carbon_get_post_meta( $post_id, 'qp_acknoledgement_required' );

$multiple_fields  = ! empty( $form_email_include ) ? ( ! empty( $form_name_include ) || ! empty( $form_phone_include ) ) : ( ! empty( $form_name_include ) && ! empty( $form_phone_include ) );

$form_button_text = carbon_get_post_meta( $post_id, 'qp_field_form_button_text' );

$form_button_color = carbon_get_post_meta( $post_id, 'qp_form_button_color' );
$form_field_background = carbon_get_post_meta( $post_id, 'qp_form_field_background' );
$form_field_border = carbon_get_post_meta( $post_id, 'qp_form_field_border' );

?>

<div class="qp-popup__form <?php echo $multiple_fields ? 'qp-popup__form--multiple-fields' : ''; ?>">
	<form class="qp-form" action="<?php echo QP_PLUGIN_URL . 'ajax/quickpop-submit.php' ?>" method="post" novalidate>
		<?php if ( ! empty( $form_acknoledgement_include ) && ! empty( $acknoledgement ) ) : ?>
			<div class="qp-popup__form-acknoledgement">
				<div class="qp-popup-form-checkbox">
					<input
					type="checkbox"
					name="qp-popup-form-acknoledgement"
					class="qp-popup-form-checkbox qp-field"
					id="qp-popup-form-acknoledgement"
					<?php echo ! empty( $acknoledgement_checked ) ? 'checked' : '' ?>
					<?php echo ! empty( $acknoledgement_required ) ? 'required' : '' ?>>

					<label for="qp-popup-form-acknoledgement">
						<?php echo crb_content( $acknoledgement ); ?>
					</label>
				</div><!-- /.qp-popup-form-checkbox -->
			</div><!-- /.qp-popup__form-acknoledgement -->
		<?php endif; ?>

		<div class="qp-popup__form-body">
			<ul>
				<?php if ( ! empty( $form_email_include ) ) :

					$form_email_required    = carbon_get_post_meta( $post_id, 'qp_email_required' );
					$form_email_placeholder = carbon_get_post_meta( $post_id, 'qp_email_placeholder' );

				?>
					<li>
						<div class="qp-popup__form-controls">
							<label class="qp-label-hidden" for="qp-popup-form-email-field"><?php _e( 'Email Address', 'mb-qp' ) ?></label>

							<input
							style="background: <?php echo ! empty( $form_field_background ) ? $form_field_background : '#f9f9f9'; ?>; border-color: <?php echo ! empty( $form_field_border ) ? $form_field_border : 'transparent'; ?>"
							class="qp-field qp-email-field"
							id="qp-popup-form-email-field"
							name="qp-popup-form-email-field"
							type="text"
							placeholder="<?php echo ! empty( $form_email_placeholder ) ? esc_html( $form_email_placeholder ) : ''; ?>"
							<?php echo ! empty( $form_email_required ) ? 'required' : '' ?>>
						</div><!-- /.qp-popup__form-controls -->
					</li>
				<?php endif; ?>

				<?php if ( ! empty( $form_name_include ) ) :

					$form_name_required    = carbon_get_post_meta( $post_id, 'qp_name_required' );
					$form_name_placeholder = carbon_get_post_meta( $post_id, 'qp_field_name_placeholder' );

				?>
					<li>
						<div class="qp-popup__form-controls">
							<label class="qp-label-hidden" for="qp-popup-form-name-field"><?php echo _e( 'Name', 'mb-qp' ) ?></label>

							<input
							style="background: <?php echo ! empty( $form_field_background ) ? $form_field_background : '#f9f9f9'; ?>; border-color: <?php echo ! empty( $form_field_border ) ? $form_field_border : 'transparent'; ?>"
							class="qp-field qp-text-field"
							id="qp-popup-form-name-field"
							name="qp-popup-form-name-field"
							type="text"
							placeholder="<?php echo ! empty( $form_name_placeholder ) ? esc_html( $form_name_placeholder ) : ''; ?>"
							<?php echo ! empty( $form_name_required ) ? 'required' : '' ?>>
						</div><!-- /.qp-popup__form-controls -->
					</li>
				<?php endif; ?>

				<?php if ( ! empty( $form_phone_include ) ) :

					$form_phone_required    = carbon_get_post_meta( $post_id, 'qp_phone_required' );
					$form_phone_placeholder = carbon_get_post_meta( $post_id, 'qp_field_phone_placeholder' );

				?>
					<li>
						<div class="qp-popup__form-controls">
							<label class="qp-label-hidden" for="qp-popup-form-name-field"><?php echo _e( 'Phone Number', 'mb-qp' ) ?></label>

							<input
							style="background: <?php echo ! empty( $form_field_background ) ? $form_field_background : '#f9f9f9'; ?>; border-color: <?php echo ! empty( $form_field_border ) ? $form_field_border : 'transparent'; ?>;"
							class="qp-field qp-phone-field"
							id="qp-popup-form-phone-field"
							name="qp-popup-form-phone-field"
							type="text"
							placeholder="<?php echo ! empty( $form_phone_placeholder ) ? esc_html( $form_phone_placeholder ) : ''; ?>"
							<?php echo ! empty( $form_phone_required ) ? 'required' : '' ?>>
						</div><!-- /.qp-popup__form-controls -->
					</li>
				<?php endif; ?>
			</ul>
		</div><!-- /.qp-popup__form-body -->
		
		<div class="qp-popup__form-foot">
			<button 
			data-hover-color="<?php echo ! empty( $form_button_color ) ? $form_button_color : '#4e83cb'; ?>"
			style="
			background-color: <?php echo ! empty( $form_button_color ) ? $form_button_color . ';' : '#4e83cb;'; ?>
			border-color: <?php echo ! empty( $form_button_color ) ? $form_button_color . ';' : '#4e83cb;'; ?>
			"
			type="submit"
			class="qp-js-btn-hover">
				<?php echo ! empty( $form_button_text ) ? $form_button_text : _e( 'Submit', 'mb-qp' ); ?>
			</button>
		</div><!-- /.qp-popup__form-foot -->

		<?php if ( ! empty( $include_button ) && ! empty( $action_button_url ) ) : ?>
			<div class="qp-popup__actions" style="text-align: <?php echo $action_button_alignment; ?>;">
				<a
				data-hover-color="<?php echo ! empty( $action_button_color ) ? $action_button_color : '#f55388'; ?>"
				style="
				background-color: <?php echo ! empty( $action_button_color ) ? $action_button_color . ';' : '#f55388;'; ?>
				border-color: <?php echo ! empty( $action_button_color ) ? $action_button_color . ';' : '#f55388;'; ?>"
				<?php echo ! empty( $action_button_new_tab ) ? ' target="_BLANK" ' : ''; ?> 
				href="<?php echo esc_url( $action_button_url ); ?>"
				class="qp-popup__btn qp-js-btn-hover">
					<?php echo esc_html( $action_button_text ); ?>
				</a>
			</div><!-- /.qp-popup__actions -->
		<?php endif; ?>
	</form>
</div><!-- /.qp-popup__form -->