<?php

$status = carbon_get_post_meta( $post_id, 'qp_status' );

if ( $status === 'qp_disabled' && empty( $admin_preview ) ) {
	return;
}

include( QP_PLUGIN_DIR . 'fragments/settings/padding.php' );
include( QP_PLUGIN_DIR . 'fragments/settings/x-btn-offset.php' );
include( QP_PLUGIN_DIR . 'fragments/settings/custom-css.php' );
include( QP_PLUGIN_DIR . 'fragments/settings/event.php' );
include( QP_PLUGIN_DIR . 'fragments/settings/animation.php' );

$width_type = carbon_get_post_meta( $post_id, 'qp_popup_width_type' );
$width      = carbon_get_post_meta( $post_id, 'qp_popup_width' );

$width_style = $width_type === 'custom' && ( ! empty( $width ) || $width === '0' ) ? sprintf( 'max-width: %s;', esc_html( $width ) ) : '';

$container_radius = carbon_get_post_meta( $post_id, 'qp_popup_container_radius' );

$container_radius_style = ! empty( $container_radius ) || $container_radius === '0' ? sprintf( 'border-radius: %s;', esc_html( $container_radius ) ) : '';

$title = carbon_get_post_meta( $post_id, 'qp_title' );
$body  = carbon_get_post_meta( $post_id, 'qp_body' );

$delay = carbon_get_post_meta( $post_id, 'qp_settings_delay' );

$form_message = carbon_get_post_meta( $post_id, 'qp_field_form_message' );

$btn_radius = carbon_get_post_meta( $post_id, 'qp_btn_radius' );
$btn_radius_style = ! empty( $btn_radius ) || $btn_radius === '0' ? sprintf( 'border-radius: %s;', esc_html( $btn_radius ) ) : '';

$action_button_text      = carbon_get_post_meta( $post_id, 'qp_button_text' );
$action_button_url       = carbon_get_post_meta( $post_id, 'qp_button_link' );
$action_button_new_tab   = carbon_get_post_meta( $post_id, 'qp_button_new_tab' );
$action_button_color     = carbon_get_post_meta( $post_id, 'qp_standard_button_color' );
$action_button_alignment = carbon_get_post_meta( $post_id, 'qp_standard_button_alignment' );

$include_button = carbon_get_post_meta( $post_id, 'qp_include_button' );
$include_form = carbon_get_post_meta( $post_id, 'qp_include_form' );
$embed_form = carbon_get_post_meta( $post_id, 'qp_embed_forms' );

include( QP_PLUGIN_DIR . 'fragments/settings/background-color.php' );
include( QP_PLUGIN_DIR . 'fragments/settings/overlay-color.php' );
include( QP_PLUGIN_DIR . 'fragments/settings/exit-button-style-type.php' );

$border_width = carbon_get_post_meta( $post_id, 'qp_popup_border_width' );
$border_width = str_replace( 'px', '', $border_width );
$border_width = ! empty( $border_width ) && is_numeric( $border_width ) ? $border_width : '0';

$border_color = carbon_get_post_meta( $post_id, 'qp_popup_border_color' );
$border_color = ! empty( $border_color ) ? $border_color : 'transparent';

$border_style = sprintf( 'border: %spx solid %s;', $border_width, $border_color );

$include_close_message = carbon_get_post_meta( $post_id, 'qp_popup_close_link_include' );
$close_message         = carbon_get_post_meta( $post_id, 'qp_popup_close_link_message' );
$close_message_align   = carbon_get_post_meta( $post_id, 'qp_popup_close_link_message_alignment' );

$event_type     = carbon_get_post_meta( $post_id, 'qp_event_type' );
$snooze_popup   = carbon_get_post_meta( $post_id, 'qp_snooze_popup' );
$number_of_days = carbon_get_post_meta( $post_id, 'qp_number_of_days_snooze' );

$cookie_data = 'data-snooze="false" data-snooze-days="0"';

if ( $event_type !== 'on_click' && ! empty( $snooze_popup ) && ! empty( $number_of_days ) && is_numeric( $number_of_days ) ) {
	$cookie_data = sprintf( 'data-snooze="true" data-snooze-days="%s"', $number_of_days );
}

$text_color   = carbon_get_post_meta( $post_id, 'qp_text_color' );
$fields_color = carbon_get_post_meta( $post_id, 'qp_fields_color' );

$position     = carbon_get_post_meta( $post_id, 'qp_position' );

$hero_image   = carbon_get_post_meta( $post_id, 'qp_hero_image' );

?>

<?php if ( ! empty( $btn_radius ) || $btn_radius === '0' ) : ?>
	<style type="text/css" media="screen">
		#qp-popup-<?php echo $post_id; ?> .qp-popup__form-foot button,
		#qp-popup-<?php echo $post_id; ?> .qp-popup__btn {
			<?php echo $btn_radius_style; ?>
		}
	</style>
<?php endif; ?>

<div <?php echo $cookie_data; ?> data-id="<?php echo $post_id; ?>" id="qp-popup-<?php echo $post_id; ?>"
	class="qp-popup qp-js-popup <?php echo $popup_modifier_class; ?> <?php echo $event_class . ' ' . $animation_class; ?>
	<?php echo 'qp-popup--text-color-' . esc_html( $text_color ); ?>
	<?php echo 'qp-popup--fields-color-' . esc_html( $fields_color ); ?>
	<?php echo 'qp-popup--position-' . esc_html( $position ); ?>
	<?php echo ! empty( $hero_image ) ? 'qp-popup--hero-image' : ''; ?>"
	data-delay="<?php echo ! empty( $delay ) && is_numeric( $delay ) ? esc_attr( $delay ) : '0'; ?>">
	<div class="qp-popup__inner"
	style="<?php echo $overlay_style; ?>">
		<div class="qp-popup__body" style="<?php echo $width_style; ?>">
			<a href="#" class="qp-popup__btn-close qp-js-hide-popup" style="<?php echo $offset_style; ?>">
				<span></span>

				<span></span>
			</a>

			<div class="qp-popup__container" style="<?php echo $bg_style . $border_style . $container_radius_style; ?>">
				<div class="qp-popup__body-inner">
					<?php if ( ! empty( $hero_image ) ) : ?>
						<div class="qp-popup__image js-image-fit image-fit">
							<?php echo wp_get_attachment_image( $hero_image, 'large' );  ?>
						</div><!-- /.qp-popup__image -->
					<?php endif; ?>

					<div class="qp-popup__content" style="<?php echo $padding_style; ?>">
						<?php if ( ! empty( $title ) ) : ?>
							<div class="qp-popup__title"><?php echo crb_content( $title ); ?></div>
						<?php endif; ?>

						<?php if ( ! empty( $body ) ) : ?>
							<div class="qp-popup__entry">
								<?php echo crb_content( $body ); ?>
							</div><!-- /.qp-popup__entry -->
						<?php endif; ?>

						<?php include( QP_PLUGIN_DIR . 'fragments/quickpop/form.php' ); ?>

						<?php if ( ! empty( $include_button ) && ( empty( $include_form ) || ! empty( $embed_form ) ) ) : ?>
							<div class="qp-popup__actions" style="text-align: <?php echo $action_button_alignment; ?>;">
								<a
								data-hover-color="<?php echo ! empty( $action_button_color ) ? $action_button_color : '#f55388'; ?>"
								style="
								background-color: <?php echo ! empty( $action_button_color ) ? $action_button_color . ';' : '#f55388;'; ?>
								border-color: <?php echo ! empty( $action_button_color ) ? $action_button_color . ';' : '#f55388;'; ?>;
								<?php echo $btn_radius_style; ?>"
								<?php echo ! empty( $action_button_new_tab ) ? ' target="_BLANK" ' : ''; ?> 
								href="<?php echo ! empty( $action_button_url ) ? esc_html( $action_button_url ) : '$'; ?>"
								class="qp-popup__btn qp-js-btn-hover">
								<?php echo esc_html( $action_button_text ); ?>
								</a>
							</div><!-- /.qp-popup__actions -->
						<?php endif; ?>

						<?php if ( ! empty( $include_close_message ) && ! empty( $close_message ) ) : ?>
							<div class="qp-popup__actions-close <?php echo sprintf( 'qp-popup__actions-close--%s', $close_message_align ); ?>">
								<a href="#" class="qp-js-hide-popup">
									<?php echo esc_html( $close_message ); ?>
								</a>
							</div><!-- /.qp-popup__actions-close -->
						<?php endif; ?>
					</div><!-- /.qp-popup__content -->
				</div><!-- /.qp-popup__body-inner -->
			</div><!-- /.qp-popup__container -->
		</div><!-- /.qp-popup__body -->

		<?php if ( ! empty( $form_message ) ) : ?>
			<div class="qp-popup__body qp-popup__body--success">
				<a href="#" class="qp-popup__btn-close qp-js-hide-popup">
					<span></span>

					<span></span>
				</a>

				<div class="qp-popup__container" style="<?php echo $bg_style . $border_style . $container_radius_style . $padding_style; ?>">
					<h2 class="qp-popup__title"><?php echo esc_html( $form_message ) ?></h2>

					<a href="#" class="qp-popup__btn qp-js-hide-popup"><?php echo __( 'Close Window', 'crb' ); ?></a>
				</div><!-- /.qp-popup__container -->
			</div><!-- /.qp-popup__body qp-popup__body-/-success -->
		<?php endif; ?>
	</div><!-- /.qp-popup__inner -->
</div><!-- /.qp-popup -->