const QubelyTimer=function(e){this.elem=e,this.elem&&this.init()};QubelyTimer.prototype.init=function(){this.defaultDate=new Date,this.defaultDate.setDate(this.defaultDate.getDate()+(12-this.defaultDate.getDay())),this.date=this.elem.getAttribute("data-date")||this.defaultDate,this.items={day:this.elem.querySelector(".qubely-countdown-item-day"),hour:this.elem.querySelector(".qubely-countdown-item-hour"),minute:this.elem.querySelector(".qubely-countdown-item-minute"),second:this.elem.querySelector(".qubely-countdown-item-second")},this.children={day:this.elem.querySelector(".day"),hour:this.elem.querySelector(".hour"),minute:this.elem.querySelector(".minute"),second:this.elem.querySelector(".second")},this.dayPercent=100,this.hourPercent=100,this.minutePercent=100,this.secondPercent=100,this.getDistanceDate(),this.runInterval()},QubelyTimer.prototype.runInterval=function(){this.interval=setInterval(()=>{this.getDistanceDate(),this.displayTime(),this.updatePiePercent()},1e3)},QubelyTimer.prototype.clearInterval=function(){this.getDistanceDate(),this.displayTime(),clearInterval(this.interval)},QubelyTimer.prototype.destroy=function(){clearInterval(this.interval),this.elem=null},QubelyTimer.prototype.reboot=function(){clearInterval(this.interval),this.init()},QubelyTimer.prototype.getDistanceDate=function(){const e=new Date(Date.now()),t=new Date(this.date),i=new Date(t-e),n=parseInt(i/1e3/60/60/24),r=parseInt(i/1e3/60/60%24),s=parseInt(i/1e3/60%60),a=parseInt(i/1e3%60);if(i.getTime()<=0)return this.distanceDate={day:0,hour:0,minute:0,second:0},this.displayTime(),void this.destroy();this.distanceDate={day:n,hour:r,minute:s,second:a}},QubelyTimer.prototype.formatNumber=function(e){return e<10?"0"+e.toString():e},QubelyTimer.prototype.displayTime=function(){this.children.day&&(this.children.day.innerHTML=this.formatNumber(this.distanceDate.day)),this.children.hour&&(this.children.hour.innerHTML=this.formatNumber(this.distanceDate.hour)),this.children.minute&&(this.children.minute.innerHTML=this.formatNumber(this.distanceDate.minute)),this.children.second&&(this.children.second.innerHTML=this.formatNumber(this.distanceDate.second))},QubelyTimer.prototype.updatePiePercent=function(){const{day:e,hour:t,minute:i,second:n}=this.items;if(e){const t=e.getAttribute("date-startdate");this.dayPercent=100-this._getDayPercent(t),this.updatePie("day",e)}t&&(this.hourPercent=parseInt(100*this.distanceDate.hour/24),this.updatePie("hour",t)),i&&(this.minutePercent=parseInt(100*this.distanceDate.minute/60),this.updatePie("minute",i)),n&&(this.secondPercent=parseInt(100*this.distanceDate.second/60),this.updatePie("second",n))},QubelyTimer.prototype.updatePie=function(e,t){if(void 0===t||void 0===e)return;let i=100;"second"===e?i=this.secondPercent:"minute"===e?i=this.minutePercent:"hour"===e?i=this.hourPercent:"day"===e&&(i=this.dayPercent);const n=parseFloat(t.getAttribute("data-circumference")),r=n-n*i/100;t.querySelector(".qubely-countdown-cirlce-forground").style.strokeDashoffset=r},QubelyTimer.prototype._getDayPercent=function(e){let t=this.date,i=new Date;t=Date.parse(t),e=Date.parse(e),i=i.getTime();const n=parseInt((t>e?t-e:0)/1e3/60/60/24),r=parseInt((i>e?i-e:0)/1e3/60/60/24);return parseInt(100*r/n)},document.addEventListener("DOMContentLoaded",function(){const e=document.querySelectorAll(".qubely-countdown");e.length&&e.forEach(e=>{new QubelyTimer(e)})});