import{h,Host}from"@stencil/core";import{exitFullScreen}from"../../../util";import cacheCues from"./functions/cache-cues";import createPlayer from"./functions/create";import customCSS from"./functions/custom-css";import hlsPreloadSize from"./functions/hls-preload-size";import mutedAutoplay from"./functions/muted-autoplay";import transform from"./functions/transform-data";import{getParents,isHLS,parseJSON}from"./functions/util";export class PrestoPlayer{constructor(){this.isAdmin=!1,this._preset={},this._branding={},this._chapters=[],this._overlays={},this._tracks=[],this._blockAttributes={},this._config={},this._youtube={},this._actionBar={},this._i18n={},this._search={},this.previouslyPlaying=!1,this.ctaActive=!1,this.emailActive=!1,this.actionBarActive=!1,this.components={cta:null,email:null,overlays:null,search:null}}get preset(){return this._preset}set preset(e){this._preset="string"==typeof e?parseJSON(e,{}):e}get branding(){return this._branding}set branding(e){this._branding="string"==typeof e?parseJSON(e,{}):e}get chapters(){return this._chapters}set chapters(e){this._chapters="string"==typeof e?parseJSON(e,[]):e}get overlays(){return this._overlays}set overlays(e){this._overlays="string"==typeof e?parseJSON(e,[]):e}get tracks(){return this._tracks}set tracks(e){this._tracks="string"==typeof e?parseJSON(e,[]):e}get blockAttributes(){return this._blockAttributes}set blockAttributes(e){this._blockAttributes="string"==typeof e?parseJSON(e,{}):e}get config(){return this._config}set config(e){this._config="string"==typeof e?parseJSON(e,{}):e}get youtube(){return this._youtube}set youtube(e){this._youtube="string"==typeof e?parseJSON(e,{}):e}get actionBar(){return this._actionBar}set actionBar(e){this._actionBar="string"==typeof e?parseJSON(e,{}):e}get i18n(){return this._i18n}set i18n(e){this._i18n="string"==typeof e?parseJSON(e,{}):e}get search(){return this._search}set search(e){this._search="string"==typeof e?parseJSON(e,{}):e}async play(e=!1){this.shouldLazyLoad=!1,e&&(this.mutedPreview=!1),this.player.play()}async goToAndPlay(e){this.player.play(),this.player.currentTime=e}handleScroll(e){e.detail.id!==this.player.id&&(this.mutedPreview||this.pause())}async restart(){return this.shouldLazyLoad=!1,this.player.restart()}async pause(){return this.player.pause()}async stop(){return this.player.stop()}async fullscreenToggle(e){return this.player.fullscreen.toggle(e)}async on(e,t){return this.player.on(e,t)}async once(e,t){return this.player.once(e,t)}async off(e,t){return this.player.off(e,t)}async handleCurrentTimeChange(e){this.player&&Number.isInteger(e)&&(this.player.duration&&(this.player.currentTime=Math.min(this.player.currentTime,this.player.duration)),this.shouldLazyLoad&&(this.shouldLazyLoad=!1,await new Promise(e=>{setTimeout(async()=>{await this.initialize(),e()},50)})),this.player.embed&&!this.player.playing?(this.player.currentTime=e,this.player.muted=!0,this.player.play(),this.player.once("timeupdate",()=>{this.player.pause(),this.player.currentTime=e,this.player.muted=!1})):this.player.currentTime=e)}handleStickyChange(){getParents(this.el).forEach(e=>{var t;null===(t=null==e?void 0:e.classList)||void 0===t||t.toggle("presto-sticky-parent",this.isSticky)})}getConfig(){return{...transform({preset:this.preset,chapters:this.chapters,branding:this.branding,analytics:!!this.analytics,automations:!!this.automations,autoplay:!this.isAdmin&&!!this.autoplay,blockAttributes:this.blockAttributes,provider:this.provider,youtube:this.youtube,provider_video_id:this.providerVideoId,i18n:this.i18n,search:this.search}),markers:{enabled:!0,points:[]},...this.iconUrl?{iconUrl:this.iconUrl}:{}}}getPlayerData(){return{selector:this.playerEl,src:this.src||"",preload:this.preload,provider:this.provider,config:this.getConfig(),isAdmin:this.isAdmin}}async createPlayer(){return await createPlayer(this.getPlayerData())}handlePlayerElementChange(){var e;hlsPreloadSize({src:this.src,el:this.playerEl,preload:this.preload,currentTime:null===(e=null==this?void 0:this.player)||void 0===e?void 0:e.currentTime})}handleMutedPreview(e,t){var i,r,s,a;this.player&&!this.isAdmin&&(!e&&t&&this.player.once("timeupdate",()=>{var e,t;this.player.loop="loop"===(null===(e=this.preset)||void 0===e?void 0:e.on_video_end),this.player.toggleCaptions(null===(t=null==this?void 0:this.preset)||void 0===t?void 0:t.captions_enabled)}),(null===(r=null===(i=this.getConfig().blockAttributes)||void 0===i?void 0:i.mutedPreview)||void 0===r?void 0:r.enabled)&&mutedAutoplay({player:this.player,mutedPreview:this.mutedPreview,captions:!!(null===(a=null===(s=this.blockAttributes)||void 0===s?void 0:s.mutedPreview)||void 0===a?void 0:a.captions),progress:this.getConfig().ajaxProgress,savePosition:this.getConfig().save_player_position,onPlay:()=>this.play()}))}onPlayerReady(){var e,t,i;this.intersectionObserver&&(this.intersectionObserver.disconnect(),this.intersectionObserver.observe(this.el)),this.duration=this.player.duration;var r=window.navigator.userAgent;!!r.match(/iPad/i)||!!r.match(/iPhone/i)||(this.mutedPreview=null===(t=null===(e=this.blockAttributes)||void 0===e?void 0:e.mutedPreview)||void 0===t?void 0:t.enabled),this.renderDynamicOverlays(),this.renderVideoCTA(),this.renderEmailOverlay(),this.renderSearchBar(),this.player.on("timeupdate loadedmetadata",()=>{this.duration=this.player.duration,this.renderDynamicOverlays()}),isHLS(this.src)&&this.player.once("playing",()=>{this.playerEl.style.height=null,this.playerEl.style.paddingBottom=null,this.playerEl.setAttribute("hls_loaded","1")}),this.player.on("playing",()=>this.playClass="presto-player--playing"),this.player.on("pause",()=>this.playClass="presto-player--paused"),this.player.on("ended",()=>this.playClass="presto-player--ended"),this.player.on("playing",e=>!this.mutedPreview&&this.currentMediaPlayer.emit(e.detail.plyr)),this.player.on("playing",e=>this.playedMedia.emit(e.detail.plyr)),this.player.on("pause",e=>this.pausedMedia.emit(e.detail.plyr)),this.player.on("ended",e=>this.endedMedia.emit(e.detail.plyr)),"go-to-start"===(null===(i=this.preset)||void 0===i?void 0:i.on_video_end)&&this.player.on("ended",()=>{this.restart(),"youtube"===this.provider&&this.stop()}),cacheCues(this.player),setTimeout(()=>{this.playerReady.emit(this.player),this.ready=!0},100)}handlePlayerEvents(e){e.on("ready",e=>{this.player=e.detail.plyr,this.onPlayerReady()})}handleLazyLoadChange(){"youtube"!==this.provider||this.shouldLazyLoad||this.isAdmin||setTimeout(()=>{this.onReload("play")},50)}shouldLazyLoadVideo(){return"youtube"===this.provider&&!this.autoplay&&!!this.lazyLoadYoutube}componentWillLoad(){var e,t,i;const r=null===(e=this.el.children)||void 0===e?void 0:e[0];r&&r.classList&&r.classList.contains("presto-iframe-fallback-container")&&r.remove(),this.i18n=(null===(t=null===window||void 0===window?void 0:window.prestoPlayer)||void 0===t?void 0:t.i18n)||(null===(i=null===window||void 0===window?void 0:window.prestoPlayerAdmin)||void 0===i?void 0:i.i18n),this.trackIntersection()}async componentDidLoad(){setTimeout(()=>{this.initialize(),this.loaded.emit(!0)},0)}async initialize(){const e=await this.createPlayer();return this.handlePlayerEvents(e),this.syncVideoHeight(),customCSS(this.el,this.css),e}renderSkins(){var e,t,i;return"modern"===(null===(e=this.preset)||void 0===e?void 0:e.skin)?h("presto-modern-skin",null):"business"===(null===(t=this.preset)||void 0===t?void 0:t.skin)?h("presto-business-skin",null):"stacked"===(null===(i=this.preset)||void 0===i?void 0:i.skin)?h("presto-stacked-skin",null):void 0}async onReload(e){if(!Object.keys(this.preset).length)return;const t=await this.initialize();"play"==e&&t.on("ready",()=>{this.play(),t.muted=!0,t.muted=!1,t.off("ready",this.play)})}async syncVideoHeight(){this.resizeObserver=new ResizeObserver(()=>{this.isSticky||(this.videoHeight=this.el.getBoundingClientRect().height)}),this.resizeObserver.observe(this.el)}handleRestartVideo(){this.player.once("timeupdate",()=>{setTimeout(()=>this.play(),500)}),this.player.restart()}handlePlayVideo(){this.play()}handlePauseVideo(e){this.pause(),e.detail&&exitFullScreen(this.player)}playVideoOnlyInViewport(){var e;!this.isAdmin&&(null===(e=this.preset)||void 0===e?void 0:e.play_video_viewport)&&this.player&&("visible"===document.visibilityState?this.intersectionObserver.observe(this.el):(this.player.playing&&(this.previouslyPlaying=!0),this.pause(),this.intersectionObserver.disconnect()))}trackIntersection(){this.intersectionObserver=new IntersectionObserver(e=>{this.handleVisibilityIntersection(null==e?void 0:e[0])}),this.intersectionObserver.observe(this.el)}handleVisibilityIntersection(e){e&&(this.handleStickyScroll(e),this.handleVisibilityPlayChange(e))}handleStickyScroll(e){var t,i;if(!(null===(t=this.preset)||void 0===t?void 0:t.sticky_scroll))return;if(this.isAdmin||this.mutedPreview||!(null===(i=null==this?void 0:this.player)||void 0===i?void 0:i.playing))return void(this.isSticky=!1);let r=e.boundingClientRect;if(this.isSticky=r.height<-r.top,"visible"===document.visibilityState&&this.isSticky&&this.player){const e=()=>{window.removeEventListener("scroll",e),this.player.paused&&(this.isSticky=!1)};this.player.once("pause",()=>{window.addEventListener("scroll",e)})}}handleVisibilityPlayChange(e){var t,i,r;if(!this.isAdmin&&(null===(t=this.preset)||void 0===t?void 0:t.play_video_viewport)&&(!this.player&&this.getConfig().autoplay&&(this.previouslyPlaying=!0,this.autoplay=!!(null==e?void 0:e.isIntersecting)),this.player)){if(null==e?void 0:e.isIntersecting)return this.getConfig().autoplay&&(this.autoplay=!0),this.previouslyPlaying&&this.play(),void(this.previouslyPlaying=!1);if("visible"!==document.visibilityState||!this.isSticky){if(null===(r=null===(i=this.blockAttributes)||void 0===i?void 0:i.mutedPreview)||void 0===r?void 0:r.enabled)return this.previouslyPlaying=!0,this.pause(),void this.player.once("playing",()=>{this.previouslyPlaying=!0,this.pause()});this.player.playing&&(this.previouslyPlaying=!0),this.pause()}}}renderMutedOverlay(){var e;if(this.player&&this.mutedPreview&&!this.isAdmin)return h("presto-muted-overlay",{mutedOverlay:null===(e=this.getConfig().blockAttributes)||void 0===e?void 0:e.mutedOverlay,preset:this.preset,onPlayVideo:()=>{this.mutedPreview=!1,this.play()}})}renderVideo(){switch(this.provider){case"vimeo":return h("presto-vimeo",{player:this.player,getRef:e=>this.playerEl=e,poster:this.poster,src:this.src});case"youtube":return h("presto-youtube",{onReload:e=>this.onReload(null==e?void 0:e.detail),player:this.player,getRef:e=>this.playerEl=e,lazyLoad:this.shouldLazyLoadVideo(),poster:this.poster,src:this.src});case"bunny":return h("presto-bunny",{getRef:e=>this.playerEl=e,player:this.player,autoplay:this.autoplay,preload:this.preload,poster:this.poster,playsinline:this.playsinline,src:this.src,tracks:this.tracks});case"audio":return h("presto-audio",{getRef:e=>this.playerEl=e,player:this.player,autoplay:this.autoplay,preload:this.preload,poster:this.poster,preset:this.preset,src:this.src,tracks:this.tracks,mediaTitle:this.mediaTitle,audioAttributes:this.audioAttributes});default:return h("presto-video",{getRef:e=>this.playerEl=e,player:this.player,autoplay:this.autoplay,preload:this.preload,poster:this.poster,playsinline:this.playsinline,src:this.src,tracks:this.tracks})}}renderVideoCTA(){var e,t,i,r;(null===(e=null===window||void 0===window?void 0:window.prestoPlayer)||void 0===e?void 0:e.isPremium)&&(this.isAdmin||(null===(i=null===(t=this.preset)||void 0===t?void 0:t.cta)||void 0===i?void 0:i.enabled)&&((null===(r=this.components.cta)||void 0===r?void 0:r.offsetParent)||"audio"!==this.provider&&(this.components.cta=document.createElement("presto-cta-overlay"),this.components.cta.direction=this.direction,this.components.cta.player=this.player,this.components.cta.preset=this.preset,this.components.cta.i18n=this.i18n,this.player.elements.container.append(this.components.cta))))}renderAudioCTA(){var e,t;if("audio"===this.provider&&this.player&&(null===(t=null===(e=this.preset)||void 0===e?void 0:e.cta)||void 0===t?void 0:t.enabled))return h("presto-cta-overlay",{direction:this.direction,player:this.player,preset:this.preset,i18n:this.i18n,provider:this.provider})}renderEmailOverlay(){var e,t,i;!(null===(e=null===window||void 0===window?void 0:window.prestoPlayer)||void 0===e?void 0:e.isPremium)||this.isAdmin||(null===(t=null===window||void 0===window?void 0:window.prestoPlayer)||void 0===t?void 0:t.logged_in)||(null===(i=this.components.email)||void 0===i?void 0:i.offsetParent)||"audio"!==this.provider&&(this.components.email=document.createElement("presto-email-overlay"),this.components.email.direction=this.direction,this.components.email.player=this.player,this.components.email.preset=this.preset,this.components.email.i18n=this.i18n,this.components.email.videoId=this.videoId,this.components.email.provider=this.provider,this.player.elements.container.append(this.components.email))}renderAudioEmail(){var e,t;if("audio"===this.provider&&this.player&&(null===(e=null===window||void 0===window?void 0:window.prestoPlayer)||void 0===e?void 0:e.isPremium)&&!this.isAdmin&&!(null===(t=null===window||void 0===window?void 0:window.prestoPlayer)||void 0===t?void 0:t.logged_in))return h("presto-email-overlay",{direction:this.direction,player:this.player,preset:this.preset,i18n:this.i18n,provider:this.provider})}renderActionBar(){var e,t;if((null===(t=null===(e=this.preset)||void 0===e?void 0:e.action_bar)||void 0===t?void 0:t.enabled)&&this.player)return h("presto-action-bar",{config:this.preset.action_bar,player:null==this?void 0:this.player,youtube:this.youtube})}renderSearchBar(){var e,t;(null===(t=null===(e=this.preset)||void 0===e?void 0:e.search)||void 0===t?void 0:t.enabled)&&(this.components.search=document.createElement("presto-search-bar"),this.components.search.player=this.player,this.player.elements.container.append(this.components.search))}stickyPositionClass(){var e,t;return this.isSticky?(null===(e=this.preset)||void 0===e?void 0:e.sticky_scroll_position)?`presto-sticky--${null===(t=this.preset)||void 0===t?void 0:t.sticky_scroll_position.replace(/\s+/g,"-")}`:"presto-sticky--bottom-right":""}renderDynamicOverlays(){var e,t,i,r,s,a,o;this.player&&((null===(e=null==this?void 0:this.overlaysComponent)||void 0===e?void 0:e.offsetParent)||(this.overlaysComponent=document.createElement("presto-dynamic-overlays"),this.overlaysComponent.addEventListener("reloadComponent",()=>{this.overlaysComponent.remove(),this.overlaysComponent=document.createElement("presto-dynamic-overlays")},{once:!0})),this.overlaysComponent.style.cssText="display: block !important; opacity: 1 !important; visibility: visible !important;",this.overlaysComponent.overlays=this.overlays,this.overlaysComponent.preset=this.preset,this.overlaysComponent.player=this.player,this.overlaysComponent.enabled=!(null===(r=null===(i=null===(t=this.player)||void 0===t?void 0:t.config)||void 0===i?void 0:i.mutedPreview)||void 0===r?void 0:r.enabled),(null===(s=null==this?void 0:this.overlaysComponent)||void 0===s?void 0:s.offsetParent)||null===(o=null===(a=this.player.elements)||void 0===a?void 0:a.wrapper)||void 0===o||o.append(this.overlaysComponent))}handleCtaStateChange(e){this.ctaActive=e.detail}handleEmailStateChange(e){this.emailActive=e.detail}handleActionBarStateChange(e){this.actionBarActive=e.detail}disconnectedCallback(){var e,t;null===(e=this.intersectionObserver)||void 0===e||e.disconnect(),null===(t=this.resizeObserver)||void 0===t||t.disconnect()}render(){var e,t,i,r,s,a,o,n;return h(Host,{key:"7aaec6a01a28006cc8d75b6e1c57e184957b809f",style:{height:this.isSticky?`${this.videoHeight}px`:"auto"},class:{ready:this.ready}},h("div",{key:"a6b964e48239c210571cea4c9b22a8ec3c36f3c6",part:"wrapper",dir:this.direction,class:`presto-player__wrapper fitvidsignore\n          presto-video-id-${this.videoId}\n        ${this.isSticky?"audio"===this.provider?"presto-sticky-audio":"presto-sticky":""}\n        ${"audio"!==this.provider?this.stickyPositionClass():""}\n        ${"rtl"===this.direction?"rtl":""}\n        ${!0===this.ctaActive?"cta-active":""}\n        ${!0===this.emailActive?"email-active":""}\n        ${!0===this.actionBarActive&&(null===(t=null===(e=this.preset)||void 0===e?void 0:e.action_bar)||void 0===t?void 0:t.enabled)?"action-bar-active":""}\n        ${!!(null===(i=this.preset)||void 0===i?void 0:i.skin)&&`skin-${null===(r=this.preset)||void 0===r?void 0:r.skin}`}\n        ${(null===(s=this.preset)||void 0===s?void 0:s.hide_youtube)?"hide-youtube-ui":""}\n        ${(null===(a=this.preset)||void 0===a?void 0:a.caption_style)?`caption-style-${null===(o=this.preset)||void 0===o?void 0:o.caption_style}`:""}\n        ${this.mutedPreview?"is-muted-overlay":""}\n        ${this.playClass?this.playClass:""}\n        ${(null===(n=this.preset)||void 0===n?void 0:n.play)&&!this.preset.rewind?"rewind-inactive":""}\n        ${this.classes||""}`},h("div",{key:"b823644c5cc62fd2200660054be476705504e8c6"},h("slot",{key:"0c8ce73e69d3c16afe65ec239dafdee1ba31b148",name:"player-start"}),h("slot",{key:"13f4326aa7ea86206e8db26e171676a5b0bee3f6",name:"player-before-video"}),this.renderVideo(),h("slot",{key:"eefe90f19f7e190217f24851622ab688c2c12001",name:"player-after-video"}),this.renderActionBar(),this.renderMutedOverlay(),this.renderAudioCTA(),this.renderAudioEmail(),this.renderSkins(),h("slot",{key:"de820c683366f98f6e256b49987652f3da81c151",name:"player-end"}))))}static get is(){return"presto-player"}static get encapsulation(){return"shadow"}static get originalStyleUrls(){return{$:["presto-player.scss"]}}static get styleUrls(){return{$:["presto-player.css"]}}static get properties(){return{iconUrl:{type:"string",attribute:"icon-url",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},src:{type:"string",attribute:"src",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},type:{type:"string",attribute:"type",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},autoplay:{type:"boolean",attribute:"autoplay",mutable:!0,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!0},preload:{type:"string",attribute:"preload",mutable:!1,complexType:{original:"'metadata' | 'none' | 'auto'",resolved:'"auto" | "metadata" | "none"',references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},poster:{type:"string",attribute:"poster",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},playsinline:{type:"boolean",attribute:"playsinline",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},isAdmin:{type:"boolean",attribute:"is-admin",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1,defaultValue:"false"},direction:{type:"string",attribute:"direction",mutable:!1,complexType:{original:"'rtl'",resolved:'"rtl"',references:{}},required:!1,optional:!0,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},css:{type:"string",attribute:"css",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!0,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},currentTime:{type:"number",attribute:"current-time",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},mediaTitle:{type:"string",attribute:"media-title",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},classes:{type:"string",attribute:"classes",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},audioAttributes:{type:"unknown",attribute:"audio-attributes",mutable:!1,complexType:{original:"object",resolved:"object",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1},markers:{type:"any",attribute:"markers",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},automations:{type:"boolean",attribute:"automations",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},providerVideoId:{type:"string",attribute:"provider-video-id",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},videoId:{type:"number",attribute:"video-id",mutable:!1,complexType:{original:"number",resolved:"number",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},analytics:{type:"boolean",attribute:"analytics",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},provider:{type:"string",attribute:"provider",mutable:!1,complexType:{original:"string",resolved:"string",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},lazyLoadYoutube:{type:"boolean",attribute:"lazy-load-youtube",mutable:!1,complexType:{original:"boolean",resolved:"boolean",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!1,setter:!1,reflect:!1},preset:{type:"any",attribute:"preset",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},branding:{type:"any",attribute:"branding",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},chapters:{type:"any",attribute:"chapters",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"[]"},overlays:{type:"any",attribute:"overlays",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},tracks:{type:"any",attribute:"tracks",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"[]"},blockAttributes:{type:"any",attribute:"block-attributes",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},config:{type:"any",attribute:"config",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},youtube:{type:"any",attribute:"youtube",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},actionBar:{type:"any",attribute:"action-bar",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},i18n:{type:"any",attribute:"i-1-8n",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"},search:{type:"any",attribute:"search",mutable:!1,complexType:{original:"any",resolved:"any",references:{}},required:!1,optional:!1,docs:{tags:[],text:""},getter:!0,setter:!0,defaultValue:"{}"}}}static get states(){return{player:{},playerEl:{},shouldLazyLoad:{},mutedPreview:{},duration:{},isSticky:{},videoHeight:{},playClass:{},previouslyPlaying:{},ctaActive:{},emailActive:{},actionBarActive:{},ready:{}}}static get events(){return[{method:"loaded",name:"loaded",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:"Component loaded"},complexType:{original:"boolean",resolved:"boolean",references:{}}},{method:"currentMediaPlayer",name:"currentMediaPlayer",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:""},complexType:{original:"object",resolved:"object",references:{}}},{method:"playerReady",name:"playerReady",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:""},complexType:{original:"object",resolved:"object",references:{}}},{method:"playedMedia",name:"playedMedia",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:""},complexType:{original:"object",resolved:"object",references:{}}},{method:"pausedMedia",name:"pausedMedia",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:""},complexType:{original:"object",resolved:"object",references:{}}},{method:"endedMedia",name:"endedMedia",bubbles:!0,cancelable:!0,composed:!0,docs:{tags:[],text:""},complexType:{original:"object",resolved:"object",references:{}}}]}static get methods(){return{play:{complexType:{signature:"(unmute?: boolean) => Promise<void>",parameters:[{name:"unmute",type:"boolean",docs:""}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Play video",tags:[{name:"returns",text:"Plyr"}]}},goToAndPlay:{complexType:{signature:"(time: number) => Promise<void>",parameters:[{name:"time",type:"number",docs:"number"}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<void>"},docs:{text:"Go to and play",tags:[{name:"param",text:"time number"}]}},restart:{complexType:{signature:"() => Promise<any>",parameters:[],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<any>"},docs:{text:"Play video",tags:[{name:"returns",text:"Plyr"}]}},pause:{complexType:{signature:"() => Promise<any>",parameters:[],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<any>"},docs:{text:"Pause video",tags:[{name:"returns",text:"Plyr"}]}},stop:{complexType:{signature:"() => Promise<any>",parameters:[],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<any>"},docs:{text:"Pause video",tags:[{name:"returns",text:"Plyr"}]}},fullscreenToggle:{complexType:{signature:"(open: boolean) => Promise<any>",parameters:[{name:"open",type:"boolean",docs:""}],references:{Promise:{location:"global",id:"global::Promise"}},return:"Promise<any>"},docs:{text:"Toggle Fullscreen",tags:[{name:"returns",text:"Plyr"}]}},on:{complexType:{signature:"(event: string, func: Function) => Promise<any>",parameters:[{name:"event",type:"string",docs:"String"},{name:"func",type:"Function",docs:"Function"}],references:{Promise:{location:"global",id:"global::Promise"},Function:{location:"global",id:"global::Function"}},return:"Promise<any>"},docs:{text:"Add an event listener for the specified event.",tags:[{name:"param",text:"event String"},{name:"param",text:"func Function"},{name:"returns",text:"Plyr"}]}},once:{complexType:{signature:"(event: string, func: Function) => Promise<any>",parameters:[{name:"event",type:"string",docs:"String"},{name:"func",type:"Function",docs:"Function"}],references:{Promise:{location:"global",id:"global::Promise"},Function:{location:"global",id:"global::Function"}},return:"Promise<any>"},docs:{text:"Add an event listener for the specified event.",tags:[{name:"param",text:"event String"},{name:"param",text:"func Function"},{name:"returns",text:"Plyr"}]}},off:{complexType:{signature:"(event: string, func: Function) => Promise<any>",parameters:[{name:"event",type:"string",docs:"String"},{name:"func",type:"Function",docs:"Function"}],references:{Promise:{location:"global",id:"global::Promise"},Function:{location:"global",id:"global::Function"}},return:"Promise<any>"},docs:{text:"Remove an event listener for the specified event.",tags:[{name:"param",text:"event String"},{name:"param",text:"func Function"},{name:"returns",text:"Plyr"}]}}}}static get elementRef(){return"el"}static get watchers(){return[{propName:"currentTime",methodName:"handleCurrentTimeChange"},{propName:"isSticky",methodName:"handleStickyChange"},{propName:"playerEl",methodName:"handlePlayerElementChange"},{propName:"player",methodName:"handlePlayerElementChange"},{propName:"mutedPreview",methodName:"handleMutedPreview"},{propName:"shouldLazyLoad",methodName:"handleLazyLoadChange"},{propName:"overlays",methodName:"renderDynamicOverlays"},{propName:"preset",methodName:"renderDynamicOverlays"}]}static get listeners(){return[{name:"currentMediaPlayer",method:"handleScroll",target:"window",capture:!1,passive:!1},{name:"restartVideo",method:"handleRestartVideo",target:void 0,capture:!1,passive:!1},{name:"playVideo",method:"handlePlayVideo",target:void 0,capture:!1,passive:!1},{name:"pauseVideo",method:"handlePauseVideo",target:void 0,capture:!1,passive:!1},{name:"visibilitychange",method:"playVideoOnlyInViewport",target:"window",capture:!1,passive:!1},{name:"ctaStateChange",method:"handleCtaStateChange",target:void 0,capture:!1,passive:!1},{name:"emailStateChange",method:"handleEmailStateChange",target:void 0,capture:!1,passive:!1},{name:"actionBarStateChange",method:"handleActionBarStateChange",target:void 0,capture:!1,passive:!1}]}}