import { __ } from "@wordpress/i18n";
import { getBlockType } from "@wordpress/blocks";
import { css } from "@emotion/core";

export default ({ thumbnail, type }) => {
  const getIcon = () => {
    const blockType = getBlockType(`presto-player/${type}`);
    return blockType?.icon?.src ? (
      blockType.icon.src
    ) : (
      <svg
        xmlns="http://www.w3.org/2000/svg"
        viewBox="0 0 24 24"
        fill="currentColor"
        className="w-6 h-6"
        css={css`
          color: var(--wp-admin-theme-color, #007cba);
        `}
      >
        <path
          fillRule="evenodd"
          d="M2.25 12c0-5.385 4.365-9.75 9.75-9.75s9.75 4.365 9.75 9.75-4.365 9.75-9.75 9.75S2.25 17.385 2.25 12Zm14.024-.983a1.125 1.125 0 0 1 0 1.966l-5.603 3.113A1.125 1.125 0 0 1 9 15.113V8.887c0-.857.921-1.4 1.671-.983l5.603 3.113Z"
          clipRule="evenodd"
        />
      </svg>
    );
  };

  if (thumbnail) {
    return (
      <img
        css={css`
          width: 24px;
          height: 24px;
          object-fit: cover;
          margin-right: 8px;
          border-radius: 3px;
        `}
        src={thumbnail}
        alt="Presto video thumbnail"
      />
    );
  }

  return (
    <div
      css={css`
        width: 24px;
        margin-right: 8px;
        line-height: 0;
      `}
    >
      {getIcon()}
    </div>
  );
};
