<?php
/**
 * Private Self Hosted Block.
 *
 * @package PrestoPlayer\Pro\Blocks
 */

namespace PrestoPlayer\Pro\Blocks;

use PrestoPlayer\Attachment;
use PrestoPlayer\Models\CurrentUser;
use PrestoPlayer\Blocks\SelfHostedBlock;

/**
 * Private Self Hosted Block.
 */
class PrivateSelfHostedBlock extends SelfHostedBlock {

	/**
	 * Block name
	 *
	 * @var string
	 */
	protected $name = 'self-hosted-private';

	/**
	 * Bail if user cannot access video.
	 *
	 * @param array  $attributes Block attributes.
	 * @param string $content Block content.
	 * @return bool
	 */
	public function middleware( $attributes, $content ) {
		if ( ! CurrentUser::canAccessVideo( ! empty( $attributes['id'] ) ? $attributes['id'] : 0 ) ) {
			return false;
		}
		return true;
	}

	/**
	 * Data to send to editor scripts.
	 *
	 * @return array
	 */
	public function editorScriptData() {
		return array(
			'src' => sprintf( site_url( 'video-src/%s/' ), wp_create_nonce( 'presto-player-user-token' ) ),
		);
	}

	/**
	 * Add src to video.
	 *
	 * @param array $attributes Block attributes.
	 * @param array $default_config Default config.
	 * @return array
	 */
	public function sanitizeAttributes( $attributes, $default_config ) {
		return array(
			'src' => ! empty( $attributes['id'] ) ? Attachment::getSrc( $attributes['id'], true ) : '',
		);
	}

	/**
	 * Override attributes.
	 *
	 * @param array $attributes Block attributes.
	 * @return array
	 */
	public function overrideAttributes( $attributes ) {
		$load = $this->middleware( $attributes, '' );

		if ( ! $load ) {
			return array();
		}

		return $attributes;
	}
}
