<?php

namespace EGPR;


use EGPR\Data_Structures\Post_Types\Press_Releases\Factory;
use EGPR\Queue\Ingest_Manager;
use EGPR\Queue\Setup_Post_Ingestion_Manager;

/**
 * Class Rest_Server
 */
class Server extends \WP_Rest_Controller {

    public $namespace = 'egpr/';
    public $version = 'v1';


    public function init() {
        add_action( 'rest_api_init', array( $this, 'register_routes' ) );
    }


    public function register_routes() {
        $namespace = $this->namespace . $this->version;


        register_rest_route(
            $namespace,
            '/press',
            array(
                array(
                    'methods'  => \WP_REST_Server::CREATABLE,
                    'callback' => array( $this, 'create_press' ),
                    'permission_callback' => array( $this, 'get_users_permission' ),
                    'args' => array(


                    ),
                ),
            )
        );

        register_rest_route(
            $namespace,
            '/press/(?P<type>[a-zA-Z0-9]+)/?(?P<page>[\d]+)',
            array(
                array(
                    'methods'  => \WP_REST_Server::READABLE,
                    'callback' => array( $this, 'read_press' ),
                    'permission_callback' => '__return_true',
                    'args' => array(


                    ),
                ),
            )
        );
    }

    public function read_press(\WP_REST_Request $request){

        $type = $request->get_param('type');
        $page = (int)$request->get_param('page') ?: 1;

        if(!$type){
            return $this->send_json_response(['message' => 'No type provided'], false);
        }
        if(!in_array($type, ['links', 'videos'])) {
            return $this->send_json_response(['message' => 'Invalid type provided'], false);
        }


        $posts = self::posts($type, $page);


        return $this->send_json_response(['payload' => $posts]);

    }




    public function send_json_response($results = [], $success = true){
        $response = new \WP_REST_Response(
            array(
                'data' => array(
                    'success'  => $success,
                    'response' => $results,
                ),
            )
        );
        if(!$success){
            $response->set_status(400);
        }
        return $response;
    }


    public function create_press(\WP_REST_Request $request){

	    $method = $request->get_param( 'method' );
	    $body   = $request->get_param( 'body' );
		if(Settings::get('ingestion_mode') === 'asynchronous') {
			$ingestion_manager = new Ingest_Manager($method, $body);
			$ingestion_manager->process();
		} else {
			$factory = new Factory($body, $method);
			$factory->execute();
		}



        return $this->send_json_response();

    }

    public function get_users_permission() {

        return is_user_logged_in() && current_user_can('edit_posts');
    }


}
