<?php

namespace EGPR\Queue;

use EGPR\Utils;

class Post_Creator_Manager {

    protected $process_all;
    private $queue = [];
    public function __construct($queue = null) {
        if(!!$queue){
            $this->queue = $queue;
        }



    }

    public function init(){
        $this->attach_hooks();
    }

    public function attach_hooks(){
        add_action( 'init', array( $this, 'setup' ) );
    }

    public function process(){
        $this->handle_all();

    }
    public function setup() {
        $this->process_all    = new Post_Creator_Process();
    }

    private function handle_all(){
        $this->setup();
        foreach((array)$this->queue as $queue_item){
            Utils::log('Pushing to queue....');
            $this->process_all->push_to_queue( $queue_item );
        }
        $this->process_all->save()->dispatch();
    }



}