<?php

namespace EGPR;

class Images_Utils {

    public static function url_to_base64($url) {

        $fileData = file_get_contents($url);
        if ($fileData === false) {
            return null;
        }
        $finfo = finfo_open(FILEINFO_MIME_TYPE);
        $mimeType = finfo_buffer($finfo, $fileData);
        finfo_close($finfo);
        $base64Data = base64_encode($fileData);
        $dataUri = 'data:' . $mimeType . ';base64,' . $base64Data;
        return $dataUri;
    }


    public static function upload_image( $base64_img, $title ) {
        // Upload dir.
        $upload_dir  = wp_upload_dir();
        $upload_path = str_replace( '/', DIRECTORY_SEPARATOR, $upload_dir['path'] ) . DIRECTORY_SEPARATOR;

        // Get the image format and file extension from the base64 image data.
        $image_parts = explode( ';', $base64_img );
        $image_mime = explode( '/', $image_parts[0] );
        if ( count( $image_mime ) !== 2 || ! in_array( $image_mime[1], array( 'jpeg', 'png', 'gif', 'webp', 'avif' ) ) ) {
            return false;
        }
        $mime = $image_mime[1];
        $img = str_replace( 'data:image/'.$mime.';base64,', '', $base64_img );
        $img = str_replace( ' ', '+', $img );
        $decoded = base64_decode( $img );
        $filename = $title . '.' . $mime;
        $file_type = 'image/' . $mime;
        $hashed_filename = md5( $filename . microtime() ) . '.' . $mime; // Use the appropriate file extension.

        // Save the image in the uploads directory.
        $upload_file = file_put_contents( $upload_path . $hashed_filename, $decoded );

        if ( $upload_file === false ) {
            return false; // Unable to save the image.
        }

        $attachment = array(
            'post_mime_type' => $file_type,
            'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $hashed_filename ) ),
            'post_content'   => '',
            'post_status'    => 'inherit',
            'guid'           => $upload_dir['url'] . '/' . basename( $hashed_filename )
        );

        // Insert the attachment and get the attachment ID.
        $attach_id = wp_insert_attachment( $attachment, $upload_path . '/' . $hashed_filename );

        if ( is_wp_error( $attach_id ) ) {
            // An error occurred while inserting the attachment.
            return false;
        }

        // Generate thumbnails and other intermediate sizes.
        require_once( ABSPATH . 'wp-admin/includes/image.php' );
        $attach_data = wp_generate_attachment_metadata( $attach_id, $upload_path . '/' . $hashed_filename );

        if ( is_wp_error( $attach_data ) ) {
            // An error occurred while generating thumbnails.
            return false;
        }

        // Update attachment metadata with the generated data.
        wp_update_attachment_metadata( $attach_id, $attach_data );

        return $attach_id;
    }



}
