<?php

namespace EGPR\Queue;

use EGPR\Base\Thing;
use EGPR\Utils;


class Ingest_Manager extends Thing {

    protected $process_all;
    protected $method;
    protected $body;

    public function __construct($method = null, $body = null) {
        if($method){
            $this->method = $method;
        }
        if($body) {
            $this->body = $body;
        }
        $this->setup();
    }

    protected function handle_all() {

        $this->setup();
        Utils::log('Pushing to INGESTION queue....');
        Utils::log($this->method);

        $this->process_all->push_to_queue( ['body' => $this->body, 'method' => $this->method, ] );

        $this->process_all->save()->dispatch();
    }



    public function attach_hooks(){
        add_action( 'init', array( $this, 'setup' ) );
    }

    public function process(){

        $this->handle_all();

    }
    public function setup() {
        $this->process_all    = new Ingest_Process();
    }
}