<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use EGPR\Base\Thing;

class Settings extends Thing {


    const PRESS_RELEASES_TYPE_KEY = 'press_releases_type';

    public function attach_hooks() {
        add_action('acf/include_fields', array($this, 'settings'));
    }

    public function settings(){
        if ( ! function_exists( 'acf_add_local_field_group' ) ) {
            return;
        }

        acf_add_local_field_group( array(
            'key' => 'group_64b720c4a755a',
            'title' => 'Press Releases',
            'fields' => array(
                array(
                    'key' => 'field_64b720c65c7cd',
                    'label' => 'Type',
                    'name' => self::PRESS_RELEASES_TYPE_KEY,
                    'aria-label' => '',
                    'type' => 'select',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'choices' => array(
                        'links' => 'Link',
                        'videos' => 'Video',
                    ),
                    'default_value' => 'link',
                    'return_format' => 'value',
                    'multiple' => 0,
                    'allow_null' => 0,
                    'ui' => 0,
                    'ajax' => 0,
                    'placeholder' => '',
                ),
                array(
                    'key' => 'field_64b720ee5c7ce',
                    'label' => 'URL',
                    'name' => 'url',
                    'aria-label' => '',
                    'type' => 'url',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => '',
                    'placeholder' => '',
                ),


            ),
            'location' => array(
                array(
                    array(
                        'param' => 'post_type',
                        'operator' => '==',
                        'value' => Register::POST_TYPE,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => true,
        ) );
    }

}