<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use EGPR\Base\Thing;
use EGPR\Queue\CRUD_Dispatch_Manager;
use EGPR\Utils;

class Dispatcher {

    private array|bool|null $endpoints = [];
    private array $payload = [];

    public function __construct($payload) {
        $this->endpoints = Utils::get_endpoints();;
        $this->payload = $payload;

    }

    public function execute(): void {
        $queue = [];

        foreach((array)$this->endpoints as $endpoint){
            $queue[] = ['endpoint' => $endpoint, 'payload' => $this->payload];
        }

        $dispatch = new CRUD_Dispatch_Manager($queue);
        $dispatch->process();


    }



}