<?php

namespace EGPR;

class Actions {

    const CLEAR_LOG_NOTICE_KEY = 'egpr_clear_log_notice_cleared';
    const CLEAR_LOG_QUERY_ARG = 'egpr_clear_log';

    public function init(){
        $this->attach_hooks();
    }

    public function attach_hooks(){
        add_action('press-release-body', array($this, 'press_release_body'));
        add_action('init', array($this, 'clear_log'));
        add_action('admin_notices', array($this, 'admin_notices'));
    }


    public function admin_notices(){
        if(!empty($_GET[self::CLEAR_LOG_NOTICE_KEY]) && (int)$_GET[self::CLEAR_LOG_NOTICE_KEY] === 1) {
            echo '<div class="notice notice-success is-dismissible">
                    <p>Log cleared successfully!</p>
                </div>';
        }
    }

    public function clear_log(){

        if(!empty($_GET[self::CLEAR_LOG_QUERY_ARG]) && (int)$_GET[self::CLEAR_LOG_QUERY_ARG] === 1) {
            Utils::clear_log();
            $current_page = add_query_arg(self::CLEAR_LOG_NOTICE_KEY, '1', remove_query_arg(self::CLEAR_LOG_QUERY_ARG, admin_url(sprintf('admin.php?%s', http_build_query($_GET)))));
            wp_redirect($current_page);

        }
    }

    public function press_release_body(){
        Utils::output();
    }


}
