<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;


use EGPR\Utils;



class Rest {


    private $params = [];
    public function __construct($params){
        $this->params = $params;
    }

    public function request(){

        $endpoint = $this->params['endpoint'];
        $payload = $this->params['payload'];
		if(!is_array($endpoint) || !$endpoint['url']) {
			Utils::log('Missing endpoint URL for request');
            return;
		}
        $url = $endpoint['url'];
        $credentials = $endpoint['auth_header'];
        $encoded_credentials = base64_encode($credentials);
        $headers = array(
            'Authorization' => 'Basic ' . $encoded_credentials,
            'Content-Type' => 'application/json',

        );



        $response = wp_remote_post( $url, [
            'headers' => $headers,
            'body' => json_encode($payload),
            'timeout' => 60,
            'sslverify' => false,
        ] );





        if (!is_wp_error($response)) {
            $response_code = wp_remote_retrieve_response_code($response);
            Utils::log($url . ' RESTResponse code: ' . $response_code);
            $response_body = wp_remote_retrieve_body($response);

        } else {
            $error_message = $response->get_error_message();
            Utils::log('Error: ' . $error_message);
        }
        }

}