<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use EGPR\Base\Thing;
use \EGPR\Settings;

class Ajax extends Thing {

    const NONCE_KEY = 'pr_ajax';

    public function attach_hooks() {
        add_action('wp_ajax_egpr_get_press_releases', array($this, 'get_press_releases'));
        add_action('wp_ajax_nopriv_egpr_get_press_releases', array($this, 'get_press_releases'));
		add_action('wp_ajax_egpr_clear_log', array($this, 'clear_log'));
		add_action('wp_ajax_egpr_refresh_log', array($this, 'refresh_log'));
    }

	public function clear_log(){
		check_ajax_referer( self::NONCE_KEY, 'nonce' );
		$settings = new Settings();
		$settings->clear_log(true);
		wp_send_json_success();
		return;
	}

    public function get_press_releases(){
        check_ajax_referer( self::NONCE_KEY, 'nonce' );
        $type = $_POST['type'];
        $page = (int)$_POST['page'] ?: 1;
        wp_send_json_success(['content' => Get::output($type, $page)]);
		return;
    }

	public function refresh_log(){
		check_ajax_referer( self::NONCE_KEY, 'nonce' );
		$settings = new Settings();
		wp_send_json_success(['data' => $settings->get_log_output()]);
	}


}