<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use EGPR\Base\Thing;

use EGPR\Server;
use EGPR\Utils;

class Actions extends Thing {

    const TTL = 3600; // 1 hour

    private static $bypass_save_post = false;
    private static $bypass_untrashed_post = false;


    public static function reset_bypass_untrashed_post(){
        self::$bypass_untrashed_post = false;
    }
    public static function reset_bypass_save_post(){
        self::$bypass_save_post = false;
    }
    public function attach_hooks() {
        add_action( 'trashed_post', array( $this, 'trashed_post' ), PHP_INT_MAX, 1) ;
        add_action( 'untrashed_post', array( $this, 'untrashed_post' ), PHP_INT_MAX, 1 );
        add_action( 'delete_post', array( $this, 'delete_post' ), PHP_INT_MAX, 1);
        add_action( 'save_post', array( $this, 'save_post' ), PHP_INT_MAX, 2 );
        add_action( 'transition_post_status', array( $this, 'transition_post_status' ), PHP_INT_MAX, 3 );

    }

    public function transition_post_status( $new_status, $old_status, $post ){
        if( $old_status === 'trash' && in_array( $new_status, ['publish','pending','draft','auto-draft','future','private','inherit'] ) ){
            self::$bypass_untrashed_post = true;

            $this->trash_action_for_post( $post->ID, 'untrash', $new_status );
        }
    }

    public function trashed_post($post_id){

        if( get_post_type( $post_id ) !== Register::POST_TYPE ) {
            return;
        }
        $this->trash_action_for_post( $post_id, 'trash');
    }
    public function untrashed_post( $post_id ){
        if( get_post_type( $post_id ) !== Register::POST_TYPE ) {
            return;
        }
        if(self::$bypass_untrashed_post){
            self::reset_bypass_untrashed_post();
            return;
        }
        $this->trash_action_for_post( $post_id, 'untrash' );
    }
    public function delete_post( $post_id ) {
        if( get_post_type( $post_id ) !== Register::POST_TYPE ){
            return;
        }
        $this->trash_action_for_post( $post_id, 'delete' );
    }

    public function trash_action_for_post($post_id, $action, $future_status = null) {

        self::$bypass_save_post = true;

        Utils::log('Trash action for post: ' . $post_id . ' action: ' . $action);
        $payload = [

            'method' => 'trash',
            'body' => [
                'untrash_to_future_status' => $future_status,
                'action' => $action,
                'source_post_id' => $post_id,
            ]
        ];

        $dispatch = new Dispatcher($payload);
        $dispatch->execute();


    }

    public function save_post($post_id, $post){
        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        if (defined('DOING_AJAX') && DOING_AJAX) {
            return;
        }
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        if (false !== wp_is_post_revision($post_id)) {
            return;
        }
        if (Register::POST_TYPE !== $post->post_type) {
            return;
        }
        $status = get_post_status($post_id);
        if( in_array($status, ['auto-draft', 'draft', 'inherit']) ) {
            return;
        }
        $this->flush_cache($post_id);
        $this->save_action_for_post($post_id);


    }

    public function flush_cache($post_id){
        $type = get_field(Settings::PRESS_RELEASES_TYPE_KEY, $post_id);
        $key = Get::get_key();
        $data = get_transient($key);
        $data[$type] = [];
        set_transient($key, $data, HOUR_IN_SECONDS);

    }

    public function save_action_for_post($post_id){
        $endpoints = Utils::get_endpoints();
        if(!$endpoints || (is_array($endpoints) && count((array)$endpoints)===0)) {
            return;

        }

        $status = get_post_status($post_id);


        // the trash actions are handled by the trashed_post hook
        if( $status === 'trash' ) {
            return;
        }

        if (  self::$bypass_save_post ) {
            self::reset_bypass_save_post();
            return;
        }

        $title = get_the_title($post_id);
        $image_url = get_the_post_thumbnail_url($post_id, 'full');
        $url = get_field('url', $post_id);
        $type = get_field(Settings::PRESS_RELEASES_TYPE_KEY, $post_id);

        $image_base64 = '';
        if ($image_url) {
            $image_base64 =  Utils::url_to_base64($image_url);
        }
        $body = array(
            'post_status' => $status,
            'image_base64' => $image_base64,
            'type' => $type,
            'url' => $url,
            'image_url' => $image_url,
            'title' => $title,
            'source_post_id' => $post_id,
            'date' => get_post_datetime($post_id)->format('Y-m-d H:i:s')
        );
        $payload = [
            'body' => $body,
            'method' => 'upsert'
        ];
        $dispatch = new Dispatcher($payload);
        $dispatch->execute();
    }



}