<?php

namespace EGPR\Queue;

use EGPR\Base\Thing;
use EGPR\Utils;

class CRUD_Dispatch_Manager extends Thing {

    protected $process_all;
    private $queue = [];
    public function __construct($request = null) {
        if(!!$request){
            $this->queue = $request;
        }
        $this->setup();



    }

    protected function handle_all() {



        $this->setup();
        Utils::log('Pushing to ingestion queue....');

        foreach((array)$this->queue as $queue_item){

            $this->process_all->push_to_queue( $queue_item );
        }
        $this->process_all->save()->dispatch();
    }



    public function attach_hooks(){
        add_action( 'init', array( $this, 'setup' ) );
    }

    public function process(){

        $this->handle_all();

    }
    public function setup() {
        $this->process_all    = new CRUD_Dispatch_Process();
    }

}