<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;


use EGPR\Utils;

class Register {

    const POST_TYPE            = 'eg-press-releases';
    const LOG_KEY = 'egpr_log';

    public function init() {
        $this->attach_hooks();
    }

    public function attach_hooks() {

        add_action( 'init', array( $this, 'register_post_type' ) );

        add_filter('post_type_link', array($this, 'permalink'), 10, 2);
        add_filter('post_link', array($this, 'permalink'), 10, 2);
        add_action('init', array($this, 'image_sizes'));
        add_action( 'init', array($this, 'rewrite' ) );
        add_filter( 'query_vars', array($this, 'query_vars') );

        add_action('pre_get_posts', array($this, 'pre_get_posts'));


    }

    public static function get($const){
        switch ($const) :
            case 'POSTS_PER_PAGE_LINKS_PAGE_1':
                return apply_filters('egpr/POSTS_PER_PAGE_LINKS_PAGE_1', 5);
                break;
            case 'POSTS_PER_PAGE_VIDEOS_PAGE_1':
                return apply_filters('egpr/POSTS_PER_PAGE_VIDEOS_PAGE_1', 2);
                break;
            case 'POSTS_PER_PAGE_BEYOND_1_LINKS':
                return apply_filters('egpr/POSTS_PER_PAGE_BEYOND_1_LINKS', 10);
                break;
            case 'POSTS_PER_PAGE_BEYOND_1_VIDEOS':
                return apply_filters('egpr/POSTS_PER_PAGE_BEYOND_1_VIDEOS', 10);
                break;
            default:
                return null;

        endswitch;

    }



    public function pre_get_posts($query){
        if ( ! is_admin() && $query->is_main_query() && $query->is_post_type_archive( 'eg-press-releases' ) ) {
            $eg_press_type = $query->get( 'eg_press_type' );

            if ( $eg_press_type ) {
                $paged = $query->get( 'paged' ) ?: 1;

                if ( $paged === 1 ) {
                    $posts_per_page = $eg_press_type === 'links' ? self::get('POSTS_PER_PAGE_LINKS_PAGE_1') : self::get('POSTS_PER_PAGE_VIDEOS_PAGE_1');
                } else {
                    $posts_per_page = ($eg_press_type === 'links' ? self::get('POSTS_PER_PAGE_BEYOND_1_LINKS') : self::get('POSTS_PER_PAGE_BEYOND_1_VIDEOS'));
                }

                $offset = $paged <= 1 ? 0 : ($paged - 2) * ($eg_press_type === 'links' ? self::get('POSTS_PER_PAGE_BEYOND_1_LINKS') : self::get('POSTS_PER_PAGE_BEYOND_1_VIDEOS')) + ($eg_press_type === 'links' ? self::get('POSTS_PER_PAGE_LINKS_PAGE_1') : self::get('POSTS_PER_PAGE_VIDEOS_PAGE_1'));

                $query->set( 'posts_per_page', $posts_per_page );
                $query->set( 'offset', $offset );

                $meta_query = array(
                    array(
                        'key' => 'type',
                        'value' => $eg_press_type,
                    ),
                );
                $query->set( 'meta_query', $meta_query );
            }
        }
    }




    public function template_redirect(){

        if ( get_query_var('post_type') === 'eg-press-releases' &&  in_array(get_query_var( 'eg_press_type' ), [ 'links', 'videos' ]) ) {
            return locate_template( 'archive-eg-press-releases.php', true );
            exit;
        }
    }



    public function query_vars($vars){
        $vars[] = 'eg_press_type';
        return $vars;
    }

    public function rewrite(){
        add_rewrite_rule(
            '^press/(videos|links)/?$',
            'index.php?post_type=' . self::POST_TYPE .'&eg_press_type=$matches[1]',
            'top'
        );
        add_rewrite_rule(
            '^press/(videos|links)/page/([0-9]+)/?$',
            'index.php?post_type=' . self::POST_TYPE .'&eg_press_type=$matches[1]&paged=$matches[2]',
            'top'
        );
    }



    public function image_sizes(){
        add_image_size('525x300', 525, 300, true);
        add_image_size('255x205', 255, 205, true);
    }

    public function permalink($permalink, $post){
        if($post->post_type !== self::POST_TYPE){
            return $permalink;
        }
        // Get the meta field value
        return get_field('url', $post->ID) ?: $permalink;


    }





    public function register_post_type() {
        register_post_type(
            self::POST_TYPE,
            array(
                'labels'              => array(
                    'name'               => __( 'Press', 'egprep' ),
                    'singular_name'      => __( 'Press', 'egprep' ),
                    'add_new'            => __( 'Add New', 'egprep' ),
                    'add_new_item'       => __( 'Add New Press', 'egprep' ),
                    'edit_item'          => __( 'Edit Press', 'egprep' ),
                    'new_item'           => __( 'New Press', 'egprep' ),
                    'all_items'          => __( 'All Press', 'egprep' ),
                    'view_item'          => __( 'View Press', 'egprep' ),
                    'search_items'       => __( 'Search Press', 'egprep' ),
                    'not_found'          => __( 'No Press  Found', 'egprep' ),
                    'not_found_in_trash' => __( 'No Press found in Trash', 'egprep' ),
                    'menu_name'          => __( 'Press ', 'egprep' ),
                ),
                'menu_icon'           => 'dashicons-superhero',
                'query_var'           => true,
                'publicly_queryable'  => true,
                'exclude_from_search' => false,
                'hierarchical'        => false,
                'show_in_menu'        => true,
                'public'              => true,
                'show_ui'             => true,
                'rewrite'             => array(
                    'slug'       => 'press',
                    'with_front' => true,
                ),
                'has_archive'         => apply_filters('egpr/has_archive', false),
                'supports'            => array( 'title', 'thumbnail' ),
                'map_meta_cap'        => true,
                'show_in_rest'        => true,

            )
        );
    }


    public static function save_post( $post_id, $post )
    {

        if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
            return;
        }
        if (defined('DOING_AJAX') && DOING_AJAX) {
            return;
        }
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
        if (false !== wp_is_post_revision($post_id)) {
            return;
        }
        if (self::POST_TYPE !== $post->post_type) {
            return;
        }

        $endpoints = Utils::get_endpoints();
        if(!$endpoints || (is_array($endpoints) && count((array)$endpoints)===0)) {
            return;

        }




    }


    public static function timeout(){
        return 90;
    }


}
