<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use EGPR\Base\Thing;
use \EGPR\Settings;

class Ajax extends Thing {

    const NONCE_KEY = 'pr_ajax';

    public function attach_hooks() {
        add_action('wp_ajax_egpr_get_press_releases', array($this, 'get_press_releases'));
        add_action('wp_ajax_nopriv_egpr_get_press_releases', array($this, 'get_press_releases'));
    }

    public function get_press_releases(){
        check_ajax_referer( self::NONCE_KEY, 'nonce' );
        $type = $_POST['type'];
        $page = (int)$_POST['page'] ?: 1;
        wp_send_json_success(['content' => Get::output($type, $page)]);
    }


}