<?php
/*
Plugin Name:  Press
Plugin URI:   https://statenweb.com
Author:       StatenWeb
Author URI:   https://statenweb.com
Description:  Press Releases
Version:      5.4

//
// **********************************************************************
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// **********************************************************************
*/


use EGPR\Data_Structures\Post_Types\Press_Releases\Actions;
use EGPR\Data_Structures\Post_Types\Press_Releases\Register;
use EGPR\Queue\CRUD_Dispatch_Manager;
use EGPR\Queue\CRUD_Manager;
use EGPR\Settings;
use EGPR\Shortcode\PR;
use EGPR\Utils;

require __DIR__ . '/vendor/autoload.php';

$namespace = ['EGPR'];

define('EGPR_BLOCKS_URL', plugin_dir_url( __FILE__ ));
define('EGPR_BLOCKS_PATH', plugin_dir_path( __FILE__ ));

\spl_autoload_register(
    function ( $class ) use ( $namespace ) {
        $base = explode( '\\', $class );
        if ( in_array( $base[0], $namespace ) ) {
            $file = __DIR__ . DIRECTORY_SEPARATOR . strtolower(
                    str_replace(
                        [ '\\', '_' ],
                        [
                            DIRECTORY_SEPARATOR,
                            '-',
                        ],
                        $class
                    ) . '.php'
                );
            if ( file_exists( $file ) ) {
                require $file;
            } else {
                ob_start();
                debug_print_backtrace();
                $x = ob_get_clean();
                echo( sprintf( 'File %s not found<pre>' .$x, esc_html( $file ) ) );
                die;
            }
        }

    }
);



$press_releases = new Register();
$press_releases->init();
$pr_actions = new Actions();
$pr_actions->init();
$pr_settings = new \EGPR\Data_Structures\Post_Types\Press_Releases\Settings();
$pr_settings->init();


$settings = new Settings();
$settings->init();

$actions = new \EGPR\Actions();
$actions->init();

$server = new \EGPR\Server();
$server->init();

$CRUD_manager = new CRUD_Dispatch_Manager();
$CRUD_manager->init();
$ingest_manager = new \EGPR\Queue\Ingest_Manager();
$ingest_manager->init();


$ajax = new \EGPR\Data_Structures\Post_Types\Press_Releases\Ajax();
$ajax->init();

$shortcode = new PR();
$shortcode->init();

$enqueues = new \EGPR\Enqueues();
$enqueues->init();