<?php

namespace EGPR;


use EGPR\Data_Structures\Post_Types\Press_Releases\Register;

class Utils {


    private static $log_type = 'log';

    public static function log($message){

        if(!is_string($message)){
            $message = print_r($message, true);
        }
        $message = date('Y-m-d H:i:s') . ' ' . $message . "\n";

        if('error_log' === self::$log_type) {
            error_log($message);
        } else {
            $log = (array)get_field(Register::LOG_KEY, 'option');
            $log[] = $message;
            $log = array_slice($log, -500);
            update_field(Register::LOG_KEY, $log, 'option');
        }


    }

    public static function get_endpoints(){
        return Settings::get('egpr_to_push');
    }


    public static function url_to_base64($url) {


        $args = array(
            'timeout' => 60,
        );


        $response = wp_remote_get($url, $args);


        if (is_array($response) && !is_wp_error($response)) {
            // Get the response body from the remote request
            $file_data = wp_remote_retrieve_body($response);

            // Now $file_data contains the contents of the remote URL
        } else {
            // Handle the case when the request fails
            $file_data = false;
        }

        if ($file_data === false) {
            return null;
        }
        $f_info = finfo_open(FILEINFO_MIME_TYPE);
        $mime_type = finfo_buffer($f_info, $file_data);
        finfo_close($f_info);
        $base_64_data = base64_encode($file_data);
        $data_uri = 'data:' . $mime_type . ';base64,' . $base_64_data;
        return $data_uri;
    }


    public static function upload_image( $base64_img, $title ) {
        // Upload dir.
        $upload_dir  = wp_upload_dir();
        $upload_path = str_replace( '/', DIRECTORY_SEPARATOR, $upload_dir['path'] ) . DIRECTORY_SEPARATOR;

        // Get the image format and file extension from the base64 image data.
        $image_parts = explode( ';', $base64_img );
        $image_mime = explode( '/', $image_parts[0] );
        if ( count( $image_mime ) !== 2 || ! in_array( $image_mime[1], array( 'jpeg', 'png', 'gif', 'webp', 'avif' ) ) ) {
            return false;
        }
        $mime = $image_mime[1];
        $img = str_replace( 'data:image/'.$mime.';base64,', '', $base64_img );
        $img = str_replace( ' ', '+', $img );
        $decoded = base64_decode( $img );
        $filename = $title . '.' . $mime;
        $file_type = 'image/' . $mime;
        $hashed_filename = md5( $filename . microtime() ) . '.' . $mime; // Use the appropriate file extension.

        // Save the image in the uploads directory.
        $upload_file = file_put_contents( $upload_path . $hashed_filename, $decoded );

        if ( $upload_file === false ) {
            return false; // Unable to save the image.
        }

        $attachment = array(
            'post_mime_type' => $file_type,
            'post_title'     => preg_replace( '/\.[^.]+$/', '', basename( $hashed_filename ) ),
            'post_content'   => '',
            'post_status'    => 'inherit',
            'guid'           => $upload_dir['url'] . '/' . basename( $hashed_filename )
        );

        // Insert the attachment and get the attachment ID.
        $attach_id = wp_insert_attachment( $attachment, $upload_path . '/' . $hashed_filename );

        if ( is_wp_error( $attach_id ) ) {
            // An error occurred while inserting the attachment.
            return false;
        }

        // Generate thumbnails and other intermediate sizes.
        require_once( ABSPATH . 'wp-admin/includes/image.php' );
        $attach_data = wp_generate_attachment_metadata( $attach_id, $upload_path . '/' . $hashed_filename );

        if ( is_wp_error( $attach_data ) ) {
            // An error occurred while generating thumbnails.
            return false;
        }

        // Update attachment metadata with the generated data.
        wp_update_attachment_metadata( $attach_id, $attach_data );

        return $attach_id;
    }

    public static function set_image($base64_image, $title, $source_url) {
        $args = array(
            'post_type' => 'attachment',
            'meta_key' => 'image_url',
            'meta_value' => $source_url
        );
        $images = get_posts($args);
        if (count($images) > 0) {
            Utils::log('Image already exists for ' . $title . ' ' . $source_url . ' with meta key image_url and value ' . $source_url);
            return $images[0]->ID;
        }
        Utils::log('Creating image for ' . $title . ' ' . $source_url);
        $image_id = self::upload_image($base64_image, $title);
        Utils::log('Image ID for  ' . $image_id . ' ' . $source_url);
        update_field('image_url', $source_url, $image_id);
    }



}
