<?php

namespace EGPR;

use EGPR\Base\Thing;
use EGPR\Data_Structures\Post_Types\Press_Releases\Get;
use EGPR\Data_Structures\Post_Types\Press_Releases\Register;


class Settings extends Thing {

    const SLUG = 'egpr';



    public function attach_hooks() {

        add_action('init', array(__CLASS__, 'clear_log'));

        add_action('init', array($this, 'add_settings_page'));
        add_action('acf/save_post', array($this, 'save_settings'), 1);
        add_action('acf/include_fields',  array($this, 'settings_fields'));
        add_filter('acf/load_field/name=' . Register::LOG_KEY, array($this, 'log_output'));
    }

    public function save_settings(){
        $screen = get_current_screen();
        if (str_contains($screen->id, self::SLUG)) {
            $key = Get::get_key();
            delete_transient($key);
error_log('cleared transient');

        }
    }

    public function settings_fields() {
        if ( ! function_exists( 'acf_add_local_field_group' ) ) {
            return;
        }

        acf_add_local_field_group( array(
            'key' => 'group_649354422766a',
            'title' => 'Press',
            'fields' => array(
                array(
                    'key' => 'field_6493fasdff6cfd1',
                    'label' => 'Press Videos',
                    'name' => '',
                    'aria-label' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_6493545267030',
                    'label' => 'Title',
                    'name' => 'prv_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Press Release Videos',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),

                array(
                    'key' => 'field_649356a867032',
                    'label' => 'Load More Text',
                    'name' => 'prv_load_more_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Load More',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64fafasdsdf9354a8dccc1',
                    'label' => 'Page 1 Posts to Show',
                    'name' => 'prv_page_1_posts_to_show',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64ffasdasdffasdf9354a8dccc1',
                    'label' => 'Page 2+ Posts to Show',
                    'name' => 'prv_page_2_beyond_posts_to_show',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 3,
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64935sdf6cfd1',
                    'label' => 'Press',
                    'name' => '',
                    'aria-label' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_64935442dccbf',
                    'label' => 'Title',
                    'name' => 'pr_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'In the News',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_649354a8dccc1',
                    'label' => 'Load More Text',
                    'name' => 'pr_load_more_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Load More',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64fasdf9354a8dccc1',
                    'label' => 'Page 1 Posts to Show',
                    'name' => 'pr_page_1_posts_to_show',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 9,
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64ffasdfasdf9354a8dccc1',
                    'label' => 'Page 2+ Posts to Show',
                    'name' => 'pr_page_2_beyond_posts_to_show',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 9,
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),

            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
            'is_acf_component' => 0,
            'acf_component_defaults' => array(
                'layout' => 'block',
                'repeatable' => '0',
                'pagination' => '0',
                'rows_per_page' => '20',
                'min' => '',
                'max' => '',
                'button_label' => '',
                'appearances' => '',
            ),
        ) );

	    acf_add_local_field_group( array(
		    'key' => 'group_64c27539ca33b',
		    'title' => 'Ingestion Mode',
		    'fields' => array(
			    array(
				    'key' => 'field_64c2753b13fa5',
				    'label' => 'Ingestion Mode',
				    'name' => 'ingestion_mode',
				    'aria-label' => '',
				    'type' => 'select',
				    'instructions' => '',
				    'required' => 0,
				    'conditional_logic' => 0,
				    'wrapper' => array(
					    'width' => '',
					    'class' => '',
					    'id' => '',
				    ),
				    'choices' => array(
					    'synchronous' => 'Synchronous',
					    'asynchronous' => 'Asynchronous',
				    ),
				    'default_value' => 'synchronous',
				    'return_format' => 'value',
				    'multiple' => 0,
				    'allow_null' => 0,
				    'ui' => 0,
				    'ajax' => 0,
				    'placeholder' => '',
			    ),
		    ),
		    'location' => array(
			    array(
				    array(
					    'param' => 'options_page',
					    'operator' => '==',
					    'value' => 'egpr',
				    ),
			    ),
		    ),
		    'menu_order' => 0,
		    'position' => 'normal',
		    'style' => 'default',
		    'label_placement' => 'top',
		    'instruction_placement' => 'label',
		    'hide_on_screen' => '',
		    'active' => true,
		    'description' => '',
		    'show_in_rest' => 0,
	    ) );

        acf_add_local_field_group( array(
            'key' => 'group_64b2cfa518c4c',
            'title' => 'Push Press',
            'fields' => array(
                array(
                    'key' => 'field_64b2cfa5f1df1',
                    'label' => 'EGPR To Push',
                    'name' => 'egpr_to_push',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_64b2cfb8f1df2',
                            'label' => 'URL',
                            'name' => 'url',
                            'aria-label' => '',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'parent_repeater' => 'field_64b2cfa5f1df1',
                        ),
                        array(
                            'key' => 'field_64b2cfc1f1df3',
                            'label' => 'Auth Header',
                            'name' => 'auth_header',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_64b2cfa5f1df1',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );

        acf_add_local_field_group( array(
            'key' => 'group_64b83c5a5b82d',
            'title' => 'Log',
            'fields' => array(
                array(
                    'key' => Register::LOG_KEY,
                    'label' => 'Message',
                    'name' => Register::LOG_KEY,
                    'aria-label' => '',
                    'type' => 'message',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'new_lines' => 'wpautop',
                    'esc_html' => 0,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 999,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );



    }






    public function add_settings_page() {

        if ( function_exists( 'acf_add_options_sub_page' ) ) {
            acf_add_options_sub_page(
                array(
                    'page_title'  => 'Press',
                    'menu_title'  => 'Settings',
                    'menu_slug'   => self::SLUG,
                    'capability'  => 'edit_users',
                    'parent_slug' => sprintf('edit.php?post_type=%s', Register::POST_TYPE),
                )
            );
        }
    }

    public static function get( $key ) {

        if ( ! function_exists( 'get_field' ) ) {
            return;
        }

        return get_field( $key, 'options' );
    }

    public function log_output($field) {
        remove_filter('acf/load_field/name=' . Register::LOG_KEY, array($this, 'log_output'));


        $log = Settings::get(Register::LOG_KEY);
        add_filter('acf/load_field/name=' . Register::LOG_KEY, array($this, 'log_output'));
        if(!is_array($log)){
            $log = [];
        }
        $field['message'] = '<pre style="max-width:100%;overflow:auto;">' . implode('', $log) . '</pre>';

        return $field;
    }

    public static function clear_log(){

        if(!empty($_GET[Actions::CLEAR_LOG_QUERY_ARG]) && (int)$_GET[Actions::CLEAR_LOG_QUERY_ARG] === 1) {
            update_field(Register::LOG_KEY, [], 'option');
            $current_page = add_query_arg(Actions::CLEAR_LOG_NOTICE_KEY, '1', remove_query_arg(Actions::CLEAR_LOG_QUERY_ARG, admin_url(sprintf('admin.php?%s', http_build_query($_GET)))));
            wp_redirect($current_page);

        }
    }



}
