<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use \EGPR\Settings;

class Get {

    public static function get_key(){
        return md5(serialize(['prs']));
    }

    public static function posts($type, $page){

        $prv_page_1_posts_to_show = Settings::get('prv_page_1_posts_to_show');
        $prv_page_2_beyond_posts_to_show = Settings::get('prv_page_2_beyond_posts_to_show');
        $pr_page_1_posts_to_show = Settings::get('pr_page_1_posts_to_show');
        $pr_page_2_beyond_posts_to_show = Settings::get('pr_page_2_beyond_posts_to_show');
        $prv_offset = ($page <= 1) ? 0 : ($prv_page_1_posts_to_show + ($page - 2) * $prv_page_2_beyond_posts_to_show);
        $pr_offset = ($page <= 1) ? 0 : ($pr_page_1_posts_to_show + ($page - 2) * $pr_page_2_beyond_posts_to_show);


        $transient_key = self::get_key();
        $posts_query = get_transient($transient_key);

        if(
            is_array($posts_query) &&
            array_key_exists($type, $posts_query) &&
            array_key_exists($page, $posts_query[$type]) &&
            is_a($posts_query[$type][$page], 'WP_Query') &&
            $posts_query[$type][$page]->have_posts()
        ){
            return $posts_query[$type][$page];
        }
        $posts_per_page = ($type === 'videos') ? ((1 === $page) ? $prv_page_1_posts_to_show : $prv_page_2_beyond_posts_to_show) : ((1 === $page) ? $pr_page_1_posts_to_show : $pr_page_2_beyond_posts_to_show);
        error_log('ppp' . $posts_per_page);
        $args = [
            'post_type' => \EGPR\Data_Structures\Post_Types\Press_Releases\Register::POST_TYPE,
            'offset' => 'videos' === $type ? $prv_offset : $pr_offset,
            'posts_per_page' => $posts_per_page,
            'meta_query' => [
                [
                    'key' => \EGPR\Data_Structures\Post_Types\Press_Releases\Settings::PRESS_RELEASES_TYPE_KEY,
                    'value' => $type,
                    'compare' => '=',
                ],
            ],
        ];

        $page_of_posts = new \WP_Query($args);

        if(!is_array($posts_query)){
            $posts_query = [];
        }
        if(!array_key_exists($type, $posts_query)){
            $posts_query[$type] = [];
        }

        $page_1_count = 'videos' === $type ? $prv_page_1_posts_to_show : $pr_page_1_posts_to_show;
        $page_2_count = 'videos' === $type ? $prv_page_2_beyond_posts_to_show : $pr_page_2_beyond_posts_to_show;
        if(!$page_1_count){
            $page_1_count = 3;
        }
        if(!$page_2_count){
            $page_2_count = 3;
        }
        $page_of_posts->max_num_pages = 1 + ceil(($page_of_posts->found_posts - (int)$page_1_count ) / (int)$page_2_count);
        $posts_query[$type][$page] = $page_of_posts;
        set_transient($transient_key, $posts_query, \EGPR\Data_Structures\Post_Types\Press_Releases\Actions::TTL);

        return $page_of_posts;


    }

    public static function output($type, $page){



        $posts = \EGPR\Data_Structures\Post_Types\Press_Releases\Get::posts($type, $page);
        $last_page = (int)$posts->max_num_pages ?: 1;
        ob_start();
        self::output_before($type);


        if($posts->have_posts()) :
            while($posts->have_posts()) :
                $posts->the_post();
                self::output_single($type);

            endwhile;
            if($last_page > $page):
                self::generate_next_page_link($type, $page);
            endif;
            wp_reset_postdata();
        endif;

        self::output_after($type);

        return ob_get_clean();


    }

    public static function generate_next_page_link($type, $page){
        ?><div class="!tw-my-[64px] lg:!tw-mt-5 !tw-basis-full !tw-w-full tw-flex tw-justify-center"><div role="button" class="tw-no-underline !tw-text-white tw-bg-[#c20000] tw-inline-block tw-px-3 tw-py-1 tw-rounded-[5px] tw-text-[20px] lg:tw-text-[14px] hover:tw-opacity-80 tw-duration-300 tw-transition-all" data-pr-type="<?php echo $type; ?>" data-page="<?php echo (int)$page; ?>" data-next-page="<?php echo (int)$page+1; ?>">Load More</div></div><?php
    }

    public static function output_before($type){
        if('videos' === $type) {
            self::output_before_videos();
            return;
        }
        self::output_before_links();
    }

    public static function output_before_videos(){
        ?>
        <div class="tw-mx-auto tw-flex max-w-[960px] tw-gap-5 tw-flex-wrap tw-justify-between">
        <?php

    }

    public static function output_before_links(){
        ?>
        <?php
    }



    public static function output_after($type){
        if('videos' === $type) {
            self::output_after_videos();
            return;
        }
        self::output_after_links();
    }
    public static function output_after_videos(){
        ?>
        </div>
        <?php

    }

    public static function output_after_links(){
        ?>
        <?php
    }


    public static function output_single($type){
        if('videos' === $type) {
            self::output_single_videos();
            return;
        }
        self::output_single_links();

    }

    public static function output_single_videos(){
        ?>
        <a href="<?php the_permalink();?>" class=" !tw-no-underline tw-overflow-hidden tw-group hover:tw-opacity-80 tw-block tw-duration-300 tw-translate-all tw-block tw-mt-5 shrink-0 grow-0 lg:tw-basis-[48%] tw-basis-full tw-w-full tw-px-5">
            <div class=" tw-bg-black tw-h-[430px] lg:tw-w-[570px] "><?php the_post_thumbnail('full', ['class' => '!tw-my-0 tw-mx-auto tw-h-full tw-object-contain']); ?></div>
            <div><h2 class="!tw-mt-3 tw-text-center tw-text-xl tw-font-bold tw-no-underline group-hover:tw-no-underline"><?php the_title(); ?></h2></div>
        </a>

        <?php
    }

    public static function output_single_links(){
        ?>
            <div class="tw-flex tw-flex-col lg:tw-flex-row tw-my-5">
              <div class="tw-flex-shrink-0 tw-flex-grow-0 tw-basis-full lg:tw-basis-1/3 lg:tw-w-[444px]">
                <a class="tw-block tw-bg-black" href="<?php the_permalink(); ?>"><?php the_post_thumbnail('full', ['class' => ' tw-object-cover tw-duration-300 tw-transition-all hover:tw-opacity-80 tw-object-contain tw-w-[350px] tw-h-[350px] tw-mx-auto']); ?></a>
              </div>
              <div class="tw-flex tw-flex-shrink-0 tw-flex-grow-0 tw-basis-full tw-items-center lg:tw-basis-2/3 lg:tw-pl-5 tw-pt-5 lg:tw-pt-0">
                <div class="tw-text-center lg:tw-text-left tw-flex tw-flex-col  tw-gap-5">
                  <p class="!tw-my-0"><?php echo get_the_date( 'F j, Y') ?></p>
                  <p class="tw-text-2xl !tw-my-0 tw-font-bold"><?php the_title(); ?></p>
                  <p class="!tw-my-0"><a class="!tw-no-underline !tw-text-white tw-bg-[#c20000] tw-inline-block tw-px-3 tw-py-1 tw-rounded-[5px] tw-text-[20px] lg:tw-text-[14px] hover:tw-opacity-80 tw-duration-300 tw-transition-all" href="<?php the_permalink(); ?>">Read More</a></p>

                  </div>
              </div>
            </div>

        <?php
    }


}