<?php

namespace EGPR;

/**
 * Class Rest_Server
 */
class Server extends \WP_Rest_Controller {

    public $namespace = 'egpr/';
    public $version = 'v1';


    public function init() {
        add_action( 'rest_api_init', array( $this, 'register_routes' ) );
    }


    public function register_routes() {
        $namespace = $this->namespace . $this->version;

        register_rest_route(
            $namespace,
            '/press',
            array(
                array(
                    'methods'  => \WP_REST_Server::CREATABLE,
                    'callback' => array( $this, 'create_press' ),
                    'permission_callback' => array( $this, 'get_users_permission' ),
                    'args' => array(


                    ),
                ),
            )
        );

        register_rest_route(
            $namespace,
            '/press',
            array(
                array(
                    'methods'  => \WP_REST_Server::READABLE,
                    'callback' => array( $this, 'get_press' ),
                    'permission_callback' => array( $this, 'get_users_permission' ),
                    'args' => array(


                    ),
                ),
            )
        );


    }



    public function get_press(\WP_REST_Request $request){
        $videos = get_field( 'prv_videos', 'option' );
        $links = get_field( 'prv_link', 'option' );

        $new_videos = [];


        foreach($videos as $video){
            $temp_video = [];
            if(!empty($video['image'])) {
                $video['image'] = wp_get_attachment_image_url($video['image']);
            }
            if(!empty($video['date'])) {
                $video['date'] = strtotime($video['date']);
            }
            $temp_video[] = $video;

            $new_videos[] = $temp_video;
        }



        $new_links = [];
        foreach($links as $link){
            $temp_link = [];
            if(!empty($link['image'])) {
                $link['image'] = wp_get_attachment_image_url($link['image']);
            }
            $temp_link[] = $link;

            $new_links[] = $temp_link;
        }


        return $this->send_json_response(['links' => $new_links, 'videos' => $new_videos]);


    }

    public function create_press(\WP_REST_Request $request){

//        update_field('field_649356cf67033', $new_videos, 'option');
//
//        update_field('field_649354b6dccc2', $new_links, 'option');
//
//        $videos = $request->get_param( 'videos' );
//        $links = $request->get_param( 'links' );
//        $new_videos = [];
//
//
//        foreach($videos as $video){
//            $temp_video = [];
//            if(!empty($video['image']) {
//                $video['image'] = wp_get_attachment_image_url($video['image']);
//            }
//            if(!empty($video['date'])) {
//                $video['date'] = strtotime($video['date']);
//            }
//            $temp_video[] = $video;
//
//            $new_videos[] = $temp_video;
//        }
//
//        update_field('field_649356cf67033', $new_videos, 'option');
//
//
//        $new_links = [];
//        foreach($links as $link){
//            $temp_link = [];
//            if(!empty($link['image']) {
//                $link['image'] = wp_get_attachment_image_url($link['image']);
//            }
//            $temp_link[] = $link;
//
//            $new_links[] = $temp_link;
//        }
//
//        update_field('field_649354b6dccc2', $new_links, 'option');




        return $this->send_json_response();

    }



    public function send_json_response($results, $success = true){
        $response = new \WP_REST_Response(
            array(
                'data' => array(
                    'success'  => $success,
                    'response' => $results,
                ),
            )
        );
        if(!$success){
            $response->set_status(400);
        }
        return $response;
    }

    //filters





    //permissions

    /**
     * Is the user logged in?
     *
     * @return bool|WP_Error
     */
    public function get_users_permission() {

        return is_user_logged_in() && current_user_can('edit_posts');
    }



}
