<?php

namespace EGPR\Queue;


use EGPR\Data_Structures\Post_Types\Press_Releases;
use EGPR\Utils;

class Post_Creator_Process extends \WP_Background_Process {
    /**
     * @var string
     */
    protected $action = 'pr-post-generator';




    /**
     * Task
     *
     * Override this method to perform any actions required on each
     * queue item. Return the modified item for further processing
     * in the next pass through. Or, return false to remove the
     * item from the queue.
     *
     * @param mixed $emails_object Queue item to iterate over
     *
     * @return mixed
     */
    protected function task( $request ) {

        Utils::log('Post Process Task');


        if( 'delete' === $request['method'] ) {

            Utils::log($request['post_id'] .  ' deleting post');
            Press_Releases::_delete_action($request);
        }

        if( 'upsert' === $request['method'] ) {
            Utils::log('upserting post');
            Press_Releases::_upsert_action($request);
        }




       return false;
    }


    /**
     * Complete
     *
     * Override if applicable, but ensure that the below actions are
     * performed, or, call parent::complete().
     */
    protected function complete() {
        parent::complete();
        Utils::log('Post Process Complete');

        // Show notice to user or perform some other arbitrary task...
    }


}