<?php

namespace EGPR\Blocks;

use EGPR\Base\Thing;

class Press_Releases_Videos extends Thing {

    public function attach_hooks() {
        if ( function_exists( 'acf_register_block_type' ) ) {
            add_action( 'acf/init', array( $this, 'register' ) );
        }
    }

    public function register() {

        acf_register_block_type(
            array(
                'name'            => 'eg-press-releases-videos',
                'title'           => __( 'EG Press Releases Videos' ),
                'description'     => __( 'EG Press Releases Videos' ),
                'render_callback' => 'eg_render_callback',
                'category'        => 'common',

                'keywords'        => array( 'Press Releases Videos' ),
                'align'           => 'center',
                'mode' 			  => 'edit',
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => true,
                        )
                    )
                )
            )
        );
    }

}
