<?php
/*
Plugin Name:  Press Releases
Plugin URI:   https://statenweb.com
Author:       StatenWeb
Author URI:   https://statenweb.com
Description:  Press Releases
Version:      1.8.1

//
// **********************************************************************
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// **********************************************************************
*/



$namespace = ['EGPR'];

define('EGPR_BLOCKS_URL', plugin_dir_url( __FILE__ ));
define('EGPR_BLOCKS_PATH', plugin_dir_path( __FILE__ ));

\spl_autoload_register(
    function ( $class ) use ( $namespace ) {
        $base = explode( '\\', $class );
        if ( in_array( $base[0], $namespace ) ) {
            $file = __DIR__ . DIRECTORY_SEPARATOR . strtolower(
                    str_replace(
                        [ '\\', '_' ],
                        [
                            DIRECTORY_SEPARATOR,
                            '-',
                        ],
                        $class
                    ) . '.php'
                );
            if ( file_exists( $file ) ) {
                require $file;
            } else {
                wp_die( sprintf( 'File %s not found', esc_html( $file ) ) );
            }
        }

    }
);


function eg_render_callback( $block ) {
    // convert name ("acf/testimonial") into path friendly slug ("testimonial")
    $slug = str_replace( 'acf/', '', $block['name'] );
    $path = plugin_dir_path( __FILE__ ) . "templates/{$slug}.php";

    if ( file_exists( $path ) ) {
        include $path;
    }

}

$enqueues = new \EGPR\Enqueues();
$enqueues->init();
$press_releases_video = new \EGPR\Blocks\Press_Releases_Videos();
$press_releases_video->init();
$press_releases = new \EGPR\Blocks\Press_Releases();
$press_releases->init();
$settings = new \EGPR\Settings();
$settings->init();
$shortcode = new \EGPR\Shortcode();
$shortcode->init();

$server = new \EGPR\Server();
$server->init();
