<?php

namespace EGPR;

use EGPR\Base\Thing;
use EGPR\Data_Structures\Post_Types\Press_Releases;

class Settings extends Thing {

    const SLUG = 'egpr';



    public function attach_hooks() {

        add_action('init', array($this, 'add_settings_page'));
        add_action('acf/include_fields',  array($this, 'settings_fields'));
        add_filter('acf/load_field/name=' . Press_Releases::LOG_KEY, array($this, 'log_output'));
    }

    public function settings_fields() {
        if ( ! function_exists( 'acf_add_local_field_group' ) ) {
            return;
        }

        acf_add_local_field_group( array(
            'key' => 'group_649354422766a',
            'title' => 'Press Releases',
            'fields' => array(
                array(
                    'key' => 'field_6493fasdff6cfd1',
                    'label' => 'Press Releases Videos',
                    'name' => '',
                    'aria-label' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_6493545267030',
                    'label' => 'Title',
                    'name' => 'prv_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Press Release Videos',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),

                array(
                    'key' => 'field_649356a867032',
                    'label' => 'Load More Text',
                    'name' => 'prv_load_more_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Load More',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),

                array(
                    'key' => 'field_64935sdf6cfd1',
                    'label' => 'Press Releases',
                    'name' => '',
                    'aria-label' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_64935442dccbf',
                    'label' => 'Title',
                    'name' => 'pr_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'In the News',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_649354a8dccc1',
                    'label' => 'Load More Text',
                    'name' => 'pr_load_more_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Load More',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),

            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
            'is_acf_component' => 0,
            'acf_component_defaults' => array(
                'layout' => 'block',
                'repeatable' => '0',
                'pagination' => '0',
                'rows_per_page' => '20',
                'min' => '',
                'max' => '',
                'button_label' => '',
                'appearances' => '',
            ),
        ) );

        acf_add_local_field_group( array(
            'key' => 'group_64b2cfa518c4c',
            'title' => 'Push Press Releases',
            'fields' => array(
                array(
                    'key' => 'field_64b2cfa5f1df1',
                    'label' => 'EGPR To Push',
                    'name' => 'egpr_to_push',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_64b2cfb8f1df2',
                            'label' => 'URL',
                            'name' => 'url',
                            'aria-label' => '',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'parent_repeater' => 'field_64b2cfa5f1df1',
                        ),
                        array(
                            'key' => 'field_64b2cfc1f1df3',
                            'label' => 'Auth Header',
                            'name' => 'auth_header',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_64b2cfa5f1df1',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );

        acf_add_local_field_group( array(
            'key' => 'group_64b83c5a5b82d',
            'title' => 'Log',
            'fields' => array(
                array(
                    'key' => Press_Releases::LOG_KEY,
                    'label' => 'Message',
                    'name' => Press_Releases::LOG_KEY,
                    'aria-label' => '',
                    'type' => 'message',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'message' => '',
                    'new_lines' => 'wpautop',
                    'esc_html' => 0,
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 999,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );



    }






    public function add_settings_page() {

        if ( function_exists( 'acf_add_options_sub_page' ) ) {
            acf_add_options_sub_page(
                array(
                    'page_title'  => 'Press Releases',
                    'menu_title'  => 'Press Releases',
                    'menu_slug'   => self::SLUG,
                    'capability'  => 'edit_users',
                    'parent_slug' => 'options-general.php',
                )
            );
        }
    }

    public static function get( $key ) {

        if ( ! function_exists( 'get_field' ) ) {
            return;
        }

        return get_field( $key, 'options' );
    }

    public function log_output($field) {
        remove_filter('acf/load_field/name=' . Press_Releases::LOG_KEY, array($this, 'log_output'));


        $log = Settings::get(Press_Releases::LOG_KEY);
        add_filter('acf/load_field/name=' . Press_Releases::LOG_KEY, array($this, 'log_output'));
        if(!is_array($log)){
            $log = [];
        }
        $field['message'] = '<pre style="max-width:100%;overflow:auto;">' . implode('', $log) . '</pre>';

        return $field;
    }



}
