<?php

namespace EGPR;

/**
 * Class Rest_Server
 */
class Server extends \WP_Rest_Controller {

    public $namespace = 'egpr/';
    public $version = 'v1';


    public function init() {
        add_action( 'rest_api_init', array( $this, 'register_routes' ) );
    }


    public function register_routes() {
        $namespace = $this->namespace . $this->version;

        register_rest_route(
            $namespace,
            '/press',
            array(
                array(
                    'methods'  => \WP_REST_Server::CREATABLE,
                    'callback' => array( $this, 'create_press' ),
                    'permission_callback' => array( $this, 'get_users_permission' ),
                    'args' => array(


                    ),
                ),
            )
        );

        register_rest_route(
            $namespace,
            '/press',
            array(
                array(
                    'methods'  => \WP_REST_Server::READABLE,
                    'callback' => array( $this, 'get_press' ),
                    'permission_callback' => array( $this, 'get_users_permission' ),
                    'args' => array(


                    ),
                ),
            )
        );


    }



    public function get_press(\WP_REST_Request $request){
        $videos = Settings::get(Settings::VIDEO_FIELD);
        $links = Settings::get( Settings::LINK_FIELD);
        $videos = Utils::remap($videos);
        $links = Utils::remap($links);
        return $this->send_json_response(['links' => $links, 'videos' => $videos]);


    }

    public function create_press(\WP_REST_Request $request){

        $videos = $request->get_param( 'video' );
        $links = $request->get_param( 'links' );
        $videos = Utils::remap($videos);
        $links = Utils::remap($links);

        update_field(Settings::LINK_FIELD, $links, 'option');
        update_field(Settings::VIDEO_FIELD, $videos, 'option');

        return $this->send_json_response();

    }



    public function send_json_response($results, $success = true){
        $response = new \WP_REST_Response(
            array(
                'data' => array(
                    'success'  => $success,
                    'response' => $results,
                ),
            )
        );
        if(!$success){
            $response->set_status(400);
        }
        return $response;
    }

    /**
     * Is the user logged in?
     *
     * @return bool|WP_Error
     */
    public function get_users_permission() {

        return is_user_logged_in() && current_user_can('edit_posts');
    }




}
