<?php

namespace EGPR;

use EGPR\Data_Structures\Post_Types\Press_Releases;

class Utils {

    public static function get_link($field){

        if(!isset($field['url'] ) || !$field['url']) {
            return false;
        }
        $link['url']   = $field['url'];
        $link['title']   = $field['title'];
        $link['target'] = $field['target'] ?: '_self';
        return $link;
    }


    public static function get_link_properties($field){
        $link_data = self::get_link($field);
        return sprintf('href="%s" target="%s" rel="%s" title="%s"', esc_attr( $link_data['url'] ), esc_attr( $link_data['target'] ), strtolower($link_data['target']) === '_blank' ? 'noopener noreferrer' : '', esc_attr( wp_strip_all_tags( strip_shortcodes( $link_data['title'] ) ) ) );

    }

    public static function output(){


        global $wp_query;



        $prv_title = Settings::get('prv_title');
        $prv_load_more_text = Settings::get('prv_load_more_text');

        $pr_title = Settings::get('pr_title');
        $pr_load_more_text = Settings::get('pr_load_more_text');

        $content = '';





        if(get_query_var('paged') && get_query_var('eg_press_type')) {





            ?><div id="content"><?php
            $page = get_query_var('paged');
            $type = sanitize_title(get_query_var('eg_press_type'));

            if(!in_array($type, ['videos', 'links'])) {
                return;
            }

            $transient = 'pr_' . $type . '_remaining' . $page;
            if('videos' === $type){



                if( have_posts() ){
                    while(have_posts()) {
                        the_post();
                        self::single('videos');

                    }

                }
                $total_posts = $wp_query->found_posts;
                $total_pages = ceil(($total_posts - Press_Releases::get('POSTS_PER_PAGE_VIDEOS_PAGE_1')) / Press_Releases::get('POSTS_PER_PAGE_BEYOND_1_VIDEOS')) + 1;

                if($total_pages > $page){
                    ?><div class="press__load-more press__center " data-url="<?php echo trailingslashit(get_post_type_archive_link(Press_Releases::POST_TYPE)) . 'videos/page/' . (int)($page+1) . '/' ?>" data-type="videos"><span class="" role="button"><?php echo wp_kses_post($pr_load_more_text); ?></span></div><?php
                }



                return;
            }
            if('links' === $type) {


                $total_posts = $wp_query->found_posts;
                $total_pages = ceil(($total_posts - Press_Releases::get('POSTS_PER_PAGE_BEYOND_1_LINKS')) / Press_Releases::get('POSTS_PER_PAGE_BEYOND_1_LINKS')) + 1;


                if( have_posts() ){
                    while(have_posts()) {
                        the_post();
                        self::single('links');

                    }

                }
                if($total_pages > $page){
                    ?><div class="press__load-more press__center " data-url="<?php echo trailingslashit(get_post_type_archive_link(Press_Releases::POST_TYPE)) . 'links/page/' . (int)($page+1)  . '/'?>" data-type="links"><span class="" role="button"><?php echo wp_kses_post($pr_load_more_text); ?></span></div><?php
                }
            }





            ?></div><?php

            return;
        }

        $videos = new \WP_Query([
            'post_type' => Press_Releases::POST_TYPE,
            'posts_per_page' => Press_Releases::get('POSTS_PER_PAGE_VIDEOS_PAGE_1'),
            'meta_query' => [
                [
                    'key' => 'type',
                    'value' => 'videos'
                ]
            ]
        ]);
        $links = new \WP_Query([
            'post_type' => Press_Releases::POST_TYPE,
            'posts_per_page' => Press_Releases::get('POSTS_PER_PAGE_LINKS_PAGE_1'),
            'meta_query' => [
                [
                    'key' => 'type',
                    'value' => 'links'
                ]
            ]
        ]);




        ?>
        <div id="content">
        <div class="press">        <div class="press__videos">
                <h2 class="press__center press__title"><?php echo wp_kses_post($prv_title); ?></h2>
                <div class=" press__mobile-pad-x">
                    <div class="press__abbreviated press__flex press__flex-half-children videos">

                        <?php


                        if( $videos->have_posts() ){
                            while($videos->have_posts()) {
                                $videos->the_post();
                                self::single('videos');

                            }

                        }
                        ?>
                    </div>

                    <?php if (  $videos->found_posts > Press_Releases::get('POSTS_PER_PAGE_VIDEOS_PAGE_1')  ) : ?>
                        <div class="press__load-more press__center " data-url="<?php echo trailingslashit(get_post_type_archive_link(Press_Releases::POST_TYPE)) . 'videos/page/2' ?>" data-type="videos"><span class="" role="button"><?php echo wp_kses_post($prv_load_more_text); ?></span></div>
                    <?php endif; ?>



                </div>
            </div>
            <div class="press__itn">
                <h2 class="press__center press__title"><?php echo wp_kses_post($pr_title); ?></h2>
                <div class=" press__mobile-pad-x">
                    <div class="press__abbreviated press__flex links">
                        <?php
                        if( $links->have_posts() ){
                            while($links->have_posts()) {
                                $links->the_post();
                                self::single('links');

                            }

                        }
                        ?>
                    </div>
                </div>
                <?php if (  $links->found_posts > Press_Releases::get('POSTS_PER_PAGE_LINKS_PAGE_1')  ) : ?>
                    <div class="press__load-more press__center " data-url="<?php echo trailingslashit(get_post_type_archive_link(Press_Releases::POST_TYPE)) . 'links/page/2' ?>" data-type="links"><span class="" role="button"><?php echo wp_kses_post($pr_load_more_text); ?></span></div>
                <?php endif; ?>


            </div></div>
            <?php
        return $content;
    }

    public static function single($what) {
        if('links' === $what) {
            ?>
             <div class="press__flex press__full-width press__bottom-margin press__group-hover">
                <div class="press__one-fourth--above-mobile press__flex press__center-y press_thumb press__full-width-center--mobile hover">
                    <a href="<?php the_permalink(); ?>" rel="noopener noreferrer">
                        <?php the_post_thumbnail('255x205', ['class' => 'press-image']); ?>
                    </a>
                </div>
                <div class="press__three-fourths--above-mobile press__center-y press__flex press__full-width-center--mobile hover">
                    <div class=" press__pad-x press__flex press__center-x press__flex-col">
                        <div class="press__date"><?php the_date('F j, Y') ?></div>
                        <div class="press__title press__post-title"><?php the_title(); ?></div>
                        <div class="press__button"><a class="" href="<?php the_permalink(); ?>">Read More</a></div>
                    </div>
                </div>
            </div>
            <?php
        }
        if('videos' === $what) {
            ?>
            <div class="press-hover-opacity press-mb">
                <div>
                    <a class="press__flex press__center-x press__center-y press-center mobile-margin" href="<?php the_permalink(); ?>" target="_blank" rel="noopener noreferrer" rel="" title="<?php the_title(); ?>">
                        <?php the_post_thumbnail('525x300', ['class' => 'press-image']); ?>
                        <h3 class="press__no-margin press__post-title"><?php the_title(); ?></h3>
                    </a>
                </div>
            </div>
            <?php
        }
    }

    public static function clear_log(){
        update_field(Press_Releases::LOG_KEY, [], 'option');
    }

    public static function log($message){

        if(!is_string($message)){
            $message = print_r($message, true);
        }
        $message = date('Y-m-d H:i:s') . ' ' . $message . "\n";
        $log = (array)get_field(Press_Releases::LOG_KEY, 'option');
        $log[] = $message;
        $log = array_slice($log, -500);
        update_field(Press_Releases::LOG_KEY, $log, 'option');
    }

    public static function get_endpoints(){
        $egpr_to_push = Settings::get('egpr_to_push');
        return $egpr_to_push;

    }




}
