<?php

namespace EGPR;

use EGPR\Base\Thing;

class Settings extends Thing {

    const SLUG = 'egpr';

    public function attach_hooks() {

        add_action('init', array($this, 'add_settings_page'));

        add_action('acf/save_post', array($this, 'fire_on_save'), 20);

        add_action('acf/include_fields',  array($this, 'settings_fields'));
    }

    public function settings_fields() {
        if ( ! function_exists( 'acf_add_local_field_group' ) ) {
            return;
        }

        acf_add_local_field_group( array(
            'key' => 'group_649354422766a',
            'title' => 'Press Releases',
            'fields' => array(
                array(
                    'key' => 'field_6493fasdff6cfd1',
                    'label' => 'Press Releases Videos',
                    'name' => '',
                    'aria-label' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_6493545267030',
                    'label' => 'Title',
                    'name' => 'prv_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Press Release Videos',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_6493568d67031',
                    'label' => 'Number to show before "Load More"',
                    'name' => 'prv_number_to_show_before_load_more',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 2,
                    'min' => 0,
                    'max' => '',
                    'placeholder' => '',
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_649356a867032',
                    'label' => 'Load More Text',
                    'name' => 'prv_load_more_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Load More',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_649356cf67033',
                    'label' => 'Videos',
                    'name' => 'prv_videos',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Video',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_649356e767034',
                            'label' => 'Image',
                            'name' => 'image',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'id',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                            'parent_repeater' => 'field_649356cf67033',
                        ),
                        array(
                            'key' => 'field_649356f567035',
                            'label' => 'Link',
                            'name' => 'link',
                            'aria-label' => '',
                            'type' => 'link',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'array',
                            'parent_repeater' => 'field_649356cf67033',
                        ),
                    ),
                ),
                array(
                    'key' => 'field_64935sdf6cfd1',
                    'label' => 'Press Releases',
                    'name' => '',
                    'aria-label' => '',
                    'type' => 'tab',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'placement' => 'top',
                    'endpoint' => 0,
                ),
                array(
                    'key' => 'field_64935442dccbf',
                    'label' => 'Title',
                    'name' => 'pr_title',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'In the News',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_64935484dccc0',
                    'label' => 'Number to show before "Load More"',
                    'name' => 'pr_number_to_show_before_load_more',
                    'aria-label' => '',
                    'type' => 'number',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 8,
                    'min' => '',
                    'max' => '',
                    'placeholder' => '',
                    'step' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_649354a8dccc1',
                    'label' => 'Load More Text',
                    'name' => 'pr_load_more_text',
                    'aria-label' => '',
                    'type' => 'text',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'default_value' => 'Load More',
                    'maxlength' => '',
                    'placeholder' => '',
                    'prepend' => '',
                    'append' => '',
                ),
                array(
                    'key' => 'field_649354b6dccc2',
                    'label' => 'Links',
                    'name' => 'pr_links',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'block',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Press Release',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_649354bfdccc3',
                            'label' => 'Image',
                            'name' => 'image',
                            'aria-label' => '',
                            'type' => 'image',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'return_format' => 'id',
                            'library' => 'all',
                            'min_width' => '',
                            'min_height' => '',
                            'min_size' => '',
                            'max_width' => '',
                            'max_height' => '',
                            'max_size' => '',
                            'mime_types' => '',
                            'preview_size' => 'medium',
                            'parent_repeater' => 'field_649354b6dccc2',
                        ),
                        array(
                            'key' => 'field_649354dadccc4',
                            'label' => 'URL',
                            'name' => 'url',
                            'aria-label' => '',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'parent_repeater' => 'field_649354b6dccc2',
                        ),
                        array(
                            'key' => 'field_649354e8dccc5',
                            'label' => 'Date',
                            'name' => 'date',
                            'aria-label' => '',
                            'type' => 'date_picker',
                            'instructions' => '',
                            'required' => 1,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'display_format' => 'm/d/Y',
                            'return_format' => 'U',
                            'first_day' => 1,
                            'parent_repeater' => 'field_649354b6dccc2',
                        ),
                        array(
                            'key' => 'field_649355d4dccc6',
                            'label' => 'Title',
                            'name' => 'title',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_649354b6dccc2',
                        ),
                    ),
                ),

            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
            'is_acf_component' => 0,
            'acf_component_defaults' => array(
                'layout' => 'block',
                'repeatable' => '0',
                'pagination' => '0',
                'rows_per_page' => '20',
                'min' => '',
                'max' => '',
                'button_label' => '',
                'appearances' => '',
            ),
        ) );

        acf_add_local_field_group( array(
            'key' => 'group_64b2cfa518c4c',
            'title' => 'Push Press Releases',
            'fields' => array(
                array(
                    'key' => 'field_64b2cfa5f1df1',
                    'label' => 'EGPR To Push',
                    'name' => 'egpr_to_push',
                    'aria-label' => '',
                    'type' => 'repeater',
                    'instructions' => '',
                    'required' => 0,
                    'conditional_logic' => 0,
                    'wrapper' => array(
                        'width' => '',
                        'class' => '',
                        'id' => '',
                    ),
                    'layout' => 'table',
                    'pagination' => 0,
                    'min' => 0,
                    'max' => 0,
                    'collapsed' => '',
                    'button_label' => 'Add Row',
                    'rows_per_page' => 20,
                    'sub_fields' => array(
                        array(
                            'key' => 'field_64b2cfb8f1df2',
                            'label' => 'URL',
                            'name' => 'url',
                            'aria-label' => '',
                            'type' => 'url',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'placeholder' => '',
                            'parent_repeater' => 'field_64b2cfa5f1df1',
                        ),
                        array(
                            'key' => 'field_64b2cfc1f1df3',
                            'label' => 'Auth Header',
                            'name' => 'auth_header',
                            'aria-label' => '',
                            'type' => 'text',
                            'instructions' => '',
                            'required' => 0,
                            'conditional_logic' => 0,
                            'wrapper' => array(
                                'width' => '',
                                'class' => '',
                                'id' => '',
                            ),
                            'default_value' => '',
                            'maxlength' => '',
                            'placeholder' => '',
                            'prepend' => '',
                            'append' => '',
                            'parent_repeater' => 'field_64b2cfa5f1df1',
                        ),
                    ),
                ),
            ),
            'location' => array(
                array(
                    array(
                        'param' => 'options_page',
                        'operator' => '==',
                        'value' => self::SLUG,
                    ),
                ),
            ),
            'menu_order' => 0,
            'position' => 'normal',
            'style' => 'default',
            'label_placement' => 'top',
            'instruction_placement' => 'label',
            'hide_on_screen' => '',
            'active' => true,
            'description' => '',
            'show_in_rest' => 0,
        ) );

    }






    public function add_settings_page() {

        if ( function_exists( 'acf_add_options_sub_page' ) ) {
            acf_add_options_sub_page(
                array(
                    'page_title'  => 'Press Releases',
                    'menu_title'  => 'Press Releases',
                    'menu_slug'   => self::SLUG,
                    'capability'  => 'edit_users',
                    'parent_slug' => 'options-general.php',
                )
            );
        }
    }

    public static function get( $key ) {

        if ( ! function_exists( 'get_field' ) ) {
            return;
        }

        return get_field( $key, 'option' );
    }

    public function fire_on_save($post_id) {
        // Check if the saved post is the global setting page
        if (get_post_type($post_id) === 'acf-field-group') {
            $field_group = acf_get_field_group($post_id);

            // Check if the field group's location matches the global setting page
            if (
                isset($field_group['location'])
                && is_array($field_group['location'])
                && count($field_group['location']) === 1
                && count($field_group['location'][0]) === 1
                && $field_group['location'][0][0]['param'] === 'options_page'
                && $field_group['location'][0][0]['operator'] === '=='
                && $field_group['location'][0][0]['value'] === self::SLUG
            ) {
                $links = Settings::get('field_649354b6dccc2');
                $videos = Settings::get('field_649356cf67033');

                $url = 'https://theknewmethod.com/wp-json/egpr/v1/press';

// Set the headers
                $headers = array(
                    'Authorization' => 'Basic ' . base64_encode('mat:RTdm VBs6 fxtp 5IKm YA0K 2KoM'),
                );

// Set the request body
                $body = array(
                    'links' => $links,
                    'video' => $videos,
                );

// Prepare the request arguments
                $args = array(
                    'headers' => $headers,
                    'body'    => $body,
                );

// Send the POST request
                $response = wp_remote_post($url, $args);

// Check the response
                if (is_wp_error($response)) {
                    $error_message = $response->get_error_message();
                    ob_start();
                    echo "Something went wrong: $error_message";
                    error_log(ob_get_clean());
                } else {
                    $response_code = wp_remote_retrieve_response_code($response);
                    $response_body = wp_remote_retrieve_body($response);
                    ob_start();
                    var_dump($response_body);
                    error_log('111');
                    error_log(ob_get_clean());
                    ob_start();
                    echo "Response code: $response_code\n";
                    echo "Response body: $response_body\n";
                    error_log(ob_get_clean());
                }
            }
        }
    }




}
