<?php

namespace EGPR\Queue;


use EGPR\Data_Structures\Post_Types\Press_Releases\Factory;
use EGPR\Data_Structures\Post_Types\Press_Releases\Rest;
use EGPR\Utils;


/**
 * We use wp background process to address the nonce issue caused by WP_Async_Task.
 */

class Ingest_Process extends \WP_Background_Process {
    /**
     * @var string
     */
    protected $action = 'swpr-ingest-generator';

    /**
     * Task
     *
     * Override this method to perform any actions required on each
     * queue item. Return the modified item for further processing
     * in the next pass through. Or, return false to remove the
     * item from the queue.
     *
     * @param mixed $emails_object Queue item to iterate over
     *
     * @return mixed
     */
    protected function task( $request )
    {


        if (empty($request['method'])) {
            Utils::log('Ingest_Process::task() - method parameter does not exist');
            return false;
        }

        if(empty($request['body'])) {
            Utils::log('Ingest_Process::task() - body parameter does not exist');
            return false;
        }

        extract($request);
		Utils::log('Ingest_Process::task() - method: ' . $method);
		Utils::log(array_keys($request));
        $factory = new Factory($body, $method);
        $factory->execute();


        return false;
    }


    /**
     * Complete
     *
     * Override if applicable, but ensure that the below actions are
     * performed, or, call parent::complete().
     */
    protected function complete() {
        parent::complete();
        Utils::log('shutting down');

        // Show notice to user or perform some other arbitrary task...
    }


}