<?php

namespace EGPR;

use EGPR\Base\Thing;
use EGPR\Data_Structures\Post_Types\Press_Releases\Ajax;
use EGPR\Data_Structures\Post_Types\Press_Releases\Register;

class Enqueues extends Thing {



    public function attach_hooks() {

        add_action('wp_enqueue_scripts', array($this, 'register_scripts'), 1);

    }

    public function register_scripts(){
        wp_enqueue_script( 'egpr', EGPR_BLOCKS_URL . 'js/script.js',['jquery'], filemtime(trailingslashit(EGPR_BLOCKS_PATH) . 'js/script.js'), true );
        wp_enqueue_style( 'egpr', EGPR_BLOCKS_URL . 'css/style.css', [], filemtime(trailingslashit(EGPR_BLOCKS_PATH) . 'css/style.css'));
        wp_localize_script( 'egpr', 'egpr',
            array(
                'nonce' => wp_create_nonce(Ajax::NONCE_KEY),
                'ajax_url' => admin_url('admin-ajax.php'),
            )
        );


    }


}
