<?php

namespace EGPR\Data_Structures\Post_Types\Press_Releases;

use EGPR\Base\Thing;
use EGPR\Utils;

class Factory {

    private $body = null;
    private $method = null;
    private $error = null;
    private $status = null;



    // statuses

    const STATUS_UPSERTING = 'upserting';
    const STATUS_CREATING = 'creating';
    const STATUS_UPDATING = 'updating';
    const STATUS_TRASHING = 'trashing';
    const STATUS_ERROR = 'error';
    const STATUS_SUCCESS = 'success';



    public function __construct($body, $method){
        $this->body = $body;
        $this->method = $method;

    }

    public function get_error(){
        return $this->error;
    }
    public function get_status(){
        return $this->status;
    }



    private function set_error($error){
        $this->set('error', $error);

    }



    private function set_status($status){
        $this->set('status', $status);

    }

    private function set($set_what, $to_what) {
        Utils::log('=== Status Update ===');
	    if(!$to_what) {
		    $to_what = ' null ';
	    }
        switch($set_what):
            case 'status':

                Utils::log('Setting status to ' . $to_what);
                $this->status = $to_what;
                break;
            case 'error':

                Utils::log('Setting status to ' . $to_what);
				$this->error = $to_what;
                break;
            default:
                Utils::log('Cannot perform status update: setting ' . $set_what . ' to ' . $to_what);
                break;
        endswitch;
        Utils::log('=== End Status Update ===');

    }



    public function execute(): void {
        $this->set_error(null);
        $this->set_status(null);
        if('upsert' === $this->method) {
            $this->set_status(self::STATUS_UPSERTING);
            $this->upsert();
        }
        if('trash' === $this->method) {
            $this->set_status(self::STATUS_TRASHING);
            $this->trash();
        }
    }

    private function upsert() {

        $exists = get_posts([
            'post_type' => Register::POST_TYPE,
            'meta_query' => [
                [
                    'key' => 'source_post_id',
                    'value' => $this->body['source_post_id'],
                ]
            ]
        ]);

        $title = $this->body['title'];
        $date = $this->body['date'];
        $image_base64 = $this->body['image_base64'];
        $image_url = $this->body['image_url'];
        $source_post_id = $this->body['source_post_id'];
        $type = $this->body['type'];
        $url = $this->body['url'];

        if(is_array($exists) && count($exists) > 0){
            $this->set_status(self::STATUS_UPDATING);

            Utils::log('Updating post ' . $title . ' with source post id of ' . $source_post_id);
            $post_id = $exists[0]->ID;
            wp_update_post(array(
                'ID' => $post_id,
                'post_title' => $title,
                'post_type' => Register::POST_TYPE,
                'post_status' => 'publish',
                'post_date' => $date,
            ));
            if($image_base64){
                $image_id = Utils::set_image($image_base64, $title, $image_url);
                set_post_thumbnail($post_id, $image_id);
            } else {
                Utils::log('No image for ' . $title);
            }



            $this->set_status(self::STATUS_SUCCESS);
            return;
        }
        $this->set_status(self::STATUS_CREATING);
        Utils::log('Creating post ' . $title);

        $post_id = wp_insert_post(array(
            'post_title' => $title,
            'post_type' => Register::POST_TYPE,
            'post_status' => 'publish',
            'post_date' => $date,
        ));
        if ( is_wp_error( $post_id ) ) {
            Utils::log('Error creating post ' . $title . ' ' . $post_id->get_error_message());
            $this->set_error($post_id->get_error_message());
            $this->set_status(self::STATUS_ERROR);

            return;
        }

        if($image_base64){
            $image_id = Utils::set_image($image_base64, $title, $image_url);
            set_post_thumbnail($post_id, $image_id);
        }
        Utils::log('Setting meta for ' . $title);
        update_field('source_post_id', $source_post_id, $post_id);
        update_field('url', $url, $post_id);
        update_field(Settings::PRESS_RELEASES_TYPE_KEY, $type, $post_id);

        $this->set_status(self::STATUS_SUCCESS);
    }

    private function trash(){
        $this->set_status(self::STATUS_UPSERTING);

        $source_post_id = $this->body['source_post_id'];
        $action = $this->body['action'];
        $untrash_to_future_status = $this->body['untrash_to_future_status'];

        Utils::log(sprintf('Trash action: %s for source post id of %s', $action, $source_post_id));
        $exists = get_posts([
            'post_type' => Register::POST_TYPE,
            'meta_query' => [
                [
                    'key' => 'source_post_id',
                    'value' => $source_post_id,
                ]
            ],
            'posts_per_page' => 1,
        ]);
        if(empty($exists)){
            $error = sprintf('No press release found for source post id of %s', $source_post_id);
			Utils::
            Utils::log($error);
            $this->set_error($error);
            return;
        }
        $post_id = $exists[0]->ID;
        Utils::log('Title for the post where trash action ' . $action . ' for post id ' . $post_id . ' with title ' . get_the_title($post_id));

        switch($action):
            case 'trash':
                Utils::log('Trashing post ' . $post_id);
                $result = wp_trash_post($post_id);
                Utils::log('Result of trashing post ' . !!$result ? 'success' : 'failure');
                if($untrash_to_future_status) {
                    $post = get_post($post_id);
                    $post->post_status = $untrash_to_future_status;
                    wp_update_post($post);
                }
                break;
            case 'untrash':
                Utils::log('Untrashing post ' . $post_id);
                $result = wp_untrash_post($post_id);
                Utils::log('Result of untrashing post ' . !!$result ? 'success' : 'failure');
                break;
            case 'delete':
                $result = wp_delete_post($post_id, true);
                Utils::log('Result of deleting post ' . !!$result ? 'success' : 'failure');
                break;
            default:
                break;

        endswitch;
        $this->set_status(self::STATUS_SUCCESS);
    }


}