<?php
/*
Plugin Name:  Press Releases
Plugin URI:   https://statenweb.com
Author:       StatenWeb
Author URI:   https://statenweb.com
Description:  Press Releases
Version:      4.5

//
// **********************************************************************
// This program is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
// **********************************************************************
*/


use EGPR\Images_Utils;
use EGPR\Queue\Post_Creator_Manager;

require __DIR__ . '/vendor/autoload.php';

$namespace = ['EGPR'];

define('EGPR_BLOCKS_URL', plugin_dir_url( __FILE__ ));
define('EGPR_BLOCKS_PATH', plugin_dir_path( __FILE__ ));

\spl_autoload_register(
    function ( $class ) use ( $namespace ) {
        $base = explode( '\\', $class );
        if ( in_array( $base[0], $namespace ) ) {
            $file = __DIR__ . DIRECTORY_SEPARATOR . strtolower(
                    str_replace(
                        [ '\\', '_' ],
                        [
                            DIRECTORY_SEPARATOR,
                            '-',
                        ],
                        $class
                    ) . '.php'
                );
            if ( file_exists( $file ) ) {
                require $file;
            } else {
ob_start();
debug_print_backtrace();
$x = ob_get_clean();
                echo( sprintf( 'File %s not found<pre>' .$x, esc_html( $file ) ) );
die;
            }
        }

    }
);


function eg_render_callback( $block ) {
    // convert name ("acf/testimonial") into path friendly slug ("testimonial")
    $slug = str_replace( 'acf/', '', $block['name'] );
    $path = plugin_dir_path( __FILE__ ) . "templates/{$slug}.php";

    if ( file_exists( $path ) ) {
        include $path;
    }

}

$enqueues = new \EGPR\Enqueues();
$enqueues->init();
$settings = new \EGPR\Settings();
$settings->init();
$press_releases = new \EGPR\Data_Structures\Post_Types\Press_Releases();
$press_releases->init();
$actions = new \EGPR\Actions();
$actions->init();

$filters = new \EGPR\Filters();
$filters->init();
$server = new \EGPR\Server();
$server->init();


$post_creator_manager = new Post_Creator_Manager();
$post_creator_manager->init();
