<?php

namespace EGPR;

class Utils {

    public static function get_link($field){

        if(!isset($field['url'] ) || !$field['url']) {
            return false;
        }
        $link['url']   = $field['url'];
        $link['title']   = $field['title'];
        $link['target'] = $field['target'] ?: '_self';
        return $link;
    }


    public static function get_link_properties($field){
        $link_data = self::get_link($field);
        return sprintf('href="%s" target="%s" rel="%s" title="%s"', esc_attr( $link_data['url'] ), esc_attr( $link_data['target'] ), strtolower($link_data['target']) === '_blank' ? 'noopener noreferrer' : '', esc_attr( wp_strip_all_tags( strip_shortcodes( $link_data['title'] ) ) ) );

    }

    public static function output(){

        $prv_title = Settings::get('prv_title');
        $prv_number_to_show_before_load_more = Settings::get('prv_number_to_show_before_load_more');
        $prv_load_more_text = Settings::get('prv_load_more_text');
        $prv_videos = Settings::get('prv_videos');
        // initialize
        $first_set_of_prv_videos = $prv_videos;
        $remaining_set_of_prv_videos = [];
        if((int)$prv_number_to_show_before_load_more > 0){
            $first_set_of_prv_videos = array_slice($prv_videos, 0, $prv_number_to_show_before_load_more);
            $remaining_set_of_prv_videos = array_slice($prv_videos, $prv_number_to_show_before_load_more);
        }


        $first_set_of_videos_content = [];
        $remaining_set_of_prv_videos_content = [];

        foreach(array_filter( (array)$first_set_of_prv_videos ) as $prv_video) {
            $image = wp_get_attachment_image( $prv_video['image'], 'full' );
            $link = $prv_video['link'];
            $title = $link['title'];
            $first_set_of_videos_content[] = str_replace(['{title}' , '{image}', '{link_properties}'], [$title, $image, self::get_link_properties($link)], Templates::video_single());
        }

        foreach(array_filter( (array)$remaining_set_of_prv_videos ) as $prv_video) {
            $image = wp_get_attachment_image( $prv_video['image'], 'full' );
            $link = $prv_video['link'];
            $title = $link['title'];
            $remaining_set_of_prv_videos_content[] = str_replace(['{title}' , '{image}', '{link_properties}'], [$title, $image, self::get_link_properties($link)], Templates::video_single());
        }

        $load_more = Templates::load_more();;
        $number_videos = count($prv_videos);
        if($prv_number_to_show_before_load_more > 0 && $prv_number_to_show_before_load_more <= $number_videos) {
            $load_more = str_replace(['{button_class}'], [apply_filters('eg_pr_button_class', '')], Templates::load_more());
        }
        $videos_abbreviated = str_replace(['{content}', '{load_more}'], [implode('', $first_set_of_videos_content), str_replace(['{text}'],[$prv_load_more_text], $load_more)], Templates::videos_abbreviated());
        $videos_leftover = str_replace(['{content}'], [implode('', $remaining_set_of_prv_videos_content)], Templates::videos_leftover());
        $video_content = $videos_abbreviated . $videos_leftover;

        $content = str_replace(['{title}', '{content}'], [$prv_title, $video_content], Templates::videos());



        $pr_title = Settings::get('pr_title');
        $pr_number_to_show_before_load_more = Settings::get('pr_number_to_show_before_load_more');
        $pr_load_more_text = Settings::get('pr_load_more_text');
        $pr_links = (array)Settings::get('pr_links');


        // initialize
        $first_set_of_pr_links = $pr_links;
        $remaining_set_of_pr_links = [];
        if((int)$pr_number_to_show_before_load_more > 0){
            $first_set_of_pr_links = array_slice($pr_links, 0, $pr_number_to_show_before_load_more);
            $remaining_set_of_pr_links = array_slice($pr_links, $pr_number_to_show_before_load_more);
        }


        $first_set_of_pr_content = [];
        $remaining_set_of_pr_links_content = [];

        foreach(array_filter( (array)$first_set_of_pr_links ) as $pr) {
            $image = wp_get_attachment_image( $pr['image'], 'full' );
            $url = $pr['url'];
            $date = date('F j, Y', $pr['date']);
            $title = $pr['title'];

            $first_set_of_pr_content[] = str_replace(
                ['{image}', '{url}', '{date}', '{title}', '{link_properties}', '{read_more}','{button_class}'],
                [$image,$url, $date, $title, '', 'Read More', apply_filters('eg_pr_button_class', '')], Templates::press_release_single());
        }

        foreach(array_filter( (array)$remaining_set_of_pr_links ) as $pr) {
            $image = wp_get_attachment_image( $pr['image'], 'full' );
            $url = $pr['url'];
            $date = date('F j, Y', $pr['date']);
            $title = $pr['title'];

            $remaining_set_of_pr_links_content[] = str_replace(
                ['{image}', '{url}', '{date}', '{title}', '{link_properties}', '{read_more}','{button_class}'],
                [$image,$url, $date, $title, '', 'Read More', apply_filters('eg_pr_button_class', '')], Templates::press_release_single());
        }

        $load_more = '';
        $number_pr_links = count($pr_links);
        if($pr_number_to_show_before_load_more > 0 && $pr_number_to_show_before_load_more <= $number_pr_links) {
            $load_more = str_replace(['{button_class}'], [apply_filters('eg_pr_button_class', '')], Templates::load_more());
        }

        $prs_abbreviated = str_replace(['{content}', '{load_more}'], [implode('', $first_set_of_pr_content), str_replace(['{text}'],[$pr_load_more_text], $load_more)], Templates::press_releases_abbreviated());
        $prs_leftover = str_replace(['{content}'], [implode('', $remaining_set_of_pr_links_content)], Templates::press_releases_leftover());
        $pr_content = $prs_abbreviated . $prs_leftover;

        $content .= str_replace(['{title}', '{content}'], [$pr_title, $pr_content], Templates::press_releases());


        $content = str_replace('{content}', $content, Templates::outer_wrap());
        return $content;
    }


}
