<?php

namespace EGPR\Blocks;

use EGPR\Base\Thing;

class Press_Releases extends Thing {

	public function attach_hooks() {
		if ( function_exists( 'acf_register_block_type' ) ) {
			add_action( 'acf/init', array( $this, 'register' ) );
		}
	}

	public function register() {

		acf_register_block_type(
			array(
				'name'            => 'eg-press-releases',
				'title'           => __( 'EG Press Releases' ),
				'description'     => __( 'EG Press Releases' ),
				'render_callback' => 'eg_render_callback',
				'category'        => 'common',

				'keywords'        => array( 'Press Releases' ),
				'align'           => 'center',
				'mode' 			  => 'edit',
                'example'  => array(
                    'attributes' => array(
                        'mode' => 'preview',
                        'data' => array(
                            'preview_image_help' => true,
                        )
                    )
                )
			)
		);
	}

}
