<?php

namespace PixelYourSite;

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

?>

<h2 class="section-title">Pinterest Settings</h2>

<!-- General -->
<div class="card card-static">
    <div class="card-header">
        General
    </div>
    <div class="card-body">
        <div class="row mb-3">
            <div class="col">
				<?php Pinterest()->render_switcher_input( 'enabled' ); ?>
                <h4 class="switcher-label">Enable Pinterest Pixel</h4>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col">
				<?php Pinterest()->render_switcher_input( 'enhanced_matching_enabled' ); ?>
                <h4 class="switcher-label">Enable Enhanced Matching</h4>
            </div>
        </div>
        <div class="row mb-3">
            <div class="col">
                <?php Pinterest()->render_switcher_input( "disable_noscript"); ?>
                <h4 class="switcher-label">Disable noscript</h4>
            </div>
        </div>
        <hr>
        <div class="row">
            <div class="col mb-2">
                <h4 class="switcher-label">Fire the PageVisit event on:</h4>
            </div>
        </div>
        <?php if ( isWooCommerceActive() ) : ?>
            <div class="row">
                <div class="col">
                    <?php Pinterest()->render_switcher_input( 'page_view_woo_products_pages' ); ?>
                    <h4 class="switcher-label">WooCommerce products pages</h4>
                </div>
            </div>
        <?php endif; ?>
		<?php if ( isEddActive() ) : ?>
            <div class="row">
                <div class="col">
                    <?php Pinterest()->render_switcher_input( 'page_view_edd_products_pages' ); ?>
                    <h4 class="switcher-label">Easy Digital Downloads product pages</h4>
                </div>
            </div>
		<?php endif; ?>
        <div class="row">
            <div class="col">
				<?php Pinterest()->render_switcher_input( 'page_view_post_enabled' ); ?>
                <h4 class="switcher-label">Posts</h4>
            </div>
        </div>
        <div class="row">
            <div class="col">
				<?php Pinterest()->render_switcher_input( 'page_view_page_enabled' ); ?>
                <h4 class="switcher-label">Pages</h4>
            </div>
        </div>
        <div class="row">
            <div class="col mt-2">
                <label>Custom Post Type:</label>
                <input type="checkbox" class="custom-control-input"
                       name="pys[pinterest][page_view_custom_post_enabled][-1]" value="0" checked/>
                <div class="custom-controls-stacked ml-2">
					<?php
					$args = array(
						'public' => true
					);
					$exclude = array(
						"post",
						"page"
					);
					if ( isWooCommerceActive() ) {
						$exclude[] = "product";
					}
					if ( isEddActive() ) {
						$exclude[] = "download";
					}
					$post_types = get_post_types( $args, 'objects' );
					foreach ( $post_types as $type ) {
						if ( in_array( $type->name, $exclude ) ) continue;
						?>
                        <div class="form-inline"><?php
						Pinterest()->render_switcher_input_array( 'page_view_custom_post_enabled', $type->name );
						?><h4 class="switcher-label"><?= $type->label ?></h4></div><?php
					}
					?>
                </div>
            </div>
        </div>
    </div>
</div>

<hr>
<div class="row justify-content-center">
    <div class="col-4">
        <button class="btn btn-block btn-sm btn-save">Save Settings</button>
    </div>
</div>