<?php

namespace PixelYourSite;

require_once PYS_PINTEREST_PATH . '/modules/pinterest/pinterest-server-async-task.php';

use PixelYourSite;

if ( !defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class PinterestServer {

	private static $_instance;
	private        $access_token;
	private        $isDebug;
	private        $woo_order = 0;
	private        $edd_order = 0;

	public static function instance() {

		if ( is_null( self::$_instance ) ) {
			self::$_instance = new self();
		}

		return self::$_instance;
	}

	public function __construct() {

		$this->isDebug = PYS()->getOption( 'debug_enabled' );

		add_action( 'wp_ajax_pys_pinterest_api_event', array(
			$this,
			"catchPinterestAjaxEvent"
		) );
		add_action( 'wp_ajax_nopriv_pys_pinterest_api_event', array(
			$this,
			"catchPinterestAjaxEvent"
		) );
		/*add_action( 'woocommerce_add_to_cart', array(
			$this,
			'trackAddToCartEvent'
		), 40, 4 );*/

		// initialize pinterest event async task
		new PinterestAsyncTask();

	}

	/**
	 * Send event in shutdown hook (not work in ajax)
	 * @param SingleEvent[] $events
	 */
	public function sendEventsAsync( $events ) {

		$serverEvents = array();

		foreach ( $events as $event ) {

			if ( empty( $event->payload[ 'eventID' ] ) ) {
				$token = Pinterest\pys_generate_token();
			} else {
				$token = $event->payload[ 'eventID' ];
			}

			$serverEvents[] = $this->dataToSingleEvent( $event->payload[ 'name' ], $event->params, $token, $event->payload[ 'pixelIds' ], '', '' );
		}

		if ( count( $serverEvents ) > 0 ) {
			do_action( 'pys_send_pinterest_server_event', $serverEvents );
		}
	}

	/**
	 * Send Event Now
	 *
	 * @param SingleEvent[] $events
	 */
	public function sendEventsNow( $events ) {

		foreach ( $events as $event ) {
			$serverEvent = $this->mapEventToServerEvent( $event );
			$ids = $event->payload[ 'pixelIds' ];

			$this->sendEvent( $ids, $serverEvent );
		}
	}

	function trackAddToCartEvent( $cart_item_key, $product_id, $quantity, $variation_id ) {

		if ( EventsWoo()->isReadyForFire( "woo_add_to_cart_on_button_click" ) && PYS()->getOption( 'woo_add_to_cart_catch_method' ) == "add_cart_js" ) {
			// it ok. We send server method after js, and take event id from cookies
			Pinterest()->getLog()->debug( ' trackAddToCartEvent send Pinterest server without browser event' );

			if ( !empty( $variation_id ) && $variation_id > 0 && ( !Pinterest()->getOption( 'woo_variable_as_simple' ) ) ) {
				$_product_id = $variation_id;
			} else {
				$_product_id = $product_id;
			}

			$event = new SingleEvent( "woo_add_to_cart_on_button_click", EventTypes::$DYNAMIC, 'woo' );
			$event->args = [
				'productId' => $_product_id,
				'quantity'  => $quantity
			];
			$event->params[ 'uri' ] = self::getRequestUri( PYS()->getOption( 'enable_remove_source_url_params' ) );

			add_filter( 'pys_conditional_post_id', function ( $id ) use ( $product_id ) {
				return $product_id;
			} );
			$events = Pinterest()->generateEvents( $event );
			remove_all_filters( 'pys_conditional_post_id' );

			foreach ( $events as $singleEvent ) {

				if ( isset( $_COOKIE[ "pys_pinterest_event_id" ] ) ) {
					$singleEvent->payload[ 'eventID' ] = json_decode( stripslashes( $_COOKIE[ "pys_pinterest_event_id" ] ) )->AddToCart;
				}
			}

			do_action( 'pys_send_pinterest_server_event', $events );
		}
	}

	/**
	 * If server message is blocked by gprg or it dynamic
	 * we send data by ajax request from js and send the same data like browser event
	 */
	function catchPinterestAjaxEvent() {

		Pinterest()->getLog()->debug( ' catchPinterestAjaxEvent send to Pinterest server from ajax' );
		$event = $_POST[ 'event' ];
		$data = isset( $_POST[ 'data' ] ) ? $_POST[ 'data' ] : array();
		$ids = $_POST[ 'ids' ];
		$eventID = $_POST[ 'eventID' ];
		$wooOrder = isset( $_POST[ 'woo_order' ] ) ? $_POST[ 'woo_order' ] : null;
		$eddOrder = isset( $_POST[ 'edd_order' ] ) ? $_POST[ 'edd_order' ] : null;

		if ( empty( $_REQUEST[ 'ajax_event' ] ) || !wp_verify_nonce( $_REQUEST[ 'ajax_event' ], 'ajax-event-nonce' ) ) {
			wp_die();
			return;
		}

		if ( $event == "hCR" ) $event = "CompleteRegistration"; // de mask completer registration event if it was hidden

		$singleEvent = $this->dataToSingleEvent( $event, $data, $eventID, $ids, $wooOrder, $eddOrder );

		$this->sendEventsNow( [ $singleEvent ] );

		wp_die();
	}

	/**
	 * @param $eventName
	 * @param $params
	 * @param $eventID
	 * @param $ids
	 * @param $wooOrder
	 * @param $eddOrder
	 * @return SingleEvent
	 */
	private function dataToSingleEvent( $eventName, $params, $eventID, $ids, $wooOrder, $eddOrder ) {
		$singleEvent = new SingleEvent( "", "" );

		$payload = [
			'name'      => $eventName,
			'eventID'   => $eventID,
			'woo_order' => $wooOrder,
			'edd_order' => $eddOrder,
			'pixelIds'  => $ids
		];
		$singleEvent->addParams( $params );
		$singleEvent->addPayload( $payload );

		return $singleEvent;
	}


	/**
	 * Send event for each pixel id
	 * @param array $pixel_Ids //array of facebook ids
	 * @param $event //One Facebook event object
	 */
	function sendEvent( $pixel_Ids, $event ) {

		if ( !$event || apply_filters( 'pys_disable_server_event_filter', false ) ) {
			return;
		}

		if ( !$this->access_token ) {
			$this->access_token = Pinterest()->getApiTokens();
		}

		foreach ( $pixel_Ids as $pixel_Id ) {

			if ( !Pinterest()->enabled() || empty( $this->access_token[ $pixel_Id ] || empty( $this->access_token[ $pixel_Id ][ 'server_id' ] ) ) || empty( $this->access_token[ $pixel_Id ][ 'ad_account' ] ) ) continue;

			$data = new \stdClass;
			$data->data[] = $event;

			$url = "https://api.pinterest.com/v5/ad_accounts/{$this->access_token[ $pixel_Id ][ 'ad_account' ]}/events";
			$headers = array(
				'Content-Type'  => 'application/json',
				'Authorization' => "Bearer " . $this->access_token[ $pixel_Id ][ 'server_id' ]
			);

			Pinterest()->getLog()->debug( ' Send Pinterest server event', $data );
			try {
				$client = new \PYS_PRO_GLOBAL\GuzzleHttp\Client();
				$response = $client->request( 'POST', $url, [
					'headers' => $headers,
					'body'    => json_encode( $data )
				] );
				Pinterest()->getLog()->debug( ' Response from Pinterest server', $response );

			} catch ( \Exception $e ) {
				Pinterest()->getLog()->error( 'Error send Pinterest server event ' . $e->getMessage() );
			}
		}
	}

	public function mapEventToServerEvent( $event ) {

		$eventData = $event->getData();

		$eventData = EventsManager::filterEventParams( $eventData, $event->getCategory(), [
			'event_id' => $event->getId(),
			'pixel'    => Pinterest()->getSlug()
		] );

		$eventName = $eventData[ 'name' ];
		$wooOrder = isset( $event->payload[ 'woo_order' ] ) ? $event->payload[ 'woo_order' ] : null;
		$eddOrder = isset( $event->payload[ 'edd_order' ] ) ? $event->payload[ 'edd_order' ] : null;

		$user_data = $this->getUserData( $wooOrder, $eddOrder );
		$custom_data = $this->paramsToCustomData( $eventData[ 'params' ] );

		if ( isset( $event->params[ 'uri' ] ) ) {
			$uri = $event->params[ 'uri' ];
		} else {
			$uri = self::getRequestUri( PYS()->getOption( 'enable_remove_source_url_params' ) );

			// set custom uri use in ajax request
			if ( isset( $_POST[ 'url' ] ) ) {
				if ( PYS()->getOption( 'enable_remove_source_url_params' ) ) {
					$list = explode( "?", $_POST[ 'url' ] );
					if ( is_array( $list ) && count( $list ) > 0 ) {
						$uri = $list[ 0 ];
					} else {
						$uri = $_POST[ 'url' ];
					}
				} else {
					$uri = $_POST[ 'url' ];
				}
			}
		}

		$serverEvent = new \stdClass;
		$serverEvent->event_name = $eventName;
		$serverEvent->event_time = time();
		$serverEvent->event_source_url = $uri;
		$serverEvent->action_source = 'website';
		$serverEvent->user_data = $user_data;
		$serverEvent->custom_data = $custom_data;

		if ( isset( $event->payload[ 'eventID' ] ) ) {
			$serverEvent->event_id = $event->payload[ 'eventID' ];
		} else {
			$serverEvent->event_id = '';
		}

		return $serverEvent;
	}

	private function getUserData( $wooOrder = null, $eddOrder = null ) {

		$userData = new \stdClass;

		if ( !$this->access_token ) {
			$this->access_token = Pinterest()->getApiTokens();
		}

		/**
		 * Add purchase WooCommerce Advanced Matching params
		 */
		if ( PixelYourSite\isWooCommerceActive() && isEventEnabled( 'woo_purchase_enabled' ) && ( $wooOrder || ( is_order_received_page() && wooIsRequestContainOrderId() ) ) ) {
			if ( wooIsRequestContainOrderId() ) {
				$order_id = wooGetOrderIdFromRequest();
			} else {
				$order_id = $wooOrder;
			}

			$order = wc_get_order( $order_id );

			if ( $order ) {

				$this->woo_order = $order_id;

				if ( PixelYourSite\isWooCommerceVersionGte( '3.0.0' ) ) {

					if ( $order->get_billing_email() ) {
						$userData->em[] = hash( 'sha256', mb_strtolower( $order->get_billing_email() ), false );
					}

					if ( $order->get_billing_phone() ) {
						$userData->ph[] = hash( 'sha256', preg_replace( '/[^0-9]/', '', $order->get_billing_phone() ), false );
					}

					if ( $order->get_billing_first_name() ) {
						$userData->fn[] = hash( 'sha256', mb_strtolower( $order->get_billing_first_name() ), false );
					}

					if ( $order->get_billing_last_name() ) {
						$userData->ln[] = hash( 'sha256', mb_strtolower( $order->get_billing_last_name() ), false );
					}

					if ( $order->get_billing_city() ) {
						$userData->ct[] = hash( 'sha256', mb_strtolower( preg_replace( '/[^\d|\w]/', '', $order->get_billing_city() ) ), false );
					}

					if ( $order->get_billing_state() ) {
						$userData->st[] = hash( 'sha256', mb_strtolower( $order->get_billing_state() ), false );
					}

					if ( $order->get_billing_postcode() ) {
						$userData->zp[] = hash( 'sha256', $order->get_billing_postcode(), false );
					}

					if ( $order->get_billing_country() ) {
						$userData->country[] = hash( 'sha256', mb_strtolower( $order->get_billing_country() ), false );
					}

				} else {
					if ( $order->billing_postcode ) {
						$userData->zp[] = hash( 'sha256', $order->billing_postcode, false );
					}
					$userData->em[] = hash( 'sha256', mb_strtolower( $order->billing_email ), false );
					$userData->ph[] = hash( 'sha256', preg_replace( '/[^0-9]/', '', $order->billing_phone ), false );
					$userData->fn[] = hash( 'sha256', mb_strtolower( $order->billing_first_name ), false );
					$userData->ln[] = hash( 'sha256', mb_strtolower( $order->billing_last_name ), false );
					$userData->ct[] = hash( 'sha256', mb_strtolower( preg_replace( '/[^\d|\w]/', '', $order->billing_city ) ), false );
					$userData->st[] = hash( 'sha256', mb_strtolower( $order->billing_state ), false );
					$userData->country[] = hash( 'sha256', mb_strtolower( $order->billing_country ), false );
				}
			} else {
				$userData = $this->getRegularUserData();
			}

		} else {

			if ( PixelYourSite\isEddActive() && isEventEnabled( 'edd_purchase_enabled' ) && ( $eddOrder || edd_is_success_page() ) ) {

				$this->edd_order = $eddOrder;

				if ( $eddOrder ) $payment_id = $eddOrder; else {
					$payment_key = getEddPaymentKey();
					$payment_id = (int) edd_get_purchase_id_by_key( $payment_key );
				}
				$user_info = edd_get_payment_meta_user_info( $payment_id );

				$email = edd_get_payment_user_email( $payment_id );
				if ( $email ) {
					$userData->em[] = hash( 'sha256', mb_strtolower( $email ), false );
				}

				if ( isset( $user_info[ 'first_name' ] ) ) $userData->fn[] = hash( 'sha256', mb_strtolower( $user_info[ 'first_name' ] ), false );
				if ( isset( $user_info[ 'last_name' ] ) ) $userData->ln[] = hash( 'sha256', mb_strtolower( $user_info[ 'last_name' ] ), false );

			} else {
				$userData = $this->getRegularUserData();
			}
		}

		$userData->client_ip_address = self::getIpAddress();
		$userData->client_user_agent = self::getHttpUserAgent();

		if ( PixelYourSite\EventsManager::isTrackExternalId() && isset( $_COOKIE[ 'pbid' ] ) ) {
			$userData->external_id[] = $_COOKIE[ 'pbid' ];
		}

		return apply_filters( "pys_pinterest_server_user_data", $userData );
	}

	private function getRegularUserData() {
		$user = wp_get_current_user();
		$userData = new \stdClass;

		if ( $user->ID ) {
			// get user regular data
			$userData->fn[] = hash( 'sha256', mb_strtolower( $user->get( 'user_firstname' ) ), false );
			$userData->ln[] = hash( 'sha256', mb_strtolower( $user->get( 'user_lastname' ) ), false );
			$userData->em[] = hash( 'sha256', mb_strtolower( $user->get( 'user_email' ) ), false );

			/**
			 * Add common WooCommerce Advanced Matching params
			 */
			if ( PixelYourSite\isWooCommerceActive() ) {
				// if first name is not set in regular wp user meta
				if ( empty( $userData->fn[ 0 ] ) ) {
					$userData->fn = hash( 'sha256', mb_strtolower( $user->get( 'billing_first_name' ) ), false );
				}

				// if last name is not set in regular wp user meta
				if ( empty( $userData->ln[ 0 ] ) ) {
					$userData->ln = $user->get( 'billing_last_name' );
				}

				if ( $user->get( 'billing_phone' ) ) $userData->ph[] = hash( 'sha256', preg_replace( '/[^0-9]/', '', $user->get( 'billing_phone' ) ), false );
				if ( $user->get( 'billing_city' ) ) $userData->ct[] = hash( 'sha256', mb_strtolower( preg_replace( '/[^\d|\w]/', '', $user->get( 'billing_city' ) ) ), false );
				if ( $user->get( 'billing_state' ) ) $userData->st[] = hash( 'sha256', mb_strtolower( $user->get( 'billing_state' ) ), false );
				if ( $user->get( 'shipping_country' ) ) $userData->country[] = hash( 'sha256', mb_strtolower( $user->get( 'shipping_country' ) ), false );
				if ( $user->get( 'billing_postcode' ) ) {
					$userData->zp[] = hash( 'sha256', $user->get( 'billing_postcode' ), false );
				}
			}
		} else {

			if ( isset( $_COOKIE[ 'pys_advanced_form_data' ] ) ) {
				$jsonStr = stripslashes( $_COOKIE[ 'pys_advanced_form_data' ] );
				$advancedForm = json_decode( $jsonStr, true );

				if ( isset( $advancedForm[ "email" ] ) && $advancedForm[ "email" ] != "" ) {
					$userData->em[] = hash( 'sha256', mb_strtolower( $advancedForm[ "email" ] ), false );
				}
				if ( isset( $advancedForm[ "phone" ] ) && $advancedForm[ "phone" ] != "" ) {
					$userData->ph[] = hash( 'sha256', preg_replace( '/[^0-9]/', '', $advancedForm[ "phone" ] ), false );
				}
				if ( isset( $advancedForm[ "first_name" ] ) && $advancedForm[ "first_name" ] != "" ) {
					$userData->fn[] = hash( 'sha256', mb_strtolower( $advancedForm[ "first_name" ] ), false );
				}
				if ( isset( $advancedForm[ "last_name" ] ) && $advancedForm[ "last_name" ] != "" ) {
					$userData->ln[] = hash( 'sha256', mb_strtolower( $advancedForm[ "last_name" ] ), false );
				}
			}
		}

		return apply_filters( "pys_pinterest_server_user_data", $userData );
	}

	private function paramsToCustomData( $data ) {

		$custom_data = new \stdClass;
		if ( isset( $data[ 'product_quantity' ] ) ) {
			$data_line_items = array();
			$data_line_items[ 'product_quantity' ] = $data[ 'product_quantity' ];
			if ( isset( $data[ 'product_price' ] ) ) {
				$data_line_items[ 'product_price' ] = $data[ 'product_price' ];
			}
			if ( isset( $data[ 'product_id' ] ) ) {
				$data_line_items[ 'product_id' ] = $data[ 'product_id' ];
			}
			$data[ 'line_items' ][] = $data_line_items;
		}

		if ( isset( $data[ 'line_items' ] ) && is_array( $data[ 'line_items' ] ) ) {
			$contents = array();
			$ids = array();
			$cost = 0;
			$num_items = 0;

			foreach ( $data[ 'line_items' ] as $c ) {
				if ( isset( $c[ 'product_quantity' ] ) ) {
					$contents[] = array(
						'quantity'   => (int) $c[ 'product_quantity' ],
						'item_price' => isset( $c[ 'product_price' ] ) ? strval( $c[ 'product_price' ] ) : null
					);
					$cost += $c[ 'product_quantity' ] * ( $c[ 'product_price' ] ?? 0 );
					$num_items++;
				}

				if ( isset( $c[ 'product_id' ] ) ) {
					$ids[] = strval( $c[ 'product_id' ] );
				}
			}

			$custom_data->contents = $contents;
			$custom_data->value = strval( $cost );
			$custom_data->content_ids = $ids;
			$custom_data->num_items = $num_items;
		} else {
			$custom_data->contents = array();
		}

		if ( isset( $data[ 'currency' ] ) ) {
			$custom_data->currency = $data[ 'currency' ];
		}

		$order_id = ( $this->woo_order !== 0 ) ? $this->woo_order : ( ( $this->edd_order !== 0 ) ? $this->edd_order : 0 );
		if ( $order_id !== 0 ) {
			$custom_data->order_id = strval( $order_id );
		}

		if ( !empty( $_GET[ 's' ] ) ) {
			$custom_data->search_string = $_GET[ 's' ];
		}

		return apply_filters( "pys_pinterest_server_custom_data", $custom_data );
	}

	private static function getRequestUri( $removeQuery = false ) {
		$request_uri = null;

		if ( !empty( $_SERVER[ 'REQUEST_URI' ] ) ) {
			$start = ( isset( $_SERVER[ 'HTTPS' ] ) && $_SERVER[ 'HTTPS' ] === 'on' ? "https" : "http" ) . "://";
			$request_uri = $start . $_SERVER[ 'HTTP_HOST' ] . $_SERVER[ 'REQUEST_URI' ];
		}
		if ( $removeQuery && isset( $_SERVER[ 'QUERY_STRING' ] ) ) {
			$request_uri = str_replace( "?" . $_SERVER[ 'QUERY_STRING' ], "", $request_uri );
		}

		return $request_uri;
	}

	private static function getIpAddress() {
		$HEADERS_TO_SCAN = array(
			'HTTP_CLIENT_IP',
			'HTTP_X_FORWARDED_FOR',
			'HTTP_X_FORWARDED',
			'HTTP_X_CLUSTER_CLIENT_IP',
			'HTTP_FORWARDED_FOR',
			'HTTP_FORWARDED',
			'REMOTE_ADDR'
		);

		foreach ( $HEADERS_TO_SCAN as $header ) {
			if ( array_key_exists( $header, $_SERVER ) ) {
				$ip_list = explode( ',', $_SERVER[ $header ] );
				foreach ( $ip_list as $ip ) {
					$trimmed_ip = trim( $ip );
					if ( self::isValidIpAddress( $trimmed_ip ) ) {
						return $trimmed_ip;
					}
				}
			}
		}

		return "127.0.0.1";
	}

	private static function isValidIpAddress( $ip_address ) {
		return filter_var( $ip_address, FILTER_VALIDATE_IP, FILTER_FLAG_IPV4 | FILTER_FLAG_IPV6 | FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE );
	}

	private static function getHttpUserAgent() {
		$user_agent = null;

		if ( !empty( $_SERVER[ 'HTTP_USER_AGENT' ] ) ) {
			$user_agent = $_SERVER[ 'HTTP_USER_AGENT' ];
		}

		return $user_agent;
	}
}

/**
 * @return PinterestServer
 */
function PinterestServer() {
	return PinterestServer::instance();
}

PinterestServer();