<?php
/**
 * Plugin Name: Object Data Sync For Salesforce Premium
 * Plugin URI: http://miniorange.com
 * Description: Object Data Sync For Salesforce Plugin synchronizes WordPress users with selected object/record in Salesforce and keeps Salesforce object/record in sync with the WordPress.
 * Version: 11.0.3
 * Author: miniOrange
 * License: GPL2
 * License URI: http://www.gnu.org/licenses/gpl-2.0.html 
 */


namespace MoSfSyncSalesforce;

use MoSfSyncSalesforce\API\Salesforce;
use MoSfSyncSalesforce\Integrations\MO_Sf_get_events;
use MoSfSyncSalesforce\Services\Utils;
use MoSfSyncSalesforce\Services\DBUtils;
use MoSfSyncSalesforce\Helper\Instance;
use MoSfSyncSalesforce\Customer;
use MoSfSyncSalesforce\Handler\AccountSetupHandler;
use MoSfSyncSalesforce\Handler\AjaxHandler;
use MoSfSyncSalesforce\Handler\AuthorizationHandler;
use MoSfSyncSalesforce\Handler\ScheduledSyncHandler;
use MoSfSyncSalesforce\Handler\Object_Sync_Sf_WordPress;
use MoSfSyncSalesforce\Handler\OneTimePushHandler;
use MoSfSyncSalesforce\Handler\TaskHandler;
use MoSfSyncSalesforce\Services\AuditDB;
use MoSfSyncSalesforce\Handler\WorkflowIntegration_SF_to_WP;
use MoSfSyncSalesforce\Helper\view\PaidMemberShipProIntegration;
use MoSfSyncSalesforce\Helper\view\UserOnDemandSync;
use MoSfSyncSalesforce\Integrations\IntegrationHooks;
define("\x4d\x4f\x53\x46\x5f\x44\111\x52\103", __DIR__);
include_once __DIR__ . "\x2f\x48\145\154\160\145\x72\x2f\166\x69\x65\167\x2f\126\x69\x65\x77\56\160\150\160";
include_once __DIR__ . "\x2f\110\x65\154\x70\x65\x72\x2f\166\151\x65\167\57\124\x72\x6f\165\142\x6c\145\x73\150\x6f\x6f\x74\x2e\160\x68\x70";
include_once __DIR__ . "\57\110\145\154\160\x65\x72\57\166\x69\145\167\57\x50\x6c\165\x67\x69\156\x47\165\151\x64\145\56\160\x68\x70";
require "\106\x65\145\x64\x62\141\x63\x6b\x46\157\162\155\x2e\160\x68\x70";
require_once ABSPATH . "\167\x70\55\141\x64\155\151\x6e\57\151\x6e\143\x6c\165\144\145\163\57\x69\155\x61\x67\145\55\x65\x64\151\164\56\x70\x68\x70";
require_once __DIR__ . "\x2f\166\145\156\144\x6f\x72\x2f\x61\x75\x74\157\x6c\157\x61\x64\56\x70\x68\160";
include_once __DIR__ . "\x2f\110\x65\154\160\x65\162\x2f\x76\151\145\x77\57\164\145\x6d\x70\154\x61\x74\145\x73\x2f\125\x73\x65\x72\117\156\x44\145\x6d\141\156\x64\123\171\156\143\x2e\x70\150\x70";
class MoSfSync
{
    private static $instance;
    private $pmpro;
    use Instance;
    public static function instance()
    {
        if (isset(self::$instance)) {
            goto fh;
        }
        $q5 = __CLASS__;
        self::$instance = new $q5();
        self::$instance->mo_sf_sync_loadhooks();
        fh:
        return self::$instance;
    }
    private function mo_sf_sync_loadhooks()
    {
        register_activation_hook(__FILE__, array($this, "\155\x6f\x5f\163\x66\137\x73\171\x6e\143\x5f\x70\x6c\x75\147\x69\156\137\x69\156\151\164"));
        if (is_multisite()) {
            goto H2;
        }
        add_action("\141\x64\155\x69\x6e\137\155\145\x6e\x75", array($this, "\155\157\x5f\x73\146\x5f\x73\171\x6e\143\x5f\155\x65\x6e\165"));
        goto zt;
        H2:
        add_action("\156\145\x74\167\157\162\153\137\141\144\155\x69\x6e\x5f\155\145\x6e\x75", array($this, "\155\x6f\x5f\x73\x66\x5f\163\171\x6e\143\x5f\155\x65\156\165"));
        zt:
        add_action("\x77\160\137\x61\x6a\141\x78\x5f\x6d\x6f\x5f\x73\146\137\x73\x79\156\143\x5f\x61\152\141\170\137\163\x75\142\x6d\151\x74", array($this, "\x6d\157\137\x73\146\137\x73\171\x6e\x63\137\141\x6a\x61\170\x5f\x73\165\142\155\x69\164\x5f\150\x61\x6e\144\154\145\x72"));
        add_action("\151\156\x69\x74", array($this, "\x6d\x6f\137\163\x66\137\163\171\x6e\143\x5f\x68\141\156\x64\154\x65\137\141\165\164\x68\137\143\x6f\144\x65"));
        add_action("\x61\144\x6d\151\x6e\x5f\x66\x6f\157\x74\145\x72", array($this, "\155\157\x5f\x73\x66\x5f\163\x79\156\143\137\146\x65\x65\144\142\141\x63\153\137\x72\145\x71\x75\x65\163\x74"));
        add_action("\141\144\155\151\x6e\x5f\151\156\151\164", array($this, "\155\x6f\x5f\x73\x66\x5f\x73\171\x6e\143\137\x73\141\x76\145"));
        $v1 = ScheduledSyncHandler::instance();
        add_action("\x6d\157\137\163\146\x5f\163\x79\156\x63\x5f\x73\143\150\x65\144\165\154\x65\144\x5f\x73\x79\x6e\x63", array($v1, "\155\157\x5f\163\x66\x5f\163\171\x6e\x63\x5f\163\x63\150\x65\144\x75\x6c\145\144\137\163\171\x6e\x63"));
        add_action("\155\157\x5f\163\146\137\x73\171\x6e\143\137\157\x6e\x65\137\x74\x69\155\x65\137\163\171\x6e\x63", array($v1, "\x6d\x6f\137\x73\146\137\x73\x79\x6e\143\x5f\157\x6e\145\x5f\x74\151\x6d\x65\137\x73\171\156\143"), 10, 2);
        add_action("\x6d\x6f\137\x73\146\x5f\x73\171\x6e\x63\137\163\164\x61\162\164\137\155\x75\x6c\164\x69\160\154\x65\x5f\143\162\x6f\x6e\163", array($v1, "\x6d\157\137\x73\x66\137\163\171\156\143\137\x73\164\x61\162\164\x5f\155\165\154\x74\x69\160\x6c\x65\x5f\x63\162\157\x6e\163"), 10, 2);
        add_action("\155\x6f\137\x73\146\137\163\171\x6e\x63\137\x62\165\x6c\x6b\x5f\x73\171\x6e\x63\x5f\x77\x70\x5f\164\x6f\137\163\146", array(OneTimePushHandler::instance(), "\x6d\157\x5f\163\146\x5f\163\171\156\x63\x5f\142\x75\154\x6b\137\160\x75\x73\x68"), 10, 3);
        $nu = Utils::mo_sf_sync_get_settings("\155\x6f\137\x73\x66\x5f\163\171\x6e\x63\137\x70\162\x6f\166\x69\x73\151\x6f\156");
        if (isset($nu["\141\165\164\157\x6d\141\x74\151\143\137\x75\x73\145\x72\137\x75\x70\144\141\x74\x65"])) {
            goto bJ;
        }
        $this->mo_sf_sync_ondemand_manual();
        goto Pc;
        bJ:
        $this->mo_sf_sync_user_profile_management_hooks();
        Pc:
        if (!isset($nu["\x61\165\x74\x6f\155\141\x74\x69\143\137\160\157\163\x74\x5f\x75\x70\x64\141\164\x65"])) {
            goto Aj;
        }
        $this->mo_sf_sync_automatic_post_sync_hooks();
        Aj:
        if (!file_exists(plugin_dir_path(__FILE__) . "\110\145\x6c\x70\x65\162\57\x76\x69\x65\x77\57\120\141\x69\144\x4d\x65\155\x62\145\162\x53\150\x69\x70\120\162\x6f\x49\x6e\164\145\x67\x72\x61\164\x69\x6f\156\x2e\160\150\x70")) {
            goto p9;
        }
        if (!Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto GC;
        }
        add_action("\160\x6d\160\x72\x6f\x5f\141\x64\x64\145\x64\137\x6f\162\x64\145\x72", array($this, "\160\155\160\162\157\x5f\157\162\x64\145\162\x73\x5f\143\162\x65\x61\164\145\144"), 1);
        add_action("\160\x6d\x70\162\x6f\137\165\x70\x64\141\x74\x65\144\x5f\x6f\162\144\145\162", array($this, "\160\155\160\162\157\137\x6f\x72\144\x65\162\x73\x5f\x75\x70\x64\141\164\145\x64"), 1);
        add_action("\x70\155\160\x72\x6f\137\144\x65\x6c\x65\x74\x65\x5f\157\162\x64\x65\162", array($this, "\x70\x6d\x70\x72\x6f\137\157\x72\144\x65\162\163\137\144\x65\154\145\164\x65"), 10, 2);
        GC:
        p9:
        register_deactivation_hook(__FILE__, array($this, "\x6d\157\137\163\x66\x5f\163\x79\156\x63\137\x75\x70\x64\141\x74\x65\x5f\x73\x74\x61\x74\x75\163"));
        $ul = new IntegrationHooks();
        $ul->mo_sf_sync_load_all_integration_hooks();
    }
    public function mo_sf_sync_update_status()
    {
        Customer::mo_sf_sync_update_key_status();
    }
    public function mo_sf_sync_automatic_post_sync_hooks()
    {
        if (!Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto l4;
        }
        add_action("\160\157\163\164\137\x75\160\144\x61\x74\145\144", array($this, "\x6d\x6f\x5f\x73\146\137\x73\x79\156\x63\137\160\x6f\163\x74\x5f\x75\x70\x64\x61\x74\145\x64"), 9, 3);
        l4:
    }
    public function mo_sf_sync_user_profile_management_hooks()
    {
        if (!Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto um;
        }
        if (!array_key_exists("\x6d\x6f\x5f\x73\146\137\x73\x79\156\x63\137\155\141\156\165\141\x6c\x5f\x61\143\x74\151\157\x6e", $_REQUEST)) {
            goto u_;
        }
        $this->mo_sf_sync_ondemand_manual();
        return;
        u_:
        add_action("\x75\x73\x65\x72\x5f\x72\x65\147\x69\163\164\145\x72", array($this, "\x6d\157\x5f\163\146\x5f\x73\171\156\143\137\165\160\144\141\164\x65\137\163\141\x6c\x65\x73\146\157\x72\x63\145"), 10, 2);
        add_action("\x70\162\157\146\151\154\x65\x5f\x75\160\x64\141\164\x65", array($this, "\155\157\x5f\x73\x66\137\163\171\x6e\x63\x5f\x75\x70\144\141\164\x65\x5f\x73\x61\154\145\x73\146\x6f\162\143\x65"), 10, 1);
        add_action("\163\x68\x6f\167\x5f\165\x73\145\162\137\160\x72\157\x66\151\x6c\145", array($this, "\163\x68\x6f\167\137\x73\x61\x6c\x65\x73\146\x6f\x72\143\x65\137\x75\x73\x65\x72\137\146\151\x65\x6c\144\x73"), 10, 1);
        add_action("\145\144\x69\164\x5f\165\163\145\x72\x5f\x70\x72\x6f\146\151\x6c\145", array($this, "\x73\x68\157\x77\137\163\x61\x6c\145\163\146\x6f\162\x63\x65\137\x75\x73\145\x72\x5f\x66\151\145\154\x64\163"), 10, 1);
        um:
    }
    public function mo_sf_sync_ondemand_manual()
    {
        if (!Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto YU;
        }
        add_action("\x73\150\x6f\x77\x5f\x75\163\145\x72\137\x70\162\157\146\151\x6c\x65", array($this, "\x6d\157\137\163\x66\137\x73\171\156\x63\x5f\155\x61\156\165\x61\154\137\x70\165\x73\150\x5f\x74\x6f\x5f\163\x61\154\145\x73\146\x6f\x72\x63\x65"), 10, 1);
        add_action("\x65\x64\x69\164\x5f\165\x73\x65\162\137\x70\162\157\146\151\154\145", array($this, "\155\157\137\x73\x66\137\x73\x79\156\x63\137\x6d\141\156\165\x61\x6c\x5f\x70\165\163\150\x5f\164\157\137\x73\141\x6c\x65\x73\x66\157\x72\x63\145"), 10, 1);
        YU:
    }
    public function pmpro_orders_created($jM)
    {
        PaidMemberShipProIntegration::mo_sf_sync_pmpro_order_create($jM);
    }
    public function pmpro_orders_updated($jM)
    {
        PaidMemberShipProIntegration::mo_sf_sync_pmpro_order_update($jM);
    }
    public function pmpro_orders_delete($dS, $jM)
    {
        PaidMemberShipProIntegration::mo_sf_sync_pmpro_order_delete($dS, $jM);
    }
    public function show_salesforce_user_fields($user)
    {
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto o0;
        }
        return;
        o0:
        $SG = UserOnDemandSync::instance();
        $SG->mo_sf_sync_manual_actions($user->ID);
        return;
    }
    public function mo_sf_widget_manage()
    {
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto v0;
        }
        return;
        v0:
        $v1 = TaskHandler::instance();
        wp_add_dashboard_widget("\x6d\157\137\x53\x66\137\x53\x79\x6e\143\x5f\141\x75\144\x69\164\x5f\167\151\144\x67\145\x74", "\x6d\x69\156\x69\x4f\x72\x61\x6e\x67\x65\x20\117\x62\152\145\143\164\40\104\141\164\x61\40\x53\x79\156\143\x20\146\157\162\x20\123\x61\154\145\163\146\157\x72\x63\145", array($v1, "\155\x6f\137\163\x66\137\163\171\x6e\x63\137\x77\151\x64\147\x65\164\x5f\x63\x6f\156\164\145\x6e\x74"));
    }
    public function mo_sf_sync_plugin_init()
    {
        $pe = new DBUtils();
        $pe->mo_sf_sync_create_mapping_table();
        $this->mo_sf_sync_audit_log();
    }
    public function mo_sf_sync_audit_log()
    {
        $BS = AuditDB::instance();
        $BS->mo_sf_sync_create_audit_log_table();
    }
    public function mo_sf_sync_save()
    {
        $pe = new DBUtils();
        if (!isset($_POST["\155\x6f\x5f\163\x66\x5f\x73\x79\x6e\x63\x5f\x64\145\154\x65\164\145"])) {
            goto mb;
        }
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto Da;
        }
        return;
        Da:
        $pe->mo_sf_sync_delete_object_mapping_using_mapping_label($_POST["\x6d\x6f\137\163\x66\137\163\171\156\143\137\x64\145\x6c\145\164\145"]);
        mb:
        if (!(isset($_POST["\164\141\x62"]) && $_POST["\x74\141\142"] == "\x61\143\x63\157\x75\x6e\x74\137\x73\145\x74\165\160")) {
            goto Qm;
        }
        $v1 = AccountSetupHandler::instance();
        $v1->mo_sf_sync_save_settings();
        Qm:
        if (isset($_POST["\x6f\x70\x74\x69\157\x6e"])) {
            goto bf;
        }
        return;
        bf:
        $H9 = sanitize_text_field($_POST["\x6f\x70\164\x69\x6f\x6e"]);
        switch ($H9) {
            case "\155\x6f\x5f\x73\146\x5f\x73\x79\156\143\x5f\x61\144\166\x61\156\x63\x65\x64\x5f\x72\145\160\157\162\164\x73":
                if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
                    goto yb;
                }
                return;
                yb:
                $BS = AuditDB::instance();
                $BS->mo_sf_sync_save_advance_search_settings();
                goto BZ;
            case "\155\157\137\x73\x66\x5f\163\171\156\x63\x5f\x72\x65\163\x65\x74":
                if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
                    goto AR;
                }
                return;
                AR:
                Utils::mo_sf_sync_reset_plugin();
                goto BZ;
            case "\155\x6f\x5f\163\146\137\x73\171\x6e\x63\x5f\x74\x72\x75\x6e\143\x61\x74\145\x5f\x61\x75\x64\151\x74\x5f\154\x6f\147\163":
                if (check_admin_referer("\x6d\x6f\137\163\146\137\163\171\156\x63\137\164\162\165\156\143\x61\x74\145\x5f\x61\x75\144\151\164\137\x6c\x6f\147\x73")) {
                    goto b7;
                }
                goto BZ;
                b7:
                $BS = AuditDB::instance();
                $BS->mo_sf_sync_clear_all_logs();
                goto BZ;
            case "\155\157\x5f\x73\x66\x5f\163\171\x6e\x63\x5f\143\154\151\x65\x6e\164\137\x63\157\x6e\146\151\x67\x5f\x6f\160\x74\x69\157\156":
                if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
                    goto JU;
                }
                return;
                JU:
                AjaxHandler::instance()->mo_sf_sync_save_config_object($_POST);
                goto BZ;
            case "\155\x6f\x5f\163\146\137\x73\171\x6e\x63\137\143\154\151\145\156\164\137\157\x62\x6a\x65\x63\164":
                if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
                    goto xg;
                }
                return;
                xg:
                $v1 = AjaxHandler::instance();
                $VC = $v1->mo_sf_sync_process_raw_mapping_data($_POST);
                $v1->mo_sf_sync_save_processed_data($VC);
                goto BZ;
            case "\155\x6f\137\x73\x66\x5f\147\x65\x6e\x65\162\x61\164\145\137\141\x63\143\145\x73\x73\x5f\x6b\145\171":
                if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
                    goto Wi;
                }
                return;
                Wi:
                if (!(isset($_POST["\x6d\141\x70\160\x69\156\147\137\154\x61\142\145\x6c"]) && !empty($_POST["\155\x61\160\160\151\x6e\x67\x5f\154\141\142\145\x6c"]))) {
                    goto b6;
                }
                $pe->mo_sf_sync_change_access_key($_POST["\x6d\141\160\160\151\x6e\x67\137\154\141\x62\x65\154"]);
                b6:
                goto BZ;
            case "\155\157\137\x73\146\x5f\163\171\x6e\143\137\x6f\156\145\x5f\164\151\155\x65\x5f\160\x75\163\150\137\157\160\164\x69\157\x6e":
                if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
                    goto jE;
                }
                return;
                jE:
                $Cr = sanitize_text_field($_POST["\155\x6f\x5f\163\146\137\163\171\x6e\x63\137\x6d\x61\x70\x70\x69\x6e\x67\x5f\x69\144"]);
                OneTimePushHandler::instance()->mo_sf_sync_one_time_push_to_salesforce($Cr);
                goto BZ;
            case "\x6d\x6f\x5f\x73\146\137\163\x79\156\143\137\146\x65\x65\x64\x62\x61\x63\x6b":
                $Xr = sanitize_text_field($_POST["\155\x69\x6e\x69\x6f\162\x61\x6e\x67\x65\137\146\x65\145\x64\142\x61\143\x6b\137\x73\x75\x62\155\x69\x74"]);
                $t3 = sanitize_text_field($_POST["\161\x75\x65\162\171\137\x6d\141\x69\154"]);
                $X7 = "\120\x6c\165\147\151\156\x20\104\145\141\143\x74\x69\166\141\164\145\144";
                if ($Xr == "\x53\145\x6e\x64") {
                    goto QW;
                }
                $X7 .= "\54\x20\x46\x65\x65\144\142\141\143\153\72\x20\123\x6b\x69\160\160\x65\144";
                goto Q6;
                QW:
                $np = sanitize_text_field($_POST["\162\x61\164\x65"]);
                $Ln = sanitize_text_field($_POST["\161\x75\x65\x72\x79\137\x66\145\145\144\x62\141\143\153"]);
                $z1 = isset($_POST["\147\x65\164\x5f\162\x65\x70\154\171"]) ? "\171\x65\x73" : "\156\157";
                $X7 .= "\54\x20\x5b\x52\145\x70\x6c\x79\x3a" . $z1 . "\x5d\54\x20\106\x65\x65\144\x62\x61\143\153\72\40" . $Ln . "\x2c\40\133\x52\141\164\x69\x6e\147\72\x20" . $np . "\135";
                Q6:
                $r6 = new Customer();
                $Mv = $r6->mo_sf_sync_send_email_alert($t3, '', $X7);
                deactivate_plugins(__FILE__);
                wp_redirect("\x70\154\x75\x67\151\x6e\163\56\160\150\160");
                goto BZ;
        }
        ad:
        BZ:
    }
    public function mo_sf_sync_feedback_request()
    {
        mo_sf_sync_display_feedback_form();
    }
    public function mo_sf_sync_update_salesforce($vc)
    {
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto TZ;
        }
        return;
        TZ:
        if (!(array_key_exists("\x6d\x6f\137\163\x66\x5f\163\x79\156\143\137\141\163\x73\x69\x67\x6e\137\151\144", $_POST) && !empty($_POST["\x6d\x6f\137\163\146\x5f\x73\171\156\143\137\141\x73\x73\x69\x67\156\137\151\x64"]))) {
            goto GG;
        }
        return;
        GG:
        if (!isset(Utils::mo_sf_sync_get_settings("\155\157\x5f\163\x66\x5f\x73\171\156\143\137\x70\x72\157\166\151\163\151\157\156")["\x61\165\x74\157\155\x61\164\x69\x63\x5f\165\163\x65\x72\137\165\x70\144\x61\164\x65"])) {
            goto ER;
        }
        $v1 = AjaxHandler::instance();
        $Mv = $v1->mo_sf_sync_push_to_salesforce($vc, "\165\163\145\162");
        ER:
    }
    public function mo_sf_sync_manual_push_to_salesforce($vc)
    {
        $SG = UserOnDemandSync::instance();
        if (array_key_exists("\x6d\x6f\x5f\x73\146\x5f\163\x79\156\143\x5f\155\x61\x6e\x75\141\x6c\137\x61\143\164\151\157\x6e", $_REQUEST) && !empty($_REQUEST["\155\x6f\x5f\x73\x66\137\x73\x79\156\x63\137\x6d\141\156\x75\141\154\137\x61\x63\x74\x69\x6f\x6e"])) {
            goto ji;
        }
        $SG->mo_sf_sync_manual_actions($vc->ID);
        goto iO;
        ji:
        $sm = array();
        $sm["\155\157\137\x73\x66\x5f\163\171\156\x63\x5f\155\141\x6e\165\141\154\x5f\x61\143\x74\151\x6f\x6e"] = $_REQUEST["\x6d\x6f\x5f\163\x66\x5f\163\x79\156\143\x5f\155\x61\x6e\x75\x61\154\x5f\x61\143\164\x69\157\156"];
        $sm["\x6d\141\x6e\x75\141\x6c\137\x61\143\x74\x69\157\x6e\163\137\x73\141\154\145\x73\x66\x6f\162\143\x65\x5f\151\144"] = $_REQUEST["\x6d\x61\156\x75\141\x6c\137\x61\x63\164\x69\x6f\156\163\x5f\x73\141\154\x65\163\x66\x6f\162\143\145\x5f\x69\x64"];
        $sm["\155\141\x6e\x75\141\x6c\x5f\141\143\164\151\x6f\156\x73\137\155\141\160\x70\151\156\x67\x5f\154\141\142\x65\x6c"] = $_REQUEST["\x6d\141\156\165\141\x6c\x5f\141\143\164\151\x6f\x6e\163\137\x6d\141\160\160\151\x6e\147\x5f\154\x61\x62\x65\x6c"];
        $SG->mo_sf_sync_manual_actions($vc->ID, $sm);
        $_SERVER["\x52\105\x51\125\x45\x53\124\x5f\125\122\111"] = remove_query_arg(array("\x6d\x6f\x5f\x73\146\137\x73\171\x6e\x63\x5f\x6d\141\156\x75\141\x6c\137\141\x63\164\x69\157\x6e", "\x6d\141\156\165\141\154\x5f\141\x63\x74\x69\157\156\163\x5f\x73\x61\154\x65\x73\146\x6f\x72\x63\x65\x5f\151\x64", "\155\x61\x6e\x75\141\154\x5f\x61\143\164\x69\x6f\156\163\137\x6d\x61\x70\x70\x69\156\x67\x5f\x6c\141\x62\x65\x6c"), $_SERVER["\x52\x45\121\125\105\123\124\x5f\125\122\111"]);
        return;
        iO:
    }
    public function mo_sf_sync_post_updated($dS, $V5, $W6)
    {
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto Hh;
        }
        return;
        Hh:
        $LN = array("\x73\150\x6f\160\137\x6f\162\144\x65\162");
        $Al = get_post_status($dS);
        $zK = get_post_type($dS);
        if (!($Al === "\x70\165\x62\x6c\x69\163\150" || in_array($zK, $LN))) {
            goto hG;
        }
        $zK = get_post_type($dS);
        $pe = new DBUtils();
        $FF = $pe->mo_sf_sync_get_all_wp_to_sf_mappings();
        $ta = false;
        foreach ($FF as $N2) {
            if (!($N2->wordpress_object === $zK)) {
                goto eL;
            }
            $ta = true;
            goto er;
            eL:
            Xg:
        }
        er:
        if (!$ta) {
            goto ms;
        }
        $v1 = AjaxHandler::instance();
        $Mv = $v1->mo_sf_sync_push_to_salesforce($dS, $zK);
        ms:
        hG:
    }
    public function mo_sf_sync_register_salesforce($Hn, $A1, $Wl)
    {
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto ww;
        }
        return;
        ww:
        $hL = Salesforce::instance();
        $Ub = Utils::mo_sf_sync_get_settings("\155\157\137\x73\x66\x5f\x73\171\x6e\143\x5f\x55\163\145\x72");
        $jb = [];
        foreach ($Ub as $N2) {
            $zT = $N2["\x6e\141\x6d\x65"];
            $fj = $N2["\x76\141\x6c\165\145"];
            if (!empty($fj)) {
                goto aQ;
            }
            goto fL;
            aQ:
            if (strpos($zT, "\x63\165\163\164\157\x6d\x5f") !== false) {
                goto qn;
            }
            if (empty($Hn[$zT])) {
                goto zK;
            }
            $jb[$fj] = $Hn[$zT];
            zK:
            goto rr;
            qn:
            $zT = substr($zT, 7);
            $jb[$zT] = $fj;
            rr:
            fL:
        }
        ZJ:
        $Mv = $hL->mo_sf_sync_create_record("\x55\163\145\x72", $jb);
        $lR = '';
        if (isset($Mv["\x69\144"])) {
            goto oU;
        }
        if (!(is_array($Mv) && count($Mv) && isset($Mv[0]["\145\162\x72\157\162\x43\x6f\x64\x65"]) && $Mv[0]["\145\162\x72\157\162\103\157\144\x65"] == "\x44\125\x50\114\111\103\x41\124\x45\x5f\125\x53\x45\x52\x4e\x41\115\105")) {
            goto w3;
        }
        $Mv = $hL->mo_sf_sync_get_record("\125\x73\x65\162\x6e\x61\x6d\x65", $jb["\125\x73\x65\x72\x6e\x61\x6d\x65"], "\x55\x73\145\162");
        $lR = $Mv["\x72\x65\143\157\162\144\163"][0]["\111\144"];
        $jb["\111\163\101\x63\x74\x69\166\x65"] = "\x74\162\x75\145";
        $Mv = $hL->mo_sf_sync_update_record($lR, "\x55\x73\x65\162", $jb);
        w3:
        goto ck;
        oU:
        $lR = $Mv["\x69\x64"];
        ck:
        $fs = Utils::mo_sf_sync_get_settings("\x6d\x6f\137\x73\x66\137\163\171\156\x63\137\x70\162\157\166\151\x73\x69\157\156");
        $Ll = $_POST["\160\141\x73\x73\x31"] ?? $_POST[$fs["\160\x61\x73\x73\167\157\162\x64\137\146\151\x65\154\x64"]] ?? $Hn[$fs["\x70\141\163\163\167\x6f\x72\144\x5f\146\151\145\154\144"]] ?? '';
        if (empty($Ll)) {
            goto l_;
        }
        if (!(!empty($lR) && isset($fs["\160\141\x73\x73\167\x6f\x72\x64\137\163\x79\x6e\x63"]))) {
            goto yi;
        }
        $Mv = $hL->mo_sf_sync_password_sync($lR, $Ll);
        yi:
        l_:
        $Mv = $hL->mo_sf_sync_update_record($lR, "\125\163\x65\162", array("\111\x73\x41\143\x74\x69\x76\145" => "\x66\x61\x6c\163\145"));
    }
    public function mo_sf_sync_menu()
    {
        add_menu_page("\115\151\x6e\151\117\162\141\x6e\x67\x65\x20\123\141\154\x65\163\x66\157\162\x63\x65\40\163\x79\x6e\143" . __("\103\157\x6e\x66\x69\x67\165\162\145\40\x57\x50\x20\123\141\x6c\x65\163\x66\x6f\162\x63\145\40\x4f\x62\152\x65\x63\164\40\123\171\156\143", "\155\157\137\x73\146\137\x73\x79\156\x63"), "\117\142\152\145\x63\164\40\x44\x61\164\141\40\123\x79\x6e\143\x20\x46\x6f\x72\40\x53\x61\x6c\145\163\x66\157\x72\x63\x65", "\x61\x64\x6d\x69\x6e\x69\163\164\x72\x61\x74\157\162", "\x6d\x6f\x5f\163\146\x5f\163\171\x6e\x63", [$this, "\155\157\137\163\146\137\x73\171\x6e\x63\x5f\144\x69\x73\160\154\x61\171"], plugin_dir_url(__FILE__) . "\151\155\x61\147\145\x73\57\x6d\151\x6e\x69\157\x72\141\156\147\145\56\x70\156\147");
        add_submenu_page("\x6d\x6f\137\163\146\x5f\x73\171\156\x63", "\124\162\x6f\x75\142\x6c\145\x73\150\157\x6f\164", "\124\x72\x6f\165\142\154\x65\x73\x68\x6f\157\164", "\x61\x64\x6d\x69\156\151\163\x74\162\x61\164\x6f\x72", "\x74\x72\x6f\x75\142\154\x65\x73\x68\x6f\x6f\164", [$this, "\x6d\x6f\137\163\x66\x5f\163\171\156\x63\x5f\x74\x72\157\165\x62\154\145\163\x68\x6f\157\164"]);
        add_submenu_page("\155\x6f\137\163\146\x5f\163\171\x6e\143", "\103\x6f\156\146\x69\x67\x75\x72\141\x74\151\157\x6e\40\x47\165\151\144\145", "\103\x6f\156\x66\151\147\x75\162\141\164\151\157\156\40\x47\x75\151\144\145", "\141\x64\x6d\151\x6e\151\x73\x74\162\x61\x74\157\x72", "\160\154\x75\x67\x69\156\137\147\165\151\x64\x65", [$this, "\x6d\x6f\137\163\146\137\163\171\156\x63\137\160\x6c\165\x67\x69\x6e\137\147\x75\x69\144\145"]);
        if (!function_exists("\x6d\x6f\x5f\x65\x6d\x70\144\151\162\137\144\151\163\x70\x6c\x61\x79\137\x73\x65\164\x74\x69\x6e\x67\x73")) {
            goto XK;
        }
        add_submenu_page("\x6d\157\x5f\163\x66\x5f\x73\171\x6e\x63", "\x73\146\162\x65\143\157\162\x64", "\x53\141\154\x65\163\x66\157\x72\143\x65\40\122\145\x63\x6f\x72\x64", "\x61\x64\155\x69\156\151\x73\164\162\141\x74\157\162", "\x65\x64\x69\x74\x2e\x70\x68\x70\x3f\x70\x6f\x73\164\137\x74\171\x70\145\75\x73\141\x6c\x65\x73\x66\157\x72\143\x65\x2d\162\145\143\x6f\162\144");
        add_submenu_page("\x6d\157\x5f\x73\x66\137\x73\x79\156\x63", "\x4c\141\x79\x6f\165\x74", "\x4c\x61\x79\x6f\165\164", "\141\144\x6d\x69\156\151\x73\x74\162\141\164\x6f\162", "\x6c\x61\171\157\165\164", "\x6d\157\137\145\155\x70\x64\151\x72\137\144\x69\x73\x70\x6c\141\x79\x5f\163\145\164\164\151\156\147\163");
        XK:
        add_action("\x61\x64\x6d\x69\x6e\x5f\x65\156\161\x75\x65\x75\x65\137\x73\x63\x72\x69\x70\x74\163", [$this, "\x6d\x6f\x5f\163\146\137\x73\171\156\143\x5f\163\x65\164\164\151\x6e\147\x73\x5f\163\x63\162\x69\160\164\163"]);
        add_action("\141\x64\x6d\x69\x6e\137\x65\x6e\x71\x75\x65\x75\x65\x5f\x73\143\162\x69\160\x74\163", [$this, "\x6d\157\137\x73\x66\137\163\x79\156\143\x5f\x73\x65\164\x74\x69\x6e\147\163\137\x73\164\171\154\x65"]);
    }
    public static function mo_sf_sync_display()
    {
        mo_sf_sync_display_view();
    }
    public static function mo_sf_sync_troubleshoot()
    {
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto Ai;
        }
        mo_sf_sync_display_view();
        goto IZ;
        Ai:
        mo_sf_sync_display_trouble_shoot();
        IZ:
    }
    public static function mo_sf_sync_plugin_guide()
    {
        mo_sf_sync_display_plugin_guide();
    }
    public function mo_sf_sync_settings_scripts($k1)
    {
        if (!($k1 != "\164\x6f\x70\154\145\166\x65\154\137\x70\141\147\x65\x5f\x6d\x6f\137\x73\x66\137\x73\171\x6e\143" && $k1 != "\x6f\x62\152\x65\143\164\x2d\x64\141\164\141\x2d\x73\x79\x6e\x63\55\146\x6f\162\x2d\163\141\x6c\x65\163\x66\x6f\162\x63\x65\137\160\141\147\x65\x5f\x74\x72\157\165\142\154\145\163\x68\x6f\x6f\x74" && $k1 != "\165\x73\145\x72\55\145\x64\151\164\x2e\x70\150\x70")) {
            goto jw;
        }
        return;
        jw:
        wp_enqueue_script("\152\x71\165\145\x72\x79");
        wp_enqueue_script("\x73\x65\x6c\145\143\x74\x77\157\157\56\152\x73", plugins_url("\x2f\110\x65\154\x70\145\162\x2f\x76\x69\x65\167\x2f\151\156\143\154\x75\x64\145\163\57\152\x73\x2f\x76\x65\x6e\x64\157\162\57\163\145\154\x65\x63\164\x77\x6f\x6f\56\155\151\156\x2e\x6a\163", __FILE__), ["\152\161\x75\x65\162\171"]);
        wp_enqueue_script("\155\157\x5f\x73\146\137\163\x79\156\x63\137\x73\x61\166\145\137\x73\145\164\164\x69\156\x67\163\x5f\141\152\141\x78", plugins_url("\x2f\x48\x65\x6c\x70\x65\162\x2f\x76\x69\x65\167\57\151\156\x63\x6c\x75\144\x65\x73\57\x6a\x73\x2f\155\x6f\x5f\x73\x66\x5f\163\171\x6e\x63\137\x73\x65\164\x74\x69\x6e\x67\163\x2e\152\x73", __FILE__), ["\x6a\161\165\x65\x72\171", "\163\145\x6c\x65\143\x74\x77\157\157\x2e\152\x73"]);
        wp_enqueue_script("\x6d\157\137\163\146\x5f\163\x79\x6e\143\137\x70\x72\157\x66\151\154\x65\137\164\x61\x62\137\x61\x6a\x61\x78", plugins_url("\x2f\110\x65\x6c\160\145\x72\x2f\166\x69\145\167\57\151\156\x63\154\165\x64\x65\163\57\152\163\57\145\144\x69\164\137\x74\141\x62\56\152\x73", __FILE__), ["\x6a\x71\165\145\x72\x79", "\163\145\154\145\x63\x74\167\157\x6f\56\x6a\163", "\155\157\x5f\x73\x66\x5f\x73\171\x6e\x63\x5f\x73\x61\166\145\137\163\x65\164\164\151\x6e\147\163\x5f\x61\152\x61\x78"]);
        wp_localize_script("\x6d\x6f\137\163\x66\137\163\x79\156\x63\x5f\163\141\166\145\137\163\x65\164\x74\151\156\x67\x73\137\x61\152\141\170", "\141\152\141\x78\137\157\x62\152\x65\x63\164\137\163\x66", array("\141\152\141\170\137\x75\162\154\x5f\163\x66" => admin_url("\57\x61\x64\155\151\x6e\55\x61\x6a\141\x78\x2e\160\x68\160")));
        wp_enqueue_script("\155\157\137\x73\x66\x5f\x73\x79\x6e\143\x5f\144\x61\x74\141\x74\x61\x62\x6c\x65\137\x73\143\x72\151\x70\x74", plugins_url("\110\x65\154\160\145\162\x2f\x76\151\145\167\x2f\x69\156\x63\154\x75\x64\145\x73\x2f\x6a\163\x2f\152\x71\165\x65\x72\x79\56\x64\x61\164\x61\x54\141\142\x6c\x65\x73\56\x6d\151\156\x2e\152\x73", __FILE__), array("\152\x71\x75\x65\x72\171"));
    }
    public function mo_sf_sync_settings_style($k1)
    {
        if (!($k1 != "\164\157\160\154\145\166\145\x6c\x5f\x70\141\x67\145\137\x6d\157\137\163\146\x5f\163\x79\x6e\143" && $k1 != "\x6f\142\x6a\x65\143\164\x2d\144\x61\x74\141\x2d\163\x79\156\143\55\x66\157\162\x2d\163\x61\x6c\x65\x73\146\x6f\x72\143\x65\137\160\141\147\x65\137\164\162\157\x75\142\154\145\163\150\x6f\x6f\164" && $k1 != "\157\142\152\x65\x63\x74\55\144\141\x74\x61\55\x73\171\156\x63\x2d\146\157\162\55\x73\x61\x6c\x65\163\146\x6f\162\143\x65\x5f\x70\141\147\x65\x5f\x70\x6c\x75\x67\151\x6e\137\147\x75\x69\x64\x65")) {
            goto FZ;
        }
        return;
        FZ:
        $WT = plugins_url("\57\x48\145\154\x70\x65\x72\x2f\166\x69\x65\x77\57\x69\156\143\x6c\165\x64\x65\163\x2f\x63\163\163\57\155\x6f\137\x73\146\137\x73\x79\156\143\137\163\x65\x74\164\x69\x6e\x67\163\x2e\x63\x73\x73", __FILE__);
        wp_enqueue_style("\163\x65\x6c\145\x63\x74\x77\157\157\56\x63\x73\163", plugins_url("\x2f\110\145\x6c\x70\x65\x72\57\x76\x69\x65\x77\x2f\151\x6e\143\x6c\165\x64\145\163\x2f\143\x73\163\x2f\x76\x65\x6e\x64\157\162\57\163\x65\x6c\145\x63\x74\167\x6f\157\x2e\155\151\x6e\56\x63\x73\163", __FILE__), array());
        wp_enqueue_style("\x6d\157\x5f\163\x66\x5f\x73\x79\x6e\143\x5f\143\163\x73", $WT, array("\x73\x65\154\x65\x63\x74\167\157\157\x2e\143\x73\x73"));
        wp_enqueue_style("\x6d\x6f\x5f\163\x66\x5f\x73\x79\156\x63\137\144\141\x74\141\164\x61\x62\x6c\x65\x5f\163\164\171\154\x65", plugins_url("\110\x65\x6c\160\x65\162\57\166\x69\x65\167\x2f\151\x6e\x63\x6c\x75\x64\x65\163\x2f\143\163\x73\57\x6a\161\165\x65\162\x79\x2e\144\x61\164\x61\x54\x61\x62\154\145\x73\x2e\x6d\151\156\56\143\163\x73", __FILE__));
    }
    public function mo_sf_sync_ajax_submit_handler()
    {
        $v1 = AjaxHandler::instance();
        $v1->mo_sf_sync_set_settings();
    }
    public function mo_sf_sync_handle_auth_code()
    {
        if (isset($_REQUEST["\x6d\145\164\x68\157\x64"]) && $_REQUEST["\155\x65\x74\x68\x6f\x64"] == "\163\x6f\x61\160") {
            goto AP;
        }
        if (Customer::mo_sf_sync_is_customer_license_key_verified()) {
            goto UA;
        }
        return;
        UA:
        $v1 = AuthorizationHandler::instance();
        $v1->mo_sf_sync_handle_code();
        goto Uk;
        AP:
        remove_action("\x70\157\x73\164\x5f\x75\x70\144\141\x74\x65\x64", array($this, "\x6d\x6f\x5f\x73\x66\137\x73\171\156\x63\137\x70\x6f\163\164\137\165\160\144\x61\164\145\x64"), 9);
        remove_action("\160\x72\x6f\x66\x69\154\145\137\165\160\144\141\x74\x65", array($this, "\155\157\x5f\163\146\x5f\163\171\x6e\x63\x5f\165\160\144\x61\x74\145\x5f\163\x61\154\x65\163\x66\x6f\x72\143\145"), 10);
        remove_all_actions("\160\x61\162\x73\145\x5f\x71\165\145\162\171");
        $v1 = new WorkflowIntegration_SF_to_WP();
        $v1->mo_sf_sync_xml_parser($_REQUEST);
        Uk:
    }
}
MoSfSync::instance();
