
jQuery(document).ready(function(e){

    var fields;
    var field_map=new Map();
    var requiredFields=new Map();
    var object_select = jQuery("#wp_object_select").val();
    var wpfields;
    var taxonomies;
    //TODO optimize these calls to not happen on every page
    mo_sf_sync_get_wp_fields(object_select);
    mo_sf_sync_get_taxonomies();
    mo_sf_sync_fill_users();
    mo_sf_sync_get_meta_fields(object_select);
    
    jQuery('select:not(.mo-sf-sync-simple-select)').selectWoo({
        
    })
	if(jQuery("#object_select").attr("data-object")){
        mo_sf_sync_get_fields(jQuery("#object_select").attr("data-object"))
    }
    function mo_sf_sync_get_fields(object){
        mo_sf_sync_toggle_save()
        let formdata = new FormData()
        formdata.append('object',object);
        formdata.append('action','mo_sf_sync_ajax_submit');
        ajax_request = jQuery.ajax({
           url: ajax_object_sf.ajax_url_sf,
           type: "POST",
           data: formdata,
           processData: false,
           contentType: false
       });
       ajax_request.done((response)=>{ 
            if(response.data.error_description){
               alert(response.data.error_description)
                fields=[];
               return;
           }   
            fields=response.data.fields||[];
            mo_sf_sync_req_fields()

           jQuery(".object_field").each(function(){               
               let u=jQuery(this)
               u.find('option').remove().end()
               u.append(mo_sf_sync_create_fields(u.attr("data-field")))
           })
           
           
           mo_sf_sync_toggle_save()
           /*
           req_fields_presence = jQuery("#set_field_map").length
            if (req_fields_presence == 1) {
                remove_previous()
                fields.forEach((field) => {
                    if (field.createable && !field.nillable && !field.defaultedOnCreate && field.type !== "boolean") {

                        mo_sf_sync_populate_req_fields(field.name);
                    }
                })
            }*/
       });
       
       ajax_request.fail((error)=>{
       });
    }

    function mo_sf_sync_req_fields(){
        fields.sort((a,b)=>{
            if (  a.createable && !a.nillable && !a.defaultedOnCreate  && a.type!=="boolean"  ) 
                return -1;
            if (  b.createable && !b.nillable && !b.defaultedOnCreate  && b.type!=="boolean" ) 
                return 1;
            return 0;
        })
        requiredFields.clear()
        fields.forEach((field)=>{
            if (  field.createable && !field.nillable && !field.defaultedOnCreate && field.type!=="boolean") {
                requiredFields.set(field.name,field.label)
            }
        })        
        field_map.clear()
        fields.forEach(function(element) {
            field_map.set(element.name,element)
        });
    }

    function mo_sf_sync_toggle_save(){
        jQuery(".field-submit").each(function(){
            jQuery(this).prop('disabled', function(i, v) { return !v; })
        });
    }

    function mo_sf_sync_create_fields(u){
        let options="<option value=''>--None--</option>";
        let saved_object = jQuery("#saved_object").attr("data-saved-object")
        let object_select = jQuery("#object_select").val()
        fields.forEach((field)=>{
                options+=`<option value=${field.name} ${saved_object==object_select && u==field.name?"selected":""}>`
                if (  field.createable && !field.nillable && !field.defaultedOnCreate && field.type!=="boolean") {
                    options+=`<span style="color:red;">*</span> `
                }
                options+=`${field.label} (${field.type})</option>`
        })
        return options;
    }

    jQuery("#object_select").on('change',function(){
        let object=jQuery(this).val();
        mo_sf_sync_get_fields(object)
       
        jQuery("#nomenclature_select").each(function(){               
            let u=jQuery(this)
            u.find('option').remove().end()
            u.append(mo_sf_sync_create_meta_fields())
        })
        mo_sf_sync_get_meta_fields(jQuery('#wp_object_select').val())
    })

    jQuery("#wp_object_select").on('change',function(){
        let object=jQuery(this).val();
        mo_sf_sync_get_wp_fields(object)
        mo_sf_sync_get_meta_fields(object);

        if(object === 'user' || object === 'comment' || object === 'catagory' || object === 'tag') {
            jQuery('#taxonomy-sync-section').prop("hidden",true);
        } else {
            jQuery('#taxonomy-sync-section').prop("hidden",false);
        }
    })
    


    function mo_sf_sync_add_loader_class(loader){
        let loader_template = jQuery(".mo-sf-sync-loader-container");
        loader_template.appendTo(loader);
        jQuery('#success_m').addClass('mo-sf-sync-loader');
        jQuery('#error_m').addClass('mo-sf-sync-loader');
        jQuery('#support_m').addClass('mo-sf-sync-loader');
        jQuery('#loader').removeClass('mo-sf-sync-loader');
    }

    function mo_sf_sync_handle_success(result,option_name,loader){ 
        let loader_template = jQuery(".mo-sf-sync-loader-container");
        loader_template.appendTo(loader);
        jQuery('#success_m').addClass('mo-sf-sync-loader');
        jQuery('#error_m').addClass('mo-sf-sync-loader');
        jQuery('#support_m').addClass('mo-sf-sync-loader');
        jQuery('#loader').removeClass('mo-sf-sync-loader');       
        jQuery('#loader').addClass('mo-sf-sync-loader');
        if(result.success == true){
            jQuery("#saved_object").attr("data-saved-object",jQuery("#object_select").val())
            jQuery(".object_field").each(function(){
                jQuery(this).attr("data-field",jQuery(this).val())
            })
            if(option_name === "mo_sf_sync_contact_us_query_option")
                jQuery('#support_m').removeClass('mo-sf-sync-loader')
            else
                jQuery('#success_m').removeClass('mo-sf-sync-loader');
            
            if(option_name === 'mo_sf_sync_client_config_option')
                mo_sf_sync_show_config_window(result.data.state);   
        }else{
            jQuery('#error_m').removeClass('mo-sf-sync-loader');
        }
    }

    function mo_sf_sync_handle_error(error){
        jQuery('#loader').addClass('mo-sf-sync-loader');
        jQuery('#error_m').removeClass('mo-sf-sync-loader');
    }
    jQuery('.mo_sf_sync_ajax_submit_form').submit(function(e){
       e.preventDefault();

       let loader = jQuery(this).find(".loader-placeholder");
       let option_name = jQuery(this).find("input[name='option']").val();
       if(option_name === "mo_sf_sync_client_object"){
           let reqFields = new Map(requiredFields)
           let list = [];
           jQuery(".object_field").each(function(){
               let field = jQuery(this).val()
                if(reqFields.has(field)){
                    reqFields.delete(field)
                } else 
                list.push(jQuery(this).find(":selected").text())
           })
           /*if(reqFields.size){
            alert("Required field missing: "+Array.from(reqFields.values()).join(', '))
            return;
           }*/
           i = 0;
           jQuery(".wordpress_field").each(function(){
               let field = jQuery(this).val()
               if(field === ""){
                   i++;
               }
           })
       if(i){
           alert('Mapping with --none-- ')
           return;
       }
       }
       let nonce_ = jQuery(this).find("input[name='nonce_']").val();
       let tab = jQuery(this).find("input[name='tab']").val(); 
       let dom = jQuery(this).find("input:not([name='option'],[name='tab'],[name='nonce_']), select, textarea")

       let data = (option_name=='mo_sf_sync_client_object')
                    ?   JSON.stringify(dom.serializeArray())
                    :   dom.serialize()

       let formdata = new FormData();
       formdata.append('action','mo_sf_sync_ajax_submit');
       formdata.append('option',option_name);
       formdata.append('tab',tab);
       formdata.append('nonce_',nonce_);
       formdata.append('data',data);
       ajax_request = jQuery.ajax({
           url: ajax_object_sf.ajax_url_sf,
           type: "POST",
           data: formdata,
           processData: false,
           contentType: false,
           beforeSend:function(){
           }
       });
       ajax_request.done(function(result){mo_sf_sync_handle_success(result,option_name,loader)});
       ajax_request.fail(mo_sf_sync_handle_error);
    });

    jQuery('#push_attributes').click(function() {
        let formdata = new FormData() 
        formdata.append('push',jQuery("select[name='upn_id']").val());
        formdata.append('action','mo_sf_sync_ajax_submit');
        ajax_request = jQuery.ajax({
           url: ajax_object_sf.ajax_url_sf,
           type: "POST",
           data: formdata,
           processData: false,
           contentType: false
       });
       ajax_request.done((response)=>{
        if(response.data && Array.isArray(response.data) && response.data[0].message)
            alert(response.data[0].message)
        else if(response.data && response.data.id){
            alert("User created")
        } else if(response.data == "Composite Call Completed")
            alert("Multiple Object Sync Completed!")
        else alert ("User updated")
       });
       ajax_request.fail((error)=>{
           
       });
    })

    jQuery('#search_users').click(mo_sf_sync_fill_users)

    function mo_sf_sync_fill_users() {
        let formdata = new FormData()
        formdata.append('query',jQuery("input[name='query']").val());
        formdata.append('action','mo_sf_sync_ajax_submit');
        ajax_request = jQuery.ajax({
           url: ajax_object_sf.ajax_url_sf,
           type: "POST",
           data: formdata,
           processData: false,
           contentType: false
       });
       ajax_request.done((response)=>{
           if(Array.isArray(response.data)){
               let options="";
               response.data.forEach(function(user){
                    options+=`<option value="${user.data.ID}">${user.data.user_login}</option>`
               })
               jQuery("#upn_id").find('option').remove().end().append(options)
           }
       });
       ajax_request.fail((error)=>{
       });
    }

    jQuery('input[name=password_sync').change(function(){
        let dom = jQuery("#password_field")
        dom.attr('disabled',!this.checked)
    })
    jQuery('input[name=portal_user').change(function(){
        let dom = jQuery("#accountid")
        dom.attr('disabled',!this.checked)
    })

    jQuery("#mo_sf_sync_add_taxonomy_rows").click(function(){
     
        let dom = jQuery("#mo-sf-sync-ṭaxonomy").append(
            `            
            <tr>
                <td class="left-div">
                    <select class="form-control object_field" style="width:300px">
                        ${mo_sf_sync_create_fields()}
                    </select>
                </td>
                <td class="right-div">
                    <select class="form-control wp_field" style="width:100%" onchange="changeTaxonomy(event)">
                        ${mo_sf_sync_create_taxonomy_fields()}
                    </select>
                </td>
                <td>
                    <button class="button del_row_btn mo-sf-btn-cstm" onclick="deleteAttr(event);return false;">DELETE</button>
                </td>
            </tr>
            `
        )  
        dom.children().last().children().find('select').selectWoo({
            
        })
    })

    jQuery("#mo_sf_sync_add_rows").click(function(){
        let dom = jQuery("#mo-sf-sync-custom-attr").append(
            `            
            <tr class="onclick_elements">
                <td class="left-div">
                    <select class="form-control object_field" style="width:300px" name="${jQuery("#mo-sf-sync-fields").first().val()}">
                        ${mo_sf_sync_create_fields()}
                    </select>
                </td>
                <td class="right-div">
                    <select class="form-control wp_field" style="width:100%" onchange="changeWPField(event)">
                        ${mo_sf_sync_create_wp_fields()}
                    </select>
                </td>
                <td>
                        <button class="button del_row_btn mo-sf-btn-cstm" onclick="deleteAttr(event);return false;">DELETE</button>
                </td>
            </tr>
            `
        )  
        dom.children().last().children().find('select').selectWoo({
            
        })
    })

    jQuery("#mo_sf_sync_add_rows_custom").click(function(){
        let dom=jQuery("#mo-sf-sync-custom-attr-val").append(
            `            
            <tr>
                <td class="left-div">
                    <select class="form-control object_field mo_sf_sync_custom" onchange="changeField(event); return false;">
                        ${mo_sf_sync_create_fields()}
                    </select>
                </td>
                <td class="right-div">
                    <input type="text"/>
                </td>
                <td>
                        <button class="button del_row_btn mo-sf-btn-cstm" onclick="deleteAttr(event);return false;">DELETE</button>
                </td>
            </tr>
            `
        )    
        dom.children().last().children().find('select').selectWoo({
            width:"300px"
        })
    })

    window.changeField =function(event){
        let label=event.target.value
        let field= field_map.get(label)
        
        let dom= jQuery(event.target).parent().siblings(".right-div")
        
        if(field.type==="picklist"){
            options=`<select name="custom_${field.name}">`
            field.picklistValues.forEach(({value,label}) => {
                options+=`<option value="${value}">${label}</option>`;
            });
            options+="</select>";
            dom = dom.children().remove().end()
            .append(options)
            dom.find('select').selectWoo({
                width:"100%"
            })
        }
        else if(field.type==='boolean'){
            options=`
            <select name="custom_${field.name}">
                <option>true</option>
                <option>false</option>
            </select>
            `
            dom = dom.children().remove().end()
            .append(options)
            dom.find('select').selectWoo({
                width:"100%"
            })
        } else {            
            dom.children().remove().end()
            .append(`
                <input type="text" name="custom_${field.name}"/>
            `)
        }
    }

    window.changeTaxonomy = function(event) {
        let dom, name;
        dom = jQuery(event.target).parent().siblings().children("select")
        name = jQuery(event.target).val()
        dom.attr("name",'taxonomy_'+name)
    }

    window.changeWPField=function(event){
        let dom, name;
        if(event.target.value === "__custom__"){
            dom = jQuery(event.target).parent()
            dom.replaceWith(`
                <input type="text" name="nomenclature_select" id="nomenclature_select" style="width:300px" onchange="changeWPField(event)"/>
            `)
            return;
        } 
        if(jQuery(event.target).is("input")) {
            dom = jQuery(event.target).siblings().children("select")
        }
        else{
            dom = jQuery(event.target).parent().siblings().children("select")
        }
        name = jQuery(event.target).val()
        dom.attr("name",name)
    }

    window.deleteAttr=function(event){
        let dom = jQuery(event.target).parent().parent().remove()
    }

    selected_radio = jQuery('input[name=env_select]:checked', '#app_config_save_client_configuration').val(); 
    if(!(selected_radio==="undefined"))
        mo_sf_sync_toggle_env_url_field(selected_radio);

    jQuery('#app_config_save_client_configuration input').on('change', function() {
        selected_radio = jQuery('input[name=env_select]:checked', '#app_config_save_client_configuration').val(); 
        mo_sf_sync_toggle_env_url_field(selected_radio);
     });

    function mo_sf_sync_toggle_env_url_field(env_name){
        switch(env_name){
            case 'prod':
                jQuery('input[name=env_link]').prop("readonly",true).hide();
                jQuery('#auth_uri').hide();
                jQuery('input[name=env_link]').prop("value","https://login.salesforce.com");
                break;
            case 'test':
                jQuery('input[name=env_link]').prop("readonly",true).hide();
                jQuery('#auth_uri').hide();
                jQuery('input[name=env_link]').prop("value","https://test.salesforce.com");
                break;
            case 'custom':
                jQuery('input[name=env_link]').prop("readonly",false).show();
                jQuery('#auth_uri').show();
                let cust_url = jQuery('input[name=env_link]', '#app_config_save_client_configuration').val();
                if( jQuery.inArray(cust_url, ["", "https://login.salesforce.com", "https://test.salesforce.com"]) !== -1){
                    jQuery('input[name=env_link]').prop("value","");
                    jQuery('input[name=env_link]').prop("placeholder","Enter custom url here");
                }
                break;
        }
     }

    var is_checked_wp_to_sf = jQuery('#sync_wp_to_sf').is(':checked');
    var is_checked_sf_to_wp = jQuery('#sync_sf_to_wp').is(':checked');
    mo_sf_sync_toggle_for_sf_to_wp_sync(is_checked_wp_to_sf ,is_checked_sf_to_wp);

    jQuery('#sync_wp_to_sf').change(function() {
        var is_checked_sf_to_wp = jQuery('#sync_sf_to_wp').is(':checked');
        mo_sf_sync_toggle_for_sf_to_wp_sync(this.checked, is_checked_sf_to_wp);
     });

    jQuery('#sync_sf_to_wp').change(function() {
        var is_checked_wp_to_sf = jQuery('#sync_wp_to_sf').is(':checked');
        mo_sf_sync_toggle_for_sf_to_wp_sync(is_checked_wp_to_sf, this.checked);
     });

    function mo_sf_sync_toggle_for_sf_to_wp_sync(is_checked_wp_to_sf, is_checked_sf_to_wp){
        if(!is_checked_wp_to_sf && is_checked_sf_to_wp) {
            jQuery('#mo_sf_sync_add_rows_custom').prop("hidden",true);
            jQuery('.mo_sf_sync_add_rows_custom_hidden_text').prop("hidden",false);
            jQuery('#custom-values-titles').prop("hidden",true)
        }else{
            jQuery('#mo_sf_sync_add_rows_custom').prop("hidden",false);
            jQuery('.mo_sf_sync_add_rows_custom_hidden_text').prop("hidden",true);
            jQuery('#custom-values-titles').prop("hidden",false)
        }
    }


    jQuery('#scheduled_user_sync').click(function(e){
        
        toggle = jQuery('input[name=scheduled_user_sync]:checked').val(); 
        if(toggle=='on'){
            jQuery('#scheduled_sync_configuration').prop('hidden',false);
        }else{
            jQuery('#scheduled_sync_configuration').prop('hidden',true);
        }
    });

    jQuery('#conditional_tirgger').click(function(e){
        toggle = jQuery('input[name=conditional_tirgger]:checked').val(); 
        if(toggle=='on'){
            jQuery('#trigger-condition-config').prop('hidden',false);
        }else{
            jQuery('#trigger-condition-config').prop('hidden',true);
        }
    });

    function mo_sf_sync_get_meta_fields(object){
        let formdata = new FormData();
        formdata.append('meta_object',object);
        formdata.append('action','mo_sf_sync_ajax_submit');
        ajax_request = jQuery.ajax({
            url: ajax_object_sf.ajax_url_sf,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false
        });

        ajax_request.done((response)=>{
            if(response.data.error_description){
                alert(response.data.error_description)
                return [];
            }
            meta_fields= response.data;
            jQuery("#nomenclature_select").each(function(){               
                let u=jQuery(this)
                u.find('option').remove().end()
                u.append(mo_sf_sync_create_meta_fields(u.attr("data-field")))
            })
        });

        ajax_request.fail((error)=>{
        });

    }
    function mo_sf_sync_create_meta_fields(u){
        let object = jQuery("#object_select").val()
        let saved_object = jQuery("#saved_nomenclature").attr("data-saved-object")
        let object_select = jQuery("#nomenclature_select").attr("data-object")
           
        if(meta_fields.indexOf("mosfsync_custom_table_selected") === -1){
            var options="<option value='salesforce_"+object+"_ID'>salesforce_"+object+"_ID</option>";
            meta_fields.forEach((meta_field)=>{
                options+=`<option value=${meta_field} ${meta_field==saved_object ?"selected":""}>`
                options+=`${meta_field}</option>`
    
            })
        }
        else{
            meta_fields.pop()
            meta_fields.forEach((meta_field)=>{
                options+=`<option value=${meta_field.key} ${meta_field.key==saved_object ?"selected":""}>`
                options+=`${meta_field.key}(${meta_field.data_type})</option>`
            })
        }
        return options;
    }

    function mo_sf_sync_get_wp_fields(object){
        let formdata = new FormData();
        formdata.append('wp_object',object);
        formdata.append('action','mo_sf_sync_ajax_submit');
        ajax_request = jQuery.ajax({
            url: ajax_object_sf.ajax_url_sf,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false
        });

        ajax_request.done((response)=>{
            if(response.data.error_description){
                alert(response.data.error_description)
                return [];
            }
            wpfields= response.data;
            jQuery(".wp_field").each(function(){               
                let u=jQuery(this)
                u.find('option').remove().end()
                u.append(mo_sf_sync_create_wp_fields(u.attr("data-field")))
            })
        });

        ajax_request.fail((error)=>{
        });

    }

    function mo_sf_sync_get_taxonomies() {
        let formdata = new FormData();
        formdata.append('get_taxonomies','true');
        formdata.append('action','mo_sf_sync_ajax_submit');
        ajax_request = jQuery.ajax({
            url: ajax_object_sf.ajax_url_sf,
            type: "POST",
            data: formdata,
            processData: false,
            contentType: false
        });

        ajax_request.done((response)=>{
            if(response.data.error_description){
                alert(response.data.error_description)
                return [];
            }
            taxonomies = response.data;
        });

        ajax_request.fail((error)=>{
        });
    }

    function mo_sf_sync_create_wp_fields(u){
        let options="<option value=''>--None--</option>";
        let saved_object = jQuery("#saved_object").attr("data-saved-object");
        let object_select = jQuery("#wp_object_select").val();
        wpfields.forEach((wpfield)=>{
            if(wpfield.is_int === undefined){            
                options+=`<option value=${wpfield} ${saved_object==object_select && u==wpfield?"selected":""}>`
                options+=`${wpfield}</option>`
            }
            else{
                options+=`<option value=${wpfield.value}>`
                options+=`${wpfield.key} (${wpfield.type})</option>`
            }

        })
        return options;
    }

    function mo_sf_sync_create_taxonomy_fields(u){
        let options="<option value=''>--None--</option>";
        taxonomies.forEach((taxonomy)=>{
            options+=`<option value=${taxonomy} >`
            options+=`${taxonomy}</option>`

        })
        return options;
    }

    function mo_sf_sync_create_req_fields(requiredField) {

        let options = "<option value=''>--None--</option>";
        let saved_object = jQuery("#saved_object").attr("data-saved-object")
        let object_select = jQuery("#object_select").val()

        fields.forEach((field) => {
            if (field.updateable) {


                if (requiredField == field.name) {
                    options += `<option value=${field.name} selected>`
                } else {
                    options += `<option value=${field.name} >`
                }
                if (field.createable && !field.nillable && !field.defaultedOnCreate && field.type !== "boolean") {

                    options += `<span style="color:red;">*</span> `
                }
                options += `${field.label} (${field.type})</option>`
            }
        })
        return options;
    }

    function mo_sf_sync_populate_req_fields(requiredField) {
        let dom = jQuery("#mo-sf-sync-custom-attr").append(
            `
                    <tr class=" req_elements ">
                        <td class="left-div">
                            <select class="form-control object_field" id="req_test" style="width:300px" name="${jQuery("#mo-sf-sync-wpfields").first().val()}" >
                            ${mo_sf_sync_create_req_fields(requiredField)}
                            </select>
                        </td>
                        <td class="right-div">
                            <select class="form-control wordpress_field" style="width:100%" onchange="changeWPField(event);">
                            ${mo_sf_sync_create_wp_fields()}
                            </select>
                        </td>
                        <td>
                                <button class="button del_row_btn mo-sf-btn-cstm" onclick="deleteAttr(event);return false;">DELETE</button>
                        </td>
                    </tr>

                    `
        )
        dom.children().last().children().find('select').selectWoo({})
    }

    jQuery('#reports_table').DataTable({
        "order": [[ 6, "desc" ]]
    });

    jQuery('#Workflow_table').DataTable({
        "order": [[ 5, "desc" ]]
    });

    jQuery('#save_config').hide()
    jQuery('#test-config').show()
    if(jQuery('#Application_ID').val()){
        mo_sf_sync_show_manual_configuration()
    }
    else
        mo_sf_sync_show_manual_configuration()

});
function showicon(){
    var x = document.getElementById('mo_sf_sync_advanced_search_div');
}

function mo_sf_sync_valid_query(f) {
    !(/^[a-zA-Z?,.\(\)\/@ 0-9]*$/).test(f.value) ? f.value = f.value.replace(
        /[^a-zA-Z?,.\(\)\/@ 0-9]/, '') : null;
}

function mo_sf_sync_show_manual_configuration(){
    jQuery('#Manual_Config').addClass("mo-sf-sync-current")
    jQuery('#Automatic_Config').removeClass("mo-sf-sync-current")
    jQuery('#auto-config').hide()
    jQuery('#manual-config').show()
    jQuery('#save_config').show()
    jQuery('#test-config').show()
    jQuery("input[name='client_id'").prop('required',true)
    jQuery("input[name='client_secret'").prop('required',true)
    jQuery("input[name='redirect_uri'").prop('required',true)
}

function mo_sf_sync_show_automatic_configuration(){
    jQuery('#Automatic_Config').addClass("mo-sf-sync-current")
    jQuery('#Manual_Config').removeClass("mo-sf-sync-current")
    jQuery('#manual-config').hide()
    jQuery('#auto-config').show()
    jQuery('#save_config').hide()
    jQuery('#test-config').show()
    jQuery("input[name='client_id'").prop('required',false)
    jQuery("input[name='client_secret'").prop('required',false)
    jQuery("input[name='redirect_uri'").prop('required',false)
}

function mo_sf_sync_show_config_window(state) {
    function validURL(str) {
        var res = str.match(/(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g);
        return (res !== null);

    }
    let client_id = jQuery("input[name='client_id'").val();
    let redirect_uri = jQuery("input[name='redirect_uri'").val();
    let sf_url = jQuery("input[name='env_link'").val();
    let url = sf_url + `/services/oauth2/authorize?response_type=code&grant_type=authorization_code&scope=api refresh_token&client_id=${client_id}&redirect_uri=${redirect_uri}`+`&state=${state}`;
    if (client_id && redirect_uri && validURL(url))
        var myWindow = window.open(url, "Salesforce Authorization", "scrollbars=1 width=800, height=600");
    else alert(`Invalid client credentials: ${client_id?"":"client id"} ${redirect_uri?"":"redirect uri"}`)
    jQuery('#test-config').prop('disabled',false);
}

function mo_sf_sync_show_config_window_for_pre_connected_app() {
    function validURL(str) {
        var res = str.match(/(http(s)?:\/\/.)?(www\.)?[-a-zA-Z0-9@:%._\+~#=]{2,256}\.[a-z]{2,6}\b([-a-zA-Z0-9@:%_\+.~#?&//=]*)/g);
        return (res !== null);

    }
    let client_id = '3MVG9ZL0ppGP5UrDG2dF37_B5GfUzU3tbowmr0..HKgVi1GwUXgInHAs1YHZ2gW3Sx6NKcGjdI3tmKTzTLK4Y'
    let redirect_uri = 'http://localhost/wptest/wp5/wordpress'
    let sf_url = jQuery("input[name='env_link'").val();
    let customer_url = jQuery("input[name='redirect_uri'").val();
    let url = sf_url + `/services/oauth2/authorize?response_type=code&state=`+customer_url+`&grant_type=authorization_code&scope=api refresh_token&client_id=${client_id}&redirect_uri=${redirect_uri}`;
    if (client_id && redirect_uri && validURL(url))
        var myWindow = window.open(url, "Salesforce Authorization", "scrollbars=1 width=800, height=600");
    else alert(`Invalid client credentials: ${client_id?"":"client id"} ${redirect_uri?"":"redirect uri"}`)
}

function redirect_to_field_mapping() {
    window.location.href = window.location + "&tab=manage_users";
}

function mo_sf_sync_show_test_tab() {
    if (!jQuery('#test-config-tile').isInViewport() || jQuery('#test-config-tile').css('display') == 'none') {
        jQuery('#test-config-tile').css({ 'display': 'block' });
        jQuery('html, body').animate({
            scrollTop: jQuery("#test-config-tile").offset().top
        }, 1000);
    }
}
jQuery.fn.isInViewport = function() {
    var elementTop = jQuery(this).offset().top;
    var elementBottom = elementTop + jQuery(this).outerHeight();

    var viewportTop = jQuery(window).scrollTop();
    var viewportBottom = viewportTop + jQuery(window).height();

    return elementBottom > viewportTop && elementTop < viewportBottom;
};

function check_mapping_label()
{
    let formdata = new FormData()
    formdata.append('label',jQuery("input[name='mapping_label']").val());
    formdata.append('action','mo_sf_sync_ajax_submit');
    ajax_request = jQuery.ajax({
       url: ajax_object_sf.ajax_url_sf,
       type: "POST",
       data: formdata,
       processData: false,
       contentType: false
   });
   ajax_request.done((response)=>{
        if(response.data=="Success") {
            jQuery('#invalid_mapping_label').prop("hidden",true);
            jQuery('#savebutton').prop("disabled",false);
        } else {
            jQuery('#invalid_mapping_label').prop("hidden",false);
            jQuery('#savebutton').prop("disabled",true);
        }
   });
}

function test_config_status(){
    jQuery('#test-config1').prop('disabled',false)
    jQuery('#next-button1').prop('hidden',false)
}

function remove_previous() {
    jQuery(".req_elements").remove();
    jQuery(".onclick_elements").remove();
}

function mo_sf_sync_decide_mapping_id(mapping_id){
    jQuery('#mo_sf_sync_one_time_push_option').append('<input type="hidden" name="mo_sf_sync_mapping_id" value="'+mapping_id+'">')
    jQuery('#mo_sf_sync_one_time_push_option').submit()
}
